#!/usr/local/bin/perl
#
# cafpHTTP 27/07/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;

package cafpUA;
use strict;
 

require LWP::UserAgent;
use LWP::UserAgent;
@cafpUA::ISA = qw(LWP::UserAgent);
 
sub new
{
	my $class = shift;
	my $user = shift;
	my $pass = shift;
 
  	my $self = $class->SUPER::new(@_);
  	$self->{"CafeterraUser"} = $user;
  	$self->{"CafeterraPasswd"} = $pass;
  	$self;
}
 
sub get_basic_credentials
{
        my($self, $realm, $uri) = @_;
        return ($self->{"CafeterraUser"}, $self->{"CafeterraPasswd"});
}

package cafpHTTP;

use connectors::cafProto;
use Net::HTTP;
@cafpHTTP::ISA = ("cafProto");
use strict;


sub _init {
	my $self = shift;

	$self->connected();
}


sub connected {
	my $self = shift;
	my $class = ref($self);

	my $ua = $self->{_HTTPH};

	return $self if($ua);

	my $db = $self->{db};

	my %attrs;
	unless ($ua) {

		my $server = $db->{server}{host_name} ||  $db->{server}{host_address};

		my $cookiesFile = $db->{_ATTRS}{CookiesFile};
		my $cookiesJar = undef;
		$cookiesJar = { file => $cookiesFile, AUTOSAVE => $db->{_ATTRS}{SaveCookies} || undef } if ($cookiesFile and -w $cookiesFile);

		%attrs = (
			#Port        => $db->{server}{port} || undef,
			agent       => $db->{_ATTRS}{UserAgent} || "Cafeterra",
			timeout     => $db->{_ATTRS}{TimeOut} || 180,
			parse_head  => $db->{_ATTRS}{ParseHead} || 1,
			max_size    => $db->{_ATTRS}{MaxSize} || undef,
			cookie_jar  => $cookiesJar,
			keep_alive  => $db->{_ATTRS}{keep_alive} || undef,
		);
		my ($u, $p) = ($self->{db}->{_userid}{username}, $self->{db}->{_userid}{password});
		$ua = $self->{_HTTPH} = cafUA->new($u, $p, %attrs) || die "$class new Net::UserAgent Connection - $server - Failed $@";
	}

	return $self;
}

sub getfile {
	my $self = shift;
	my $filedesc = shift;

	my $class = ref($self);

	unless ($self->connected()) { die "$class openfile : Connection failed"; }

	
	my $connInterval = $self->db->{_ATTRS}{WaitInterval} || 0;

	if ($connInterval > 0) {
		my $lastAcces = $self->{db}{lastAcces} || 0;
		my $interval = time - $lastAcces;
		if ($interval < $connInterval) { sleep ($connInterval - $interval); }
	}

	my $fname = $filedesc->{fname};
	my $dir = $filedesc->{dir} || $self->_dir();
	my $mode = $filedesc->{mode};

	my $ua = $self->{_HTTPH};
	my ($fh, $tempf);

	if (($mode eq 'r') || ($mode eq 'w') || ($mode eq "u")) {
		$tempf = $self->gettemporaryfile(".http", undef, undef, "http");
		my $response;

		for (my $i = $self->db->{_ATTRS}{RetryCount} || 1; $i; $i--) {
			my $url = URI::URL->new($self->GetUrl);
			my $params = $self->GetHttpParams();

			foreach my $paramName (keys %{$params}) {
                        $url->query_form($paramName => $params->{$paramName});
			}
 
			require HTTP::Request;
			require HTTP::Status;
			my $request = HTTP::Request->new($self->{_ATTRS}{Method} => $url);
			$response = $ua->request($request, $tempf);

			next unless (HTTP::Status::is_success($response->{_rc}));

			$self->{HTTP_RESPONSE} = $response;
			$self->{HTTP_HEADER} = $response->headers();
			return ($tempf);
		}
		unless ($response and HTTP::Status::is_success($response->{_rc})) {
			die "IO ERROR : Unable to get remote HTTP file $fname / $response->{_rc}";
		}
	}
	else { die "$class openfile : unsupported mode ($mode)"; }
}

sub listtables {
	my $self = shift;
	my $dir = shift || $self->_dir();
	my $pattern = shift;
 
	return undef;
}

sub protocommit {
	return "0E0"
}

sub protodisconnect {
	my $self = shift;
	my $class = ref($self);

	return "0E0"
}

sub GetHttpParams {
	my $self = shift;
	$self->{db}{__HTTPPARAMS__} || {};
}

sub SetHttpParams {
	my $self = shift;

	if (ref ($_[0]) eq "HASH") {
		my $h = $_[0];
		foreach my $k (keys %{$h}) {
			$self->{db}{__HTTPPARAMS__}{$k} = $h->{$k};
		}
	}
	else {
		while (my $k = shift) {
			$self->{db}{__HTTPPARAMS__}{$k} = shift;
		}
	}
}

sub GetUrl {

	my $self = shift;

	$self->{db}{__URL__};
}

sub SetUrl {
	my $self = shift;

	$self->{db}{__URL__} = shift
}

1;
