#!/usr/local/bin/perl
#
# initialdb.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package geninitialdb;

	my $silent;
	my %config;

	my $httpddirective = "
ScriptAlias /CGIALIAS/ CAFDIR/cgi/
<Directory CAFDIR/cgi>
    AllowOverride None
    Options ExecCGI
    Order allow,deny
    Allow from all
</Directory>

Alias /DOCALIAS/ CAFDIR/site/
<Directory CAFDIR/site/>
    AllowOverride None
    Options Indexes MultiViews
    Order allow,deny
    Allow from all
</Directory>
";
	
	my @seqs = ();
	my @rseqs = ();
	my @qseqs = ();
	my @tables = ();
	my @rtables = ();
	my @qtables = ();

sub processlisttables {
	open DBCONTENT, "<listtables.txt";
	while (<DBCONTENT>) {
		chomp;
		my @line = split (/	/);
		if ($line[1] eq "seq") {
			if (($line[0] =~ /RQ/) or ($line[0] =~ /REF/)) { push @rseqs, $line[2]; }
			if (($line[0] =~ /RQ/) or ($line[0] =~ /QUEUE/)) { push @qseqs, $line[2]; }
			push @seqs, $line[2];
		}
		if ($line[1] eq "table") {
			if (($line[0] =~ /RQ/) or ($line[0] =~ /REF/)) { push @rtables, $line[2]; }
			if (($line[0] =~ /RQ/) or ($line[0] =~ /QUEUE/)) { push @qtables, $line[2]; }
			push @tables, $line[2];
		}
	}
	
	close DBCONTENT;
}

sub geninitialdb {
	processlisttables();
	my $dumpopt = "--attribute-inserts --no-quotes --no-owner --no-reconnect --schema-only --no-acl";
	foreach my $obj (@seqs, @tables) {
		unlink ("$obj.sql");
		system ("pg_dump $dumpopt --table=$obj --file=$obj.sql cafeterraq");
		unless (-f "$obj.sql") {
			system ("pg_dump $dumpopt --table=$obj --file=$obj.sql cafeterra");
		}
	}
	
}


sub initializedb {
	my @args = @ARGV;
	print join(" - ", @args), "\n";
}

sub Question {
	my ($question, $answer) = (shift, shift);

	if ($silent) { return $answer; }

	print "$question [$answer] : ";
	my $ans = <STDIN>;
	chomp $ans;
	return $answer unless ($ans);
	return $ans;
}

sub YesNo {
	my ($question, $answer) = (shift, shift);
	while (1) {
		my $ans = Question($question . " (YES/NO)", $answer);
		$ans = uc($ans);
		if (($ans eq "YES") or ($ans eq "Y")) { return "yes"; }
		elsif (($ans eq "NO") or ($ans eq "N")) { return "no"; }
		print "\n";
	}
}


sub caf_install {

	my $mode = "R";
	$mode = "Q" if ($config{queue});

	my $contextid;
	if ($mode eq "Q") { $contextid = $config{context} || "default"; }

	my $dbname;
	if ($config{dbname}) { $dbname = $config{dbname}; }
	else { $dbname = ($mode eq "Q") ? "cafeterraq" : "cafeterra"; }

	my $dbuser = "aliphe";
	if ($config{dbuser}) { $dbuser =  $config{dbuser}; }

	my $dbpw = "aliphe";
	if ($config{dbpwd}) { $dbuser =  $config{pwd}; }

	$silent = $config{silent};


	my $cgialias = $config{cgialias} || "cafeterra";
	my $docalias = $config{docalias} || "cafsite";
	my $defaulthttpdconf = "/etc/httpd/conf/commonhttpd.conf";
	unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/usr/local/apache/conf/commonhttpd.conf"; }
	unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/usr/local/apache/conf/httpd.conf"; }
	unless (-f $defaulthttpdconf) { $defaulthttpdconf = "/etc/httpd/conf/httpd.conf"; }
	my $httpdconf = $config{httpd} || $defaulthttpdconf; #"/etc/httpd/conf/commonhttpd.conf";

	my $createdb = $config{createdb} || "no";
	my $initializedb = $config{createobjects} || "no";
	my $installperlmod = $config{installpm} || "no";

	use Cwd;
	my $cwd = Cwd::getcwd();
	chdir "../..";
	my $dwd = Cwd::getcwd();
	chdir ($cwd);

	$dwd = Question("Cafeterra Programs Directory", $dwd);

	$dbname = Question("Database Name", $dbname);

	$dbuser = Question("User Name", $dbuser);

	$dbpw = Question("User Password", $dbpw);

	my $dbdsn = $config{dsn} || "dbi:Pg:dbname=$dbname;host=localhost;port=5432";
	$dbdsn = Question("DBI DSN", $dbdsn);

	if ($mode eq "Q") { $contextid = Question("Context Id", $contextid); }

	$createdb = YesNo("Create Database", "no");
	$initializedb = YesNo("Initialize Database Objects", "no");

	$httpdconf = Question("Path (Full Path) to the httpd.conf file", $httpdconf);
	$cgialias = Question("ScriptAlias for Apache httpd.conf file", $cgialias);
	$docalias = Question("Document Alias for Apache httpd.conf file", $docalias);

	$installperlmod = YesNo("Install Necessary Perl Modules", "no");

	if ($createdb eq "yes") {
		system("createuser --createdb --adduser --pwprompt $dbuser");
		system("createdb --username=$dbuser $dbname");
	}


	my $confdir = ($mode eq "Q") ? $contextid : "cgi";

	mkdir "$dwd/$confdir";
	processlisttables();

	my $readmode = $/;
	open IN, "<conf.pm.tpl";
	undef $/;
	my $content = <IN>;
	close IN;
	$content =~ s/CTXTCFG/conf/g if ($mode eq "R");
	$content =~ s/my \$refdsn *= *"dbi:Pg:dbname=cafeterraq;host=localhost;port=5432";/my \$refdsn = "$dbdsn";/;
	$content =~ s/my \$refuser *= *"aliphe";/my \$refuser = "$dbuser";/;
	$content =~ s/my \$refpass *= *"aliphe";/my \$refpass = "$dbpw";/;
	$content =~ s/my \$cafsite *= *"cafsite";/my \$cafsite = "$docalias";/;
	$content =~ s/my \$basedir *= *"\/home\/app\/cafeterra";/my \$basedir = "$dwd";/;
	$content =~ s/my \$contextid *= *"default";/my \$contextid = "$contextid";/;
	open OUT, ">$dwd/$confdir/conf.pm";
	print OUT $content;
	close OUT;

	open IN, "<index.pl.tpl";
	$content = <IN>;
	close IN;

	my $use = $confdir . "::conf";
	$content =~ s/use default::conf;/use $use;/;
	$content =~ s/CTXTCFG/conf/g if ($mode eq "R");

	open OUT, ">$dwd/$confdir/index.pl";
	print OUT $content;
	close OUT;

	$httpddirective =~ s/CGIALIAS/$cgialias/g;
	$httpddirective =~ s/DOCALIAS/$docalias/g;
	$httpddirective =~ s!CAFDIR/cgi!$dwd/$confdir!g;
	$httpddirective =~ s/CAFDIR/$dwd/g;

	open OUT, ">$dwd/$confdir/httpdconf.inc";
	print OUT $httpddirective;
	close OUT;

	chmod 0666, "$dwd/$confdir/httpdconf.inc";

	my $inchttpd = "$dwd/$confdir/httpdconf.inc";

	open IN, "<$httpdconf";
	my $content = <IN>;
	close IN;

	unless ($content =~ /$inchttpd/) {
		open OUT, ">>$httpdconf";
		if ($?) {
			print "Unable to append tro $httpdconf; please add manually this line to your $httpdconf\n";
			print "#Aliases for Cafeterra web interface\nInclude $inchttpd\n";
			print "\n Do not forget to restart apache\n";
		}
		else {
			print OUT "#Aliases for Cafeterra web interface\nInclude $inchttpd\n";
			print "\n\n Do not forget to restart apache\n\n";
			close OUT;
		}
	}

	if ($initializedb eq "yes") {
		my @listobjs;
		if ($mode eq "Q") { @listobjs = (@qseqs, @qtables); }
		elsif ($mode eq "R") { @listobjs = (@rseqs, @rtables); }

		print "OBJECT LIST ", join ("\n - ", @listobjs), "\n";
		foreach my $obj (@listobjs) {
			system("psql -f $obj.sql -q -d $dbname -U $dbuser");
		}

		foreach my $dfile (qw(d_cafusers d_context d_attrdef d_driver d_protocol d_datatype)) {
			system("psql -f $dfile.sql -q -d $dbname -U $dbuser");
		}
	}

	if ($installperlmod eq "yes") {
		require 'pminstall.pl';
		PMINSTALL::installmodules($silent);
	}
}


sub Usage {
	die "\nUsage\n\n/usr/local/bin/perl $0 --help --queue --dsn=s --createdb --dbname=s --dbuser=s --dbpw=s --createobjects
        --context=s --generate --silent --basedir=s --httpd=s --cgialias=s --docalias=s --installpm

	--help                  display this screen
	--queue                 init a cafeterra queue enviroennement
	--dsn=s                 DBI DSN for the repository or queue database
                                         (default is \"dbi::Pg:host=localhost;dbname=\$dbname;port=5432\")
	--createdb              Create database (local database only)
	--dbname=name           Database name (default is cafeterra if you are creating a repository or
                                               cafeterraq for queue database)
	--dbuser=user           Database user name (default aliphe)
	--dbpw=password         Database user password (default is aliphe)
	--createobjects         Createi cafeterra objects and insert initial data
	--context=s             For queue environnement only the context name (4 character only)
	--silent                Do not ask question
	--basedir=/path/to/caf  Full path to the cafeterra installation directory default is calculated from the
                                               path of this script
	--httpd=/.../httpd.conf Full path to httpd.conf file (or commonhttpd.conf depending on your apache installation)
	--cgialias=s            Cgi Alias to cgi dir
	--docalias=s            Dir alias to site directory (for images and scripts)
	--installpm             Install common Perl Modules
";

}

use Getopt::Long;
#Getopt::Long::GetOptions(\%config, "install", "queue", "dbname=s", "aliphepw=s", "context=s", "generate", "silent", "basedir=s");
unless (Getopt::Long::GetOptions(\%config, "queue", "dsn=s", "createdb", "dbname=s", "dbuser=s", "dbpw=s", "createobjects",
		"context=s", "silent", "basedir=s", "httpd=s", "cgialias=s", "docalias=s", "installpm",
		"help", "generate", "install")) { Usage (); };

if ($config{help}) { Usage (); }
elsif ($config{install} && $config{generate}) { Usage (); }
elsif ($config{generate}) { geninitialdb(); }
else { caf_install (); }

=cut
if ($ARGV[0] eq "generate") {
	geninitialdb();
}
else {
	if ($ARGV[0] ne "install") { unshift @ARGV, "install"; }
	if ($#ARGV < 1) {
		Usage ();
	}

	my $mode = uc($ARGV[1]);
	if ($mode eq "Q") { $contextid = $ARGV[4] || "default"; }
	if ($mode eq "Q") { $dbname = $ARGV[2] || "cafeterraq"; }
	my $dbname = $ARGV[2] || "cafeterra";
	my $dbuser = $ARGV[3] || "aliphe";
	if ($0 eq "silent.pm") { $silent = "YES"; }

	my $dwd;
	my $dbdsn = "dbi:Pg:dbname=$dbname;host=localhost;port=5432";
	my $dbpw = "aliphe";
	my $cgialias = "cafeterra";
	my $docalias = "cafsite";
	my $httpdconf = "/etc/httpd/conf/commonhttpd.conf";
	my $contextid = ($mode eq "Q") ? "default" : "";
	my $httpddirective = "
ScriptAlias /CGIALIAS/ CAFDIR/cgi/
<Directory CAFDIR/cgi>
    AllowOverride None
    Options ExecCGI
    Order allow,deny
    Allow from all
</Directory>

Alias /DOCALIAS/ CAFDIR/site/
<Directory CAFDIR/site/>
    AllowOverride None
    Options Indexes MultiViews
    Order allow,deny
    Allow from all
</Directory>
";

	use Cwd;
	my $cwd = Cwd::getcwd();
	chdir "../..";
	my $dwd = Cwd::getcwd();
	chdir ($cwd);

	$dwd = Question("Cafeterra Programs Directory", $dwd);

	$dbname = Question("Database Name", $dbname);

	$dbuser = Question("User Name", $dbuser);

	$dbpw = Question("User Password", $dbpw);

	$dbdsn = "dbi:Pg:dbname=$dbname;host=localhost;port=5432";
	$dbdsn = Question("DBI DSN", $dbdsn);

	if ($mode eq "Q") { $contextid = Question("Context Id", $contextid); }

	my $createdb = YesNo("Create Database", "no");
	my $initializedb = YesNo("Initialize Database Objects", "no");

	$httpdconf = Question("Path (Full Path) to the httpd.conf file", $httpdconf);
	$cgialias = Question("ScriptAlias for Apache httpd.conf file", $cgialias);
	$docalias = Question("Document Alias for Apache httpd.conf file", $docalias);

	my $installperlmod = YesNo("Install Necessary Perl Modules", "no");

	if ($createdb eq "yes") {
		system("createuser --createdb --adduser --pwprompt $dbuser");
		system("createdb --username=$dbuser $dbname");
	}


	my $confdir = ($mode eq "Q") ? $contextid : "cgi";

	mkdir "$dwd/$confdir";
	processlisttables();

	my $readmode = $/;
	open IN, "<conf.pm.tpl";
	undef $/;
	my $content = <IN>;
	close IN;
	$content =~ s/CTXTCFG/conf/g if ($mode eq "R");
	$content =~ s/my \$refdsn *= *"dbi:Pg:dbname=cafeterraq;host=localhost;port=5432";/my \$refdsn = "$dbdsn";/;
	$content =~ s/my \$refuser *= *"aliphe";/my \$refuser = "$dbuser";/;
	$content =~ s/my \$refpass *= *"aliphe";/my \$refpass = "$dbpw";/;
	$content =~ s/my \$cafsite *= *"cafsite";/my \$cafsite = "$docalias";/;
	$content =~ s/my \$basedir *= *"\/home\/app\/cafeterra";/my \$basedir = "$dwd";/;
	$content =~ s/my \$contextid *= *"default";/my \$contextid = "$contextid";/;
	open OUT, ">$dwd/$confdir/conf.pm";
	print OUT $content;
	close OUT;

	open IN, "<index.pl.tpl";
	$content = <IN>;
	close IN;

	my $use = $confdir . "::conf";
	$content =~ s/use default::conf;/use $use;/;
	$content =~ s/CTXTCFG/conf/g if ($mode eq "R");

	open OUT, ">$dwd/$confdir/index.pl";
	print OUT $content;
	close OUT;

	$httpddirective =~ s/CGIALIAS/$cgialias/g;
	$httpddirective =~ s/DOCALIAS/$docalias/g;
	$httpddirective =~ s/CAFDIR/$dwd/g;

	open OUT, ">$dwd/$confdir/httpdconf.inc";
	print OUT $httpddirective;
	close OUT;

	chmod 0666, "$dwd/$confdir/httpdconf.inc";

	my $inchttpd = "$dwd/$confdir/httpdconf.inc";

	open IN, "<$httpdconf";
	my $content = <IN>;
	close IN;

	unless ($content =~ /$inchttpd/) {
		open OUT, ">>$httpdconf";
		if ($?) {
			print "Unable to append tro $httpdconf; please add manually this line to your $httpdconf\n";
			print "#Aliases for Cafeterra web interface\nInclude $inchttpd\n";
			print "\n Do not forget to restart apache\n";
		}
		else {
			print OUT "#Aliases for Cafeterra web interface\nInclude $inchttpd\n";
			print "\n\n Do not forget to restart apache\n";
			close OUT;
		}
	}

	if ($initializedb eq "yes") {
		my @listobjs;
		if ($mode eq "Q") { @listobjs = (@qseqs, @qtables); }
		elsif ($mode eq "R") { @listobjs = (@rseqs, @rtables); }

		print "OBJECT LIST ", join ("\n - ", @listobjs), "\n";
		foreach my $obj (@listobjs) {
			system("psql -f $obj.sql -q -d $dbname -U $dbuser");
		}

		foreach my $dfile (qw(d_cafusers d_context d_attrdef d_driver d_protocol d_datatype)) {
			system("psql -f $dfile.sql -q -d $dbname -U $dbuser");
		}
	}

	if ($installperlmod eq "yes") {
		require 'pminstall.pl';
		PMINSTALL::installmodules();
	}
}

