#!/usr/local/bin/perl
#
# FlowTls.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
 
package FlowRt;

require Data::Dumper;
use strict;
=cut
$class = {
	cfg              => CronData
	timeLastLoad     => 
	epochLastLoad    => 
	objectHierarchy  => object
	dataBasesHandles => []
	queueDbhAuto     => Autocommitted queueDatabase
	queueDbh         => queueDb for flow concerns
	varsValues       => { ObjectId => {}}
	specialVars      => { ObjectId => {}}
	incomFlows       => { subFlowId => object }
	outgoFlows       => { subFlowId => object }
	incomFlowIds     => []
	outgoFlowIds     => []
	scriptClosure    => { scriptId => ScriptRt Object }
};
=cut


sub TimeLastLoad {
	my $self = shift;

	unless ($SchedRt::classVars->{timeLastLoad}) {
		$SchedRt::classVars->{timeLastLoad} = cafUtils->datetime1(1);
		$SchedRt::classVars->{epochLastLoad} = 1;
	}
	if (@_) {
		my $time = $SchedRt::classVars->{timeLastLoad} = shift;
		$SchedRt::classVars->{epochLastLoad} = Time::ParseDate::parsedate($time, UK => 1);
	}
	$SchedRt::classVars->{timeLastLoad};
}

sub EpochLastLoad {
	my $self = shift;

	unless ($SchedRt::classVars->{timeLastLoad}) {
		$SchedRt::classVars->{timeLastLoad} = cafUtils->datetime1(1);
		$SchedRt::classVars->{epochLastLoad} = 1;
	}
	if (@_) {
		my $time = $SchedRt::classVars->{epochLastLoad} = shift;
		$SchedRt::classVars->{timeLastLoad} = cafUtils->datetime1($time);
	}
	$SchedRt::classVars->{epochLastLoad};
}

sub QueueDbhAutocommit {
	my $self = shift;

	if (@_) { $SchedRt::classVars->{queueDbhAutocommit} = shift; }
	$SchedRt::classVars->{queueDbhAutocommit};
}

sub QueueDbh {
	my $self = shift;

	if (@_) { $SchedRt::classVars->{queueDbh} = shift; }
	$SchedRt::classVars->{queueDbh};
}

sub QueueInactiveDestroy {
	my $self = shift;

	my $dbh = $SchedRt::classVars->{queueDbh};
	if (@_) {
		my $inactiveDestroy = shift;
		$dbh->DbhInactiveDestroy($inactiveDestroy);
		$dbh = $SchedRt::classVars->{queueDbhAutocommit};
		$dbh->DbhInactiveDestroy($inactiveDestroy);
		$SchedRt::classVars->{inactiveDestroy} = $inactiveDestroy;
	}
	$SchedRt::classVars->{inactiveDestroy};
}

sub QueueConnect {
	my $self = shift;

	unless ($self->QueueDbhAutocommit()) {
		my %qdb = %{CTXTCFG->refdb()};

		my %user = ( username => $qdb{user}{username}, password => $qdb{user}{password});
		$qdb{user} = \%user;

		my %qattrs;
		foreach my $k (keys %{$qdb{_ATTRS}}) {
			$qattrs{$k} = $qdb{_ATTRS}{$k};
		}
		$qattrs{PrintError} = undef; $qattrs{RaiseError} = 1; $qattrs{AutoCommit} = 1;
		$qdb{_ATTRS} = \%qattrs;

		my $qDbh = refDBI->Connect(\%qdb) || die "Can't connect(1) to Queue Database \n $@";
		die "Unable to connect to queue Database : " . refDBI->errstr() unless ($qDbh);
		$self->QueueDbhAutocommit($qDbh);
#		$self->LogSysTrace("Conneted AutoCommit $qDbh");
	}

	unless ($self->QueueDbh()) {

		my %qdb = %{CTXTCFG->refdb()};
#		my %user = $qdb{user} || ();
		my %user = ( username => $qdb{user}{username}, password => $qdb{user}{password});
		$qdb{user} = \%user;

#		my %qattrs = $qdb{_ATTRS} || ();
		my %qattrs;
		foreach my $k (keys %{$qdb{_ATTRS}}) {
			$qattrs{$k} = $qdb{_ATTRS}{$k};
		}
		$qattrs{PrintError} = undef; $qattrs{RaiseError} = 1; $qattrs{AutoCommit} = undef;
		$qdb{_ATTRS} = \%qattrs;

		my $qDbh = refDBI->Connect(\%qdb) || die "Can't connect(2) to Queue Database \n $@";
		die "Unable to connect to queue Database : " . refDBI->errstr() unless ($qDbh);
		$self->QueueDbh($qDbh);
#		$self->LogSysTrace("Conneted No AutoCommit $qDbh");
	}
}

sub QueueDisconnect {
	my $self = shift;

	if (my $qDbh = $self->QueueDbhAutocommit()) { $qDbh->disconnect(); $self->QueueDbhAutocommit(undef); }
	if (my $qDbh = $self->QueueDbh()) { $qDbh->rollback(); $qDbh->disconnect(); $self->QueueDbh(undef); }
}

sub ObjectHierarchy {
	my $self = shift;
 
	if (@_) { $SchedRt::classVars->{objectHierarchy} = shift; }

	return $SchedRt::classVars->{objectHierarchy};
}

sub GetContext {
	my $self = shift;
	my $force = shift;

#	if ((! $SchedRt::classVars->{context}) or ($force)) {
	my $context = $self->MyContext();
	if ((! $context) or ($force)) {
		my $contextId = $self->MyContextId();
		my $dbh = $self->QueueDbhAutocommit();
 
		my $query = $dbh->newquery({ contextid => $contextId });
		$query->scontextlist();
		$context = $self->MyContext($dbh->hexecfetchrownop($query, 1));
#		$SchedRt::classVars->{context} = $dbh->hexecfetchrownop($query, 1);
	}

	$context;
}

sub ObjectsNotUpToDate {
	my $self = shift;

	my $dbh = $self->QueueDbhAutocommit();

	my $query = $dbh->newquery({ owner_id => $self->MyFlowId(), modified => $self->TimeLastLoad(), });
	$query->swobjectobjects();
	my $objToUpdate = $dbh->hexecfetchall($query);
	return $objToUpdate;
}

sub ObjectHierarchy {
	my $self = shift;

	if (@_) { $SchedRt::classVars->{objectHierarchy} = shift; }
	$SchedRt::classVars->{objectHierarchy};
}

sub ObjectVar {
	my $self = shift;
	my $objid = shift;
	my $varname = shift;
	$varname = lc($varname);

	if (@_) { $SchedRt::classVars->{varsValues}{$objid}{$varname} = shift; }

	$SchedRt::classVars->{varsValues}{$objid}{$varname};
}

sub SpecialVar {
	my $self = shift;
	my $objid = shift;
	my $varname = shift;

	$varname = lc($varname);
	if (@_) { $SchedRt::classVars->{specialVars}{$objid}{$varname} = shift; }

	$SchedRt::classVars->{specialVars}{$objid}{$varname};
}

sub GlobalVar {
	my $self = shift;

	$self->ObjectVar(-1, @_);
}

sub FlowVar {
	my $self = shift;

	$self->ObjectVar($SchedRt::classVars->MyFlowId(), @_);
}

sub SubFlowVar {
	my $self = shift;

	$self->ObjectVar($self->MyId(), @_);
}

sub TempVar {
	my $self = shift;
	my $varname = shift;

	$varname = lc($varname);
	if(@_) { $SchedRt::classVar->{tempVar}{$varname} = shift; }
	$SchedRt::classVar->{tempVar}{$varname};
}

sub InitSystemVars {
	my $self = shift;

	$SchedRt::classVars->{_System} = {};

	my $objHier = $self->ObjectHierarchy();
	my $flow = $objHier->getdata($self->MyFlowId());
	$SchedRt::classVars->{_System}{commitinterv} = $flow->{commitinterv} || 1;
	$SchedRt::classVars->{_System}{incomrel} = $flow->{incomrel};
	$SchedRt::classVars->{_System}{bufferedflow} = $flow->{bufferedflow};
 #	$SchedRt::classVars->{_System}{runId} = undef;
 #	$SchedRt::classVars->{_System}{startedTime} = undef;
	$SchedRt::classVars->{scriptClosures} = {};

	foreach my $objId (keys %{$SchedRt::classVars->{scriptRt}}) {
		foreach my $scriptId (keys %{$SchedRt::classVars->{scriptRt}{$objId}}) {
			my $scriptRt = $SchedRt::classVars->{scriptRt}{$objId}{scriptId};
			$scriptRt->DestroyScript() if ($scriptRt);
			$SchedRt::classVars->{scriptRt}{$objId}{$scriptId} = undef;
		}
	}
	$SchedRt::classVars->{scriptRt} = {};

	foreach my $objId (keys %{$SchedRt::classVars->{formulaScriptRt}}) {
		foreach my $scriptId (keys %{$SchedRt::classVars->{formulaScriptRt}{$objId}}) {
			my $scriptRt = $SchedRt::classVars->{formulaScriptRt}{$objId}{scriptId};
			$scriptRt->DestroyScript() if ($scriptRt);
			$SchedRt::classVars->{formulaScriptRt}{$objId}{$scriptId} = undef;
		}
	}
	$SchedRt::classVars->{formulaScriptRt} = {};

	$SchedRt::classVars->{mappingList} = {};

	foreach my $objId (@{$objHier->allobjects()}) {
		my $object = $objHier->getobject($objId);
		$SchedRt::classVars->{objectsById}{$objId} = $object->{name};
		my $name = $object->{name};
		my $type = $object->{type};
		$SchedRt::classVars->{objectsByName}{$type}{$name} = $objId;
	}
}

sub SaveVars {
	my $self = shift;

#	$self->LogSysTrace("SaveVars :");
	my $dbh = $self->QueueDbhAutocommit();
	my $query = $dbh->newquery();
	local $Data::Dumper::Indent = 0;
	foreach my $varCat ("specialVars", "varsValues") {
		$varCat; # = lc ($varCat);
		my $vars = $SchedRt::classVars->{$varCat};
		foreach my $objId (keys %{$vars}) {
			my $ret;
			my ($varName, $varValue);
			while (($varName, $varValue) = each %{$vars->{$objId}}) {
				next unless ($varValue);
				my $dataType = 'SCALAR';
				if (ref($varValue) =~ /HASH|ARRAY/) {
					$dataType = ref($varValue);
					$varValue = Dumper->Dump([$varValue], ["varValue"]);
				}
				$query = $dbh->newquery({varid => $varName, varvalue => $varValue, datatype => $dataType, specialvar => $varCat, object_id => $objId});
				$query->uwvars();
				$ret = $dbh->executefinish($query);
#				$self->LogSysTrace("	 SaveVars $objId - $varName $varValue ($ret)");
				unless ($ret > 0) { $query->iwvars(); $ret = $dbh->executefinish($query); }
			}
		}
	}
}

sub ReadVars {
	my $self = shift;
	my $objId = shift;

	my $dbh = $self->QueueDbhAutocommit();
	my $query = $dbh->newquery({ object_id => $objId });

	$query->swvarslist();

	$dbh->execute($query);

	while (my $row = $dbh->hfetchrownop($query)) {
		my $varValue = $row->{varvalue};
		my $varName  = $row->{varid};

		if ($row->{datatype} ne "SCALAR") {	eval $row->{varvalue}; }
		if ($row->{specialvar} eq "specialVars") { $self->SpecialVar($objId, $row->{varid}, $varValue); }
		else { $self->ObjectVar($objId, $row->{varid}, $varValue); }
#				$self->LogSysTrace("	 ReadVars $objId - $varName $varValue ");
	}
}

sub ObjectNameById {
	my $self = shift;
	my $objId = shift;

	$SchedRt::classVars->{objectsById}{$objId};
}

sub ObjectIdByName {
	my $self = shift;
	my $type = shift;
	my $name = shift;

	$SchedRt::classVars->{objectsByName}{$type}{$name};
}

sub IncomRelType {
	my $self = shift;

	$SchedRt::classVar->{_System}{incomrel};
}

sub CommitInterval {
	my $self = shift;

	$SchedRt::classVar->{_System}{commitinterv};
}

sub DirectFlow {
	my $self = shift;

#	$self->LogSysTrace("DirectFlow ? => $SchedRt::classVars->{_System}{bufferedflow}");
	return ($SchedRt::classVars->{_System}{bufferedflow} ne 'yes');
}

sub FlowDirection {
	my $self = shift;
	my $subflowId;
	if (@_) { $subflowId = shift; }
	else { $subflowId = $self->MyId(); }

	my $objHier = $self->ObjectHierarchy();
	my $dir = $objHier->flowdir($subflowId);
}

sub IncomSubFlowIds {
	my $self = shift;

	my $objHier = $self->ObjectHierarchy();
	my $incomSubFlowIds = $objHier->myincomflows($self->MyFlowId());
	my @ret;
	foreach my $incomSubFlowId (@$incomSubFlowIds) {
		if ($SchedRt::classVars->{incomFlows}{$incomSubFlowId}) { push  @ret, $incomSubFlowId; }
	}
	\@ret;
}

sub OutgoSubFlowIds {
	my $self = shift;

	my $objHier = $self->ObjectHierarchy();
	my $outgoSubFlowIds = $objHier->myoutgoflows($self->MyFlowId());
	my @ret;
	foreach my $outgoSubFlowId (@$outgoSubFlowIds) {
		if ($SchedRt::classVars->{outgoFlows}{$outgoSubFlowId}) { push  @ret, $outgoSubFlowId; }
	}
	\@ret;
}

sub IncomSubFlows {
	my $self = shift;

	my $objHier = $self->ObjectHierarchy();
	my $incomSubFlowIds = $objHier->myincomflows($self->MyId);
	my @ret;
	foreach my $incomSubFlowId (@$incomSubFlowIds) {
		if ($SchedRt::classVars->{incomFlows}{$incomSubFlowId}) { push  @ret, $SchedRt::classVars->{incomFlows}{$incomSubFlowId}; }
	}
	wantarray ? @ret : \@ret;
}

sub OutgoSubFlows {
	my $self = shift;

	my $objHier = $self->ObjectHierarchy();
	my $outgoSubFlowIds = $objHier->myoutgoflows($self->MyId);
	my @ret;
	foreach my $outgoSubFlowId (@$outgoSubFlowIds) {
		if ($SchedRt::classVars->{outgoFlows}{$outgoSubFlowId}) { push  @ret, $SchedRt::classVars->{outgoFlows}{$outgoSubFlowId}; }
	}
	wantarray ? @ret : \@ret;
}

sub CloseAllSubFlows {
	my $self = shift;
	my $objid = shift;

	my $incomSubFlowIds = $self->IncomSubFlowIds() || [];
	foreach my $subFlowId (@$incomSubFlowIds) { #(keys %{$SchedRt::classVars->{incomFlows}}) {
		my $subFlow = $SchedRt::classVars->{incomFlows}{$subFlowId};
		if ($subFlow) {
			$self->LogSysTrace("Closing $subFlowId");
#			$subFlow->IFinished();
			$subFlow->CloseSubFlow();
			delete $SchedRt::classVars->{incomFlows}{$subFlowId} if ($subFlow->ClosedSubFlow());
		}
	}

	my $outgoSubFlowIds = $self->OutgoSubFlowIds() || [];
	foreach my $subFlowId (@$outgoSubFlowIds) { #(keys %{$SchedRt::classVars->{incomFlows}}) {
		my $subFlow = $SchedRt::classVars->{outgoFlows}{$subFlowId};
		if ($subFlow) {
			$self->LogSysTrace("Closing $subFlowId");
			$subFlow->CloseSubFlow();
#			$subFlow->IFinished();
			delete $SchedRt::classVars->{outgoFlows}{$subFlowId} if ($subFlow->ClosedSubFlow());
		}
	}
}

sub StartAllSubFlows {
	my $self = shift;
	my $objid = shift;

	my $objHier = $self->ObjectHierarchy();

	$self->ClearMessageCount();
	my $subFlowIds = $objHier->myincomflows($self->MyId);

	foreach my $subFlowId (@$subFlowIds) {
		my $subFlow = $SchedRt::classVars->{incomFlows}{$subFlowId};
		$self->LogSysTrace("Starting $subFlowId $subFlow");
		if ($subFlow) { $subFlow = $subFlow->StartSubFlow($subFlowId, "incom"); }
		else { $subFlow = SFlowRt->StartSubFlow($subFlowId, "incom"); }
		
		if ($subFlow) {
		$self->LogSysTrace("Started $subFlowId $subFlow");
			$SchedRt::classVars->{incomFlows}{$subFlowId} = $subFlow;
			$self->ReadVars($subFlowId);
			$subFlow->OpenExternalDb();
		}

#		unless ($subFlow) {
#			my $subFlow = SFlowRt->StartSubFlow($subFlowId, "incom");
#			if ($subFlow) {
#				$SchedRt::classVars->{incomFlows}{$subFlowId} = $subFlow;
#			}
#		}
	}

	my $subFlowIds = $objHier->myoutgoflows($self->MyId);

	foreach my $subFlowId (@$subFlowIds) {
		my $subFlow = $SchedRt::classVars->{outgoFlows}{$subFlowId};
		$self->LogSysTrace("Starting $subFlowId $subFlow");
		if ($subFlow) { $subFlow = $subFlow->StartSubFlow($subFlowId, "outgo"); }
		else { $subFlow = SFlowRt->StartSubFlow($subFlowId, "outgo"); }
		
		if ($subFlow) {
		$self->LogSysTrace("Started $subFlowId $subFlow");
			$SchedRt::classVars->{outgoFlows}{$subFlowId} = $subFlow;
			$subFlow->ClearMessageCount();
			$self->ReadVars($subFlowId);
			$subFlow->OpenExternalDb();
		}
		
#		unless ($subFlow) {
#			$subFlow = SFlowRt->StartSubFlow($subFlowId, "outgo");
#			if ($subFlow) {
#				$SchedRt::classVars->{outgoFlows}{$subFlowId} = $subFlow;
#			}
#		}
#		$subFlow->ClearMessageCount();
	}
}

sub OldestIncomMsgId {
	my $self = shift;

	my $outgoSubFlowIds = $self->OutgoSubFlowIds();

	my $oldestMsgId = -1;
	foreach my $subFlowId (@$outgoSubFlowIds) {
		my $currMsgId;
		unless ($currMsgId = $self->SpecialVar($subFlowId, "CurrIncomMsgId")) {
			$currMsgId = $self->SpecialVar($subFlowId, "CurrIncomMsgId", 0);
		}
		if ($oldestMsgId < 0) { $oldestMsgId = $currMsgId; }
		elsif ($currMsgId < $oldestMsgId) { $oldestMsgId = $currMsgId; }
	}

	return ($oldestMsgId < 0) ? 0 : $oldestMsgId;
}

sub MyCurrMsgId {
	my $self = shift;

	if (@_) { $self->GlobalVar("CurrMsgId", shift); }
	$self->GlobalVar("CurrMsgId");
}

sub MyCurrIncomMsgId {
	my $self = shift;

	if (@_) { $self->SpecialVar($self->MyId(), "CurrIncomMsgId", shift); }

	return $self->MyCurrMsgId($self->SpecialVar($self->MyId(), "CurrIncomMsgId"));
}

sub MyCurrIncomMsgDate {
	my $self = shift;

	if (@_) { $self->SpecialVar($self->MyId(), "CurrIncomMsgDate", shift); }

	return $self->SpecialVar($self->MyId(), "CurrIncomMsgDate");
}

sub MyCurrTransformedMsgId {
	my $self = shift;

	if (@_) { $self->SpecialVar($self->MyId(), "CurrTransformedMsgId", shift); }

	return $self->MyCurrMsgId($self->SpecialVar($self->MyId(), "CurrTransformedMsgId"));
}

sub MyCurrTransformedMsgDate {
	my $self = shift;

	if (@_) { $self->SpecialVar($self->MyId(), "CurrTransformedMsgDate", shift); }

	return $self->SpecialVar($self->MyId(), "CurrTransformedMsgDate");
}

sub MyCurrSentMsgId {
	my $self = shift;

	if (@_) { $self->SpecialVar($self->MyId(), "CurrSentMsgId", shift); }

	return $self->MyCurrMsgId($self->SpecialVar($self->MyId(), "CurrSentMsgId"));
}

sub OldestSentMsgId {
	my $self = shift;

	$self->MyCurrSentMsgId();
}

sub MyCurrSentMsgDate {
	my $self = shift;

	if (@_) { $self->SpecialVar($self->MyId(), "CurrSentMsgDate", shift); }

	return $self->SpecialVar($self->MyId(), "CurrSentMsgDate");
}

sub OurCurrIncomMsgId {
	my $self = shift;

	if (@_) { $self->SpecialVar($self->MyFlowId(), "CurrIncomMsgId", shift); }
	$self->SpecialVar($self->MyFlowId(), "CurrIncomMsgId");
}

sub OurCurrIncomMsgDate {
	my $self = shift;

	if (@_) { $self->SpecialVar($self->MyFlowId(), "CurrIncomMsgDate", shift); }
	$self->SpecialVar($self->MyFlowId(), "CurrIncomMsgDate");
}

sub ClearIncomFields {
	my $self = shift;

	$SchedRt::classVars->{incomFields} = {};
}

sub IncomFieldValue {
	my $self = shift;
	my $fieldId = shift;
	$fieldId = lc($fieldId);

	if (@_) { $SchedRt::classVars->{incomFields}{$fieldId} = shift; }
	$SchedRt::classVars->{incomFields}{$fieldId};
}

sub IncomFieldNames {
	my $self = shift;

	my $fNames = $SchedRt::classVars->{incomFields};
	if ($fNames and (ref($fNames) eq "HASH")) {
		my @fNames = keys %$fNames;
		return \@fNames;
	}
	undef;
}

sub CopyIncomFields {
	my $self = shift;

	my $fnames = $self->IncomFieldNames() || [];
	foreach my $fname (@$fnames) {
		$self->OutgoFieldValue($fname, $self->IncomFieldValue($fname));
	}
}

sub ClearOutgoFields {
	my $self = shift;

#	$self->LogSysTrace("ClearOutgoFields");
	$SchedRt::classVars->{outgoFields}{$self->MyId()} = {};
}

sub OutgoFieldValue {
	my $self = shift;
	my $fieldId = shift;
	$fieldId = lc($fieldId);

	#if ($self->MyId() == 71) { $self->LogSysTrace("$fieldId VALUE required"); }
	if (@_) { $SchedRt::classVars->{outgoFields}{$self->MyId()}{$fieldId} = shift; }
	$SchedRt::classVars->{outgoFields}{$self->MyId()}{$fieldId};
}

sub OutgoFieldNames {
	my $self = shift;

	my $hfNames = $SchedRt::classVars->{outgoFields}{$self->MyId()};
	if ($hfNames and (ref($hfNames) eq "HASH")) {
		my $objHier = $self->ObjectHierarchy();
		my @fNames = ();
		foreach my $fname (keys %$hfNames) {
			push @fNames, $fname; # if ($objHier->fieldbyname($self->MyId(), $fname))
		}
		return \@fNames;
	}
	undef;
}

sub ParseVarName {
	my $self = shift;
	my $varname = shift;

	$varname =~ s/^([cfitsgo])_//; # Column, Flow, Incomming, Outgoing, SubFlow, Temporary, Global, 
	my $type = $1;
	die "UNKOWN VAR TYPE $varname -$type-" unless ($type and ("cfiostg" =~ /$type/)); #cfistgok

	if ($type eq "c") {
		my $objHier = $self->ObjectHierarchy();
		my $dir = $objHier->flowdir($self->MyId());
		if ($dir eq "outgo") { $type = "o"; }
		else { $type = "i"; }
	}
	my %MapVarType = ( "g" => "GlobalVar", "f" => "FlowVar", "s" => "SubFlowVar", "t" => "TempVar",
			   "i" => "IncomFieldValue", "o" => "OutgoFieldValue");

	my $method = $MapVarType{$type};

	$self->$method($varname, @_);
}

sub InitProcessedRows {
	my $self = shift;

	$self->TempVar("##RowsCount##", 0);
}

sub CommitIfNeeded {
	my $self = shift;

	my $processedRows = $self->TempVar("##RowsCount##", $self->TempVar("##RowsCount##") + 1);
	my $commitInterval = $self->CommitInterval();
#	print "CommitIfNeeded = $commitInterval\n";
	if (($commitInterval > -1) and ($commitInterval <= $processedRows)) {
		$self->CommitAll("PartialCommit");
	}
}

sub RollbackAll {
	my $self = shift;

	my $incomFlows = $self->IncomSubFlows() || [];
	my $outgoFlows = $self->OutgoSubFlows() || [];
	foreach my $subFlow (@$incomFlows) {
		$subFlow->FinalRollback();
	}
	foreach my $subFlow (@$outgoFlows) {
		$subFlow->FinalRollback();
	}

	$self->QueueDbh()->finalrollback();
	$self->InitProcessedRows();
}

sub CommitAll {
	my $self = shift;
	my $commitmeth = shift;

#	COMMITER LES DIFFERENTES BASES DE DONNEES
#
#	print "ScriptCallBack called\n";
#	cafDbg->pushstackdump(3);
#	cafDbg->pushstackdump(2);
#	cafDbg->pushstackdump(1);
#	print "CommitAll\n";
	my $incomFlows = $self->IncomSubFlows() || [];
	my $outgoFlows = $self->OutgoSubFlows() || [];
	foreach my $subFlow (@$incomFlows) {
		$subFlow->$commitmeth();
	}
	foreach my $subFlow (@$outgoFlows) {
		$subFlow->$commitmeth();
	}

	$commitmeth = lc ($commitmeth);
	$self->QueueDbh()->$commitmeth();
	$self->InitProcessedRows();
}

sub FinalCommit {
	shift->CommitAll("FinalCommit");
}

sub ScriptCallBack {
	# $self is not allowed;
	my $selfId = shift;

	my $self;
	if ($SchedRt::classVars->MyFlowId() == $selfId) { $self =  $SchedRt::classVars; }
	elsif ($SchedRt::classVars->{outgoFlows}{$selfId}) { $self =  $SchedRt::classVars->{outgoFlows}{$selfId}; }
	elsif ($SchedRt::classVars->{incomFlows}{$selfId}) { $self =  $SchedRt::classVars->{incomFlows}{$selfId}; }
#	else { return undef; }
#	print STDERR "ScriptCallBack called with $selfId => $self ";
	return $self;
}

sub ConnectorCallBack {
	# $self is not allowed;
	my $selfId = shift;
	my $connectorId = shift;
	my $method = shift;

	my $self;

#	cafDbg->pushstackdump(1);
	if ($SchedRt::classVars->MyFlowId() == $selfId) { $self = $SchedRt::classVars; }
	elsif ($SchedRt::classVars->{outgoFlows}{$selfId}) { $self = $SchedRt::classVars->{outgoFlows}{$selfId}; }
	elsif ($SchedRt::classVars->{incomFlows}{$selfId}) { $self = $SchedRt::classVars->{outgoFlows}{$selfId}; }

	$self->$method($connectorId, @_);
}

sub MyMappingList {
	my $self = shift;

	my $mappingList;
	unless ($mappingList = $SchedRt::classVars->{mappingList}{$self->MyId()}) {
		my $objHier = $self->ObjectHierarchy();
		my @mappingList = $objHier->mappfieldlist($self->MyId());
		#print "MyMappingList = ", $self->MyId(), " = ", join (" - ", @mappingList), "\n";
		my %hMapps;
		my @aMap;
		foreach my $map (@mappingList) {
			push @aMap, $map->{outgofield_id};
			my %hMap;
			#print "MyMappingList = $map->{outgofield_id} = $map->{incomfield_id} ==>", join(" - ", %$map), "\n";
			$hMap{outgofield_id} = $map->{outgofield_id};
			if ($map->{incomfield_id}) { $hMap{incomfield_id} = $map->{incomfield_id}; }
			if ($map->{script_id}) { $hMap{script_id} = $map->{script_id}; }
			if ($map->{pformula}) {
				$hMap{pformula} = $map->{pformula};
				$self->FormulaClosure($map->{outgofield_id}, $map->{pformula});
			}
			$hMapps{$map->{outgofield_id}} = \%hMap;
		}
		$hMapps{__MAPPEDFIELDS__} = \@aMap;
		$mappingList = $SchedRt::classVars->{mappingList}{$self->MyId()} = \%hMapps;
	}
	$mappingList;
}

sub PushContext {
	my $self = shift;
	my $ctxt = shift;

	$SchedRt::classVars->{executionContext} = [] unless ($SchedRt::classVars->{executionContext});
	push @{$SchedRt::classVars->{executionContext}}, { execCtxt => $ctxt };
	$SchedRt::classVars->{iExecutionContext} = $#{$SchedRt::classVars->{executionContext}};
	cafDbg->pushstackdumps(3);
}

sub PopContext {
	my $self = shift;
	my $ctxt = shift;

	$SchedRt::classVars->{executionContext} = [] unless ($SchedRt::classVars->{executionContext});
	if ($SchedRt::classVars->{iExecutionContext} >= 0) {
		pop @{$SchedRt::classVars->{executionContext}};
		$SchedRt::classVars->{iExecutionContext} = $#{$SchedRt::classVars->{executionContext}};
		cafDbg->popstackdumps(3);
	}
}

sub SetContextScript {
	my $self = shift;
	my $type = shift;
	my $step = shift;
	my $id   = shift;

	my $iCtxt;
	my $execCtxt;
	if ($iCtxt = $SchedRt::classVars->{iExecutionContext} >= 0) {
		$execCtxt = $SchedRt::classVars->{executionContext}[$iCtxt];
		$execCtxt->{ execType} = $type;
		$execCtxt->{ execStep} = $step if ($step);
		$execCtxt->{ execId} = $id if ($id);
	}
}

sub MailOnError {
	my $self = shift;

	return @_ ? $self->{mailOnError} = shift : $self->{mailOnError}

#	if (@_) {
#		$self->{mailOnError} = shift;
#	}
#	my $context = $self->MyContext();
#	return ($self->{mailOnError} ? $context->{adminmail} : undef);
}

sub MailOnSucess {
	my $self = shift;

	return @_ ? $self->{mailOnSuccess} = shift : $self->{mailOnSuccess}

#	if (@_) {
#		$self->{mailOnSucess} = shift;
#	}
#	my $context = $self->MyContext();
#	return ($self->{mailOnSucess} ? $context->{adminmail} : undef);
}

sub HalteOnError {
	my $self = shift;
	eval {
		$SchedRt::classVars->RollbackAll();
	};
	$SchedRt::classVars->Halted(1);
}

sub StopOnError {
	my $self = shift;
	eval {
		if ($self->MyId() != $self->MyFlowId()) { $self->FinalRollback(); }
	};
	$self->StoppedFlow(1);
}

sub SkipRowOnError {
	my $self = shift;

	$self->SkipMessage(1);
}

sub RetryLaterOnError {
	my $self = shift;

	$self->RetryLater(1);
}

sub RegisterError {
	my $self = shift;
	my $errtext = shift;

	my $execCtxt;
	if (my $iCtxt = $SchedRt::classVars->{iExecutionContext} >= 0) {
		$execCtxt = $SchedRt::classVars->{executionContext}[$iCtxt];
	}
	my $error_context = $execCtxt->{execCtxt} . " - " . $execCtxt->{execType} . " - " . $execCtxt->{execStep} . " - " . $execCtxt->{execId};

	my $lastQuery;
	if (my $query = refDBI->lastquery()) {
		my $lastdatabase = refDBI->lastdatabase();
		$lastQuery = "DATABASE : " . $lastdatabase . "<BR>\nQUERY = " . $query->query() . "<BR>\n";
		my $bv = $query->bindvars();
		my $bvl = $query->bindvarlabels() || [];

		foreach (my $i = 0; $i <= $#$bv; $i++) {
			my $v = $bv->[$i] || "(NULL)";
			my $vl = $bvl->[$i] || "p$i";
			$lastQuery .= "bind var $i - :$vl - $v<BR>\n";
		}
	}

	cafDbg->pusherror("999999;$errtext");

	my ($errorText, $stackDump) = cafDbg->errortostring();
	cafDbg->clear();

	eval {
		my $qDbh = $self->QueueDbhAutocommit();

		my $errorId = $qDbh->nextseq("wrunerrors");
		my $qAttrs = {
			error_id => $errorId,
			object_id => $self->MyId(),
			run_id    => $self->NextExecutionSeq(),
			msg_id    => $self->MyCurrMsgId() || -1,
			error_context => $error_context,
			error_code    => "9999999",
			driver_error  => "UNKOWN",
			error_text    => $errorText,
			last_query    => $lastQuery,
			stack_dump    => $stackDump,
		};

		my $query = $qDbh->newquery($qAttrs);
		$query->iwrunerrors();
		eval { $qDbh->executefinish($query); };
		if ($@) { $self->LogSysTrace("	RegisterError ($@) : " . $query->query() . " : " . $qDbh->errstr()); }
	};

	my $context = $self->GetContext();
	my $sendMessage;
	my $from;
	if ($self->MyId() == $self->MyFlowId()) { $sendMessage = 1; $from = "cafeterra.Flow." . $self->MyFlowId(); }
	elsif ($sendMessage = $self->MailOnError()) { $from = "cafeterra.SubFlow." . $self->MyFlowId() . "." . $self->MyId(); }

	if ($sendMessage and $context->{adminmail}) {
		my $hostname;
		eval { require Sys::Hostname; $hostname = Sys::Hostname::hostname(); };
		$hostname ||= "cafeterra.localhost";
		eval {
			require Mail::Sender;
			my $sender = Mail::Sender->new ({smtp => 'localhost', from => $from . '@' . $hostname});
			#$sender->Open();
			if ($!) { die " (" . ($! + 0) . ") $!"; }
			$sender->MailMsg({to => $context->{adminmail}, subject => $error_context, msg => "$errorText<BR>\n$lastQuery<BR>\n$stackDump"});
			if ($!) { die " (" . ($! + 0) . ") $!"; }
			$sender->Close(1);
			if ($!) { die " (" . ($! + 0) . ") $!"; }
			
		};
		if ($@) {
			$self->LogSysTrace("MAIL ERROR FOR THE NEXT MESSAGE : $@\n");
		}
	}

	$self->LogSysTrace($errorText);
	$self->LogSysTrace($lastQuery);
	$self->LogSysTrace($stackDump);
}

sub OnErrorAction {
	my $self = shift;

	return @_ ? $self->{onErrorAction} = shift : $self->{onErrorAction}
}

sub OnError {
	my $self = shift;
	my $err = shift;

#	$self->LogSysTrace("OnError Called");
	my $action = uc($self->OnErrorAction());
	if ($action eq "SCRIPT") {
		my $objHier = $self->ObjectHierarchy();

		my $scrid = $objHier->scriptbystep($self->MyId(), "onerror");
		$scrid = $objHier->scriptbystep($self->MyFlowId(), "onerror") unless ($scrid);
		if ($scrid) {
			my $iCtxt;
			my $execCtxt = "";
			if ($iCtxt = $SchedRt::classVars->{iExecutionContext} >= 0) {
				$execCtxt = $SchedRt::classVars->{executionContext}[$iCtxt];
			}

			my $scriptRt = $self->MyClosure ($scrid);
			$action = $scriptRt->RunScript($execCtxt, $err);

#			if ($ret eq "HALTE") { $self->HalteOnError($err); }
#			elsif ($ret eq "SKIP") { $self->SkipRowOnError($err); }
#			elsif ($ret eq "RETRYLATER") { $self->RetryLaterOnError($err); }
#			elsif ($ret eq "STOP") { $self->StopOnError($err); }
#			else { $self->HalteOnError($err); }
		}
	}
	if ($action eq "HALTE") { $self->HalteOnError($err); }
	elsif ($action eq "SKIP") { $self->SkipRowOnError($err); }
	elsif ($action eq "RETRYLATER") { $self->RetryLaterOnError($err); }
	elsif ($action eq "STOP") { $self->StopOnError($err); }
	else { $self->HalteOnError(); }

	$self->RegisterError($err);
}

sub FormulaClosure {
	my $self = shift;
	my $fieldId = shift;

	my $subFlowId = $self->MyId();
	my $closure;
	my $scriptRt;
	if (@_) {
		my $pFormula = shift;
		my $objHier = $self->ObjectHierarchy();
		my $subtext = 'sub { my $self = shift; ' . $pFormula . '}';

		$closure = $SchedRt::classVars->{formulaClosures}{$subFlowId}{$fieldId} = eval $subtext;
		$scriptRt = ScriptRt->new(\&ScriptCallBack, $self->MyId(), $closure, "Formula $fieldId");
		$SchedRt::classVars->{formulaScriptRt}{$subFlowId}{$fieldId} = $scriptRt;
	}
	$SchedRt::classVars->{formulaScriptRt}{$subFlowId}{$fieldId};
}

sub RunFormula {
	my $self = shift;
	my $fieldId = shift;

	my $ret;

	if ($@) { $self->OnError($@); }
	$self->SetContextScript("formula", undef, $fieldId);
	eval {
		my $scriptRt = $self->FormulaClosure ($fieldId);

		$ret = $scriptRt->RunScript(@_);
	};
	if ($@) { $self->OnError($@); }
	$ret;
}

sub MyClosure {
	my $self = shift;
	my $scrid = shift;

	my $closure;
	my $scriptRt;
	unless ($closure = $SchedRt::classVars->{scriptClosures}{$scrid}) {
		my $objHier = $self->ObjectHierarchy();
		my $scriptObject = $objHier->getdata($scrid);
		my $subtext = 'sub { ' . $scriptObject->{scripttext} . '}';
		$subtext =~ s/\r/\n/g;
#		$self->LogSysTrace("Closure Created For $subtext");
		$closure = $SchedRt::classVars->{scriptClosures}{$scrid} = eval $subtext;
		die " $subtext $@" if ($@);
	}
	$closure = $SchedRt::classVars->{scriptClosures}{$scrid};
	unless ($scriptRt = $SchedRt::classVars->{scriptRt}{$self->MyId()}{$scrid}) {
		$scriptRt = ScriptRt->new(\&ScriptCallBack, $self->MyId(), $closure, "for scriptid $scrid");
		$SchedRt::classVars->{scriptRt}{$self->MyId()}{$scrid} = $scriptRt;
	}
	$scriptRt;
}

sub RunScriptById {
	my $self = shift;
	my $scrid = shift;

	my $ret;

	my $scriptRt = $self->MyClosure ($scrid);
	$self->SetContextScript("script", undef, $scrid);
	eval {
		$ret = $scriptRt->RunScript(@_);
	};
	if ($@) { $self->OnError($@); }
	return $ret;
	
}

sub RunScriptByStep {
	my $self = shift;
	my $step = shift;

	my $objHier = $self->ObjectHierarchy();
	my $scrid;

	if ($scrid = $objHier->scriptbystep($self->MyId(), $step)) {
		$self->SetContextScript("script", $step, $scrid);
		$self->RunScriptById($scrid, @_);
	}
	return '0E0';
}

sub GetQueryById {
	my $self = shift;
	my $qryId = shift;

	my $objHier  = $self->ObjectHierarchy();
	my $scriptObject = $objHier->getdata($qryId);
	my $qtext;
	my $parsed = $scriptObject->{parsedtext};
	foreach my $chunk (@{$parsed->{text}}) {
		if ($chunk->{type} eq 'NC') { $qtext .= $chunk->{content}; }
		elsif ($chunk->{type} eq 'IV') { $qtext .= $self->ParseVarName($chunk->{content}); }
		elsif ($chunk->{type} eq 'BV') { $qtext .= "?"; }
	}
	my @bindvars = @{$parsed->{bindvars}};
	my @columns  = @{$parsed->{aliases}};

	$qtext =~ s/\r//g;
	my $query = { mylabel => "q$qryId", query => $qtext, bindvarlabels => \@bindvars, columns => \@columns };
	$query;
}
			
sub GetQueryByName {
	my $self = shift;
	my $name = shift;

	my $objHier = $self->ObjectHierarchy();
	my $qryId;
	if ($qryId = $objHier->scriptbyname($self->MyId(), $name)) {
		my $query = $self->GetQueryById($qryId);
		return $query;
	}
	undef;
}

sub GetQueryByStep {
	my $self = shift;
	my $step = shift;

	my $objHier = $self->ObjectHierarchy();
	my $qryId;
#	print STDERR "GetQueryByStep $step\n";
	if ($qryId = $objHier->scriptbystep($self->MyId(), $step)) {
		my $query = $self->GetQueryById($qryId);
#	print STDERR "GetQueryByStep $step $qryId\n";
		return $query;
	}
	undef;
}

sub GetQueryByUsedFor {
	my $self = shift;
	my $usedfor = shift;

	my $objHier = $self->ObjectHierarchy();
#	print  $objHier->dumpall(), "\n";
	my $qryId;
#	print " QUERY STEP = $usedfor \n";
	if ($qryId = $objHier->scriptbyusedfor($self->MyId(), $usedfor)) {
		my $query = $self->GetQueryById($qryId);
#		print " STEP = $usedfor : QUERY = $query->{query}\n";
		return $query;
	}
	undef;
}

sub LoadObject {
	my $self = shift;
	my $objType = shift;
	my $idOrName = shift;

	my $objHier = $self->ObjectHierarchy();
	my $objectId;
	return ($objHier->loadobjecthierarchy($objType, $idOrName));
}

sub LoadScript {
	my $self = shift;
	my $idOrName = shift;

	my $objId = $self->LoadObject('perl', $idOrName);
	return $self->MyClosure($objId);

}

sub LoadQuery {
	my $self = shift;
	my $idOrName = shift;

	my $objId = $self->LoadObject('sql', $idOrName);
	return $self->GetQueryById($objId);

}

sub LoadConnector {
	my $self = shift;
	my $idOrName = shift;

	$self->LoadObject('connector', $idOrName);

}

sub LoadContainer {
	my $self = shift;
	my $idOrName = shift;

	return $self->LoadObject('container', $idOrName);
}

sub LoadUser {
	my $self = shift;
	my $idOrName = shift;

	return $self->LoadObject('user', $idOrName);
}

sub LoadSever {
	my $self = shift;
	my $idOrName = shift;

	return $self->LoadObject('sever', $idOrName);
}

sub LoadService {
	my $self = shift;
	my $service = shift;

	my $scriptId = $self->LoadObject ('perl', $service) || return undef;

	my $scriptRt = $self->MyClosure($scriptId);

	return $scriptRt;
}


sub GetMyContainerDef {
	my $self = shift;

	my $objHier = $self->ObjectHierarchy();
	my $containerId;
	if (@_) { $containerId = shift; }
	else {
		my $subflow = $objHier->getobject($self->MyId());
		die "GetMyContainerDef Invalid subflow id" unless ($subflow->{type} eq "subflow");
		$containerId = $subflow->{container_id};
	}

	my $container = $objHier->getobject($containerId);
	my %container = map { $_ => $container->{$_} } keys %$container;
	my $attrlist = $objHier->attributelist($containerId);

	my %attrs;
	foreach my $attr (@$attrlist) {
		$attrs{$attr->{attrdefid}} = $attr->{attrvalue} if ($attr->{attrdefid});
		# print "  ATTRS => , $attr->{attrdefid} => $attr->{attrvalue}\n";
	#if ($attrlist and ref($attrlist)) {
	#	%attrs = map { $_->{attrdefid} => $_->{attrvalue} } keys %$attrlist;
	}
	use Data::Dumper; 

	$container{_ATTRS}  = \%attrs;
	$container{_FIELDS} = $objHier->myfields($containerId);
	return \%container;
}

sub GetExternalDbHash {
	my $self = shift;
	my $connector_id = shift;
	my $container_id;
	my $container;

#	cafDbg->pushstackdump(1);
	my $objHier = $self->ObjectHierarchy();

	my $connector = $objHier->getobject($connector_id);

	if (@_) {
		$container_id = shift;
		if($container_id && ($container_id > 0)) { $container = $objHier->getobject($connector_id); }
		# die "Container $container_id not found" unless ($container and ($container->{type} eq 'container'));
	}
	else {
		$container = $self->GetMyContainerDef();
	}

	my %connector = $connector ? %$connector : undef;

	my $user = $objHier->getdata($connector{user_id});
	$user = $objHier->getdata($connector{userid}) unless ($user);
	my %user = ();
	if ($user) { foreach my $k (keys %$user) { $user{$k} = $user->{$k}; } }
#	my %user = $user ? %$user : undef;

	my %server = ();
	my $server = $objHier->getdata($connector{parent_id});
	if ($server) { foreach my $k (keys %$server) { $server{$k} = $server->{$k}; } }
#	my %server = $server ? %$server : undef;

	my (%proxy, %proxy_user, %proxy_server);
	if ($connector{prox_id}) {
		my $proxy = $objHier->getdata($connector{proxy_id});
		%proxy = ();
		if ($proxy) { foreach my $k (keys %$proxy) { $proxy{$k} = $proxy->{$k}; } }
#		%proxy = $proxy ? %$proxy : undef;

		my $proxy_user = $objHier->getdata($proxy{user_id});
		%proxy_user = ();
		if ($proxy_user) { foreach my $k (keys %$proxy_user) { $proxy_user{$k} = $proxy_user->{$k}; } }
#		%proxy_user = $proxy_user ? %$proxy_user : undef;

		my $proxy_server = $objHier->getdata($proxy{server_id});
		%proxy_server = ();
		if ($proxy_server) { foreach my $k (keys %$proxy_server) { $proxy_server{$k} = $proxy_server->{$k}; } }
#		%proxy_server = $proxy_server ? %$proxy_server : undef;
	}

	my $attrlist = $objHier->attributelist($connector_id);
	my %attrs;

	# print " GOING TOI GET ATTR FOR $connector_id $#$attrlist\n";
	foreach my $attr (@$attrlist) {
		$attrs{$attr->{attrdefid}} = $attr->{attrvalue} if ($attr->{attrdefid});
		# print "  ATTRS => , $attr->{attrdefid} => $attr->{attrvalue}\n";
	}

	my $flowDir = $self->MyFlowDir();
	return {
		connector     => \%connector,
		user          => \%user,
		server        => \%server,
		proxy         => \%proxy,
		proxy_server  => \%proxy_server,
		proxy_user    => \%proxy_user,
		object_id     => $self->MyId(),
		connector_id  => $connector->{id},
		callback      => \&ConnectorCallBack,
		_ATTRS        => \%attrs,
		_FLOWDIR      => $flowDir,
		container     => $container,
	};

}

sub GetExternalDbh {
	my $self = shift;

	if (@_) { $SchedRt::classVars->{externalDbh}{$self->MyId()} = shift; }
	$SchedRt::classVars->{externalDbh}{$self->MyId()};
}

#sub SubFlowExternalDb {
#	my $self = shift;
#
#	my $objHier = $self->ObjectHierarchy();
#	my $object = $objHier->getdata($self->MyId());
#	my $db = $self->GetExternalDbHash ($object->{connector_id});
#	$self->ExternalDbh(refDBI->Connect($db));
#}

sub GenIncomTableName {
	my $self = shift;

	sprintf("z%s_%08.8d", substr($self->MyContextId(),0,4), $self->MyFlowId());
}

sub GenOutgoTableName {
	my $self = shift;

	sprintf("z%s_%08.8d", substr($self->MyContextId(),0,4), $self->MyId());
}

sub ExternalConnector {
	my $self = shift;
	my $connectorId = shift;
	if (@_) { $SchedRt::classVars->{externalDbh}{$connectorId} = shift; }
	$SchedRt::classVars->{externalDbh}{$connectorId};
}

sub OpenExternalConnector {
	my $self = shift;
	my $connectorId = shift;
	my $containerId = shift;

	$self->PushContext("OpenExternalConnector");

	my $db = $self->GetExternalDbHash ($connectorId, $containerId);
	my $dbh = refDBI->ExtConnect($db);

	$self->PopContext("OpenExternalConnector");

	return $dbh;
}

sub CloseExternalConnector {
	my $self = shift;

	my $dbh = shift;
	return 1 unless ($dbh);

	$self->PushContext("CloseExternalConnector");

	$dbh->Disconnect();

	$self->PopContext("CloseExternalConnector");

	return 1;
}

sub PrepareQuery {
	my $self = shift;
	my $params = shift;

	my $query;
	my $dbh;

	if ($params->{query_id}) {
		$query = $self->LoadQuery($params->{query_id});
	}
	else { $query = $params->{query}; }

	return (undef, undef) unless ($query and ref($query));

	unless ($dbh) {
		$dbh = $self->GetExternalDbh();
	}

	return (undef, undef) unless ($dbh);

	my $qh = $dbh->newqueryfromhash($query);

	unless (defined($params->{bindvars})) {
		my $bvls = $qh->bindvarlabels();
		my @bv;
		foreach my $bvl (@$bvls) { push @bv, $self->ParseVarName($bvl); }
		$params->{bindvars} = \@bv;
	}
	$qh->bindvars($params->{bindvars});

	return ( $qh, $dbh );
}

sub PrepareQueryText {
	my $self = shift;
	my $params = shift;

	my $query = $params->{query_text};
	my $dbh;

	return (undef, undef) unless ($dbh);

	unless ($dbh) {
		$dbh = $self->GetExternalDbh();
	}

	return (undef, undef) unless ($dbh);

	my $qh = $dbh->newquery();
	$qh->query($query);

	if (defined($params->{bindvars})) { $qh->bindvars($params->{bindvars}); }
	return ( $qh, $dbh );
}

sub ExecuteQuery {
	my $self = shift;
	my $params = shift;

	return undef unless (ref($params));

	my ($qh, $dbh) = $params->{query_text} ? $self->PrepareQueryText ($params) : $self->PrepareQuery ($params);
	return undef unless ($qh and $dbh);
	return $dbh->executefinish($qh);
}

sub ExecuteFetchQuery {
	my $self = shift;
	my $params = shift;
	my $format = $params->{format};
	my $first = $params->{firstonly};

	my ($qh, $dbh) = $params->{query_text} ? $self->PrepareQueryText ($params) : $self->PrepareQuery ($params);
	return undef unless ($qh and $dbh);

	if ($format =~ /array/i) { 
		return $dbh->execfetchrownop($qh, 1) if ($first);
		return $dbh->execfetchall($qh);
	}
	elsif ($format =~ /hash/i) {
		return $dbh->hexecfetchrownop($qh, 1) if ($first);
		return $dbh->hexecfetchall($qh);
	}

	else { return undef; }
}

# DBH INTERFACE FOR SCRIPT #

sub SetExternalName {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->setexternalname(@_);
}

sub GetExternalName {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->getexternalname(@_);
}

sub MoveExternaleFile {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->moveexternalfile(@_);
}

sub DeleteExternaleFile {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->deleteexternalfile(@_);
}

sub RenameExternaleFile {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->renameexternalfile(@_);
}

sub RenameExternalTable {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->renameexternalfile(@_);
}

sub CopyExternaleFile {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->copyexternalfile(@_);
}

sub CreateExternaleDir {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->createexternaldir(@_);
}

sub RemoveExternaleDir {
	my $self = shift;

	my $dbh = $self->GetExternalDbh();
	$dbh->removeexternaldir(@_);
}

# SCHEDULER INTERFACE FOR SCRIPT #
sub ExecuteFlow {
	my $self = shift;
	my $flowId = shift;
	my $context = shift || $self->MyConext();
	my $basedir = shift || $self->BaseDir();
	my $detach = shift || 0;
	my $mode = shift || "once";
	my $tracefile = shift || "/dev/null";
	my $errfile = shift || "/dev/null";


	my $dbh = $self->QueueDbhAutocommit();
	my $query = $dbh->newquery({ object_id => $flowId, type => "flow", });
	$query->sobjectlist();
	my $row = $dbh->hexecfetchrownop($query, 1);
	die "Schedule job $flowId Invalid Flow Id" unless ($row->{object_id} == $flowId);

#	perl launch.pl --context=contextid --basedir=/path/to/base/dir --mode=daemon|once [--detach=1|0] [--flow=flowid]
	my $context = 
	my $cmd = "/usr/local/bin/perl $basedir/mains/launch.pl ";
	$cmd .= "--context=$context --basedir=$basedir --mode=$mode --detach=$detach --flow=$flowId";
	$cmd .= " >> $tracefile 2>> $errfile";
	system($cmd);


	my $exit_value  = $? >> 8;
	my $signal_num  = $? & 127;
	my $dumped_core = $? & 128;

	return wantarray ? ($exit_value, $signal_num, $dumped_core) : $exit_value;
}

sub ScheduleJob {
	my $self   = shift;
	my $flowId = shift;
	my $tracefile = shift;
	my $errfile = shift;

	my $dbh = $self->QueueDbhAutocommit();
	my $query = $dbh->newquery({ object_id => $flowId, type => "flow", });
	$query->sobjectlist();
	my $row = $dbh->hexecfetchrownop($query, 1);
	die "Schedule job $flowId Invalid Flow Id" unless ($row->{object_id} == $flowId);
	my $schedId = sprintf("S%X%X", time(), $self->MyId());
	$query->clear({ object_id => $flowId, sched_id => $schedId, sched_min => 0, sched_sec => 0,
			sched_hour => 0, sched_mday => 0, sched_month => 0, sched_wday => 0, sched_mode => "asap",
			sched_label => "Temporary Schedule", tracefile => $tracefile, errfile => $errfile});
	$dbh->executefinish($query);
}

sub SendMailMessage {
	my $self = shift;

	my $server = shift;
	my $from = shift;
	my $to = shift;
	my $cc = shift;
	my $bcc = shift;
	my $subject = shift;
	my $text = shift;

	my $hostname;

	my $context = $self->GetContext();
	my $objHier = $self->ObjectHierarchy();
	if (! $from) { $from = $context->{adminmail}; }
	if (! $server) { $server = $ENV{SMTPSERVER}; }
	eval { require Sys::Hostname; $hostname = Sys::Hostname::hostname(); };
	$hostname ||= "localhost";
	if (! $server) { $server = $hostname; }
	if (! $from) { $from = "administrator\@$hostname"; }

	{
		local $! = undef;
		require Mail::Sender;
		my $sender = Mail::Sender->new ({smtp => $server, from => $from });
		$sender->MailMsg({ to => $to, subject => $subject, msg => $text }) unless ($Mail::Sender::Error);

		$Mail::Sender::Error ? $sender->Cancel : $sender->Close;

		die  "SendMailMessage $Mail::Sender::Error for $text" if ($Mail::Sender::Error);
	
	}
}

# SCRIPT MODULE #
package ScriptRt;


sub AUTOLOAD {
	my $self = $_[0];
	#DBG# $self->dbg(@_) if ($self);
	#no strict;
	return (undef) if $ScriptRt::AUTOLOAD =~ /::DESTROY$/;
	my $varname = lc $ScriptRt::AUTOLOAD;
	$varname =~ s/.*:://;
	#require strict;

	my $flowCallBack = $self->{callBack};
	my $flow = &$flowCallBack($self->{objectId});
	shift;
	$flow->ParseVarName($varname, @_);
}

sub new {
	my $class = shift;
	my $callback = shift;
	my $objectId = shift;
	my $closure = shift;
	my $misc = shift;

	my $self = { callBack => $callback, objectId => $objectId, closure => $closure, misc => $misc };
	bless $self, $class;
}

sub CallBackObject {
	my $self = shift;
	my $callBack = $self->{callBack};
	&$callBack($self->{objectId});
}

sub RunScript {
	my $self = shift;

	my @params;
	if (ref($_[0]) eq "ARRAY") { @params = @{$_[0]}; }
	else { @params = @_; }

	my $flowCallBack = $self->CallBackObject();
	my $closure = $self->{closure};
#	$flowCallBack->LogSysTrace("RunScript Called");
	my $ret = &$closure($self, @params);
#	$flowCallBack->LogSysTrace("Closure Ret is $ret");
	return $ret;
}

sub DestroyScript {
	my $self = shift;

	$self->{callBack} = undef;
	$self->{closure} = undef;
}

sub skip {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();
	$flowCallBack->SkipMessage(@_);
}

sub min {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_min(@_);
}

sub maj {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_maj(@_);
}

sub lpad {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_lpad(@_);
}

sub rpad {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_rpad(@_);
}

sub ltrim {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_ltrim(@_);
}

sub rtrim {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_rtrim(@_);
}

sub trim {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_trim(@_);
}

sub tonumber {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_tonumber(@_);
}

sub todate {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->Format_todate(@_);
}

sub movefile {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	die "movefile invalid parameters number" unless ($#_ >= 1);
	$flowCallBack->MoveExternaleFile(@_);
}

sub deletefile {
	my $self = shift;

	die "deletefile invalid parameters number" unless ($#_ >= 0);
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->DeleteExternaleFile(@_);
}

sub renamefile {
	my $self = shift;

	die "renamefile invalid parameters number" unless ($#_ >= 1);
	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->RenameExternaleFile(@_);
}

sub putfile {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	die "putfile invalid parameters number" unless ($#_ >= 1);
	$flowCallBack->CopyExternaleFile("put", @_);
}

sub getfile {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	die "getfile invalid parameters number" unless ($#_ >= 1);
	$flowCallBack->CopyExternaleFile("get", @_);
}

sub copyfile {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	die "getfile invalid parameters number" unless ($#_ >= 1);
	$flowCallBack->CopyExternaleFile("copy", @_);
}

sub rmdir {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	die "rmdir invalid parameters number" unless ($#_ >= 0);
	$flowCallBack->CreateExternaleDir(@_);
}

sub mkdir {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();

	die "mkdir invalid parameters number" unless ($#_ >= 0);
	$flowCallBack->RemoveExternaleDir(@_);
}

sub renametable {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->RenameExternalTable(@_);
}

sub settablename {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->SetExternalName(@_);
}

sub gettablename {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->GetExternalName(@_);
}

sub useractionbystep {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->UserDefinedAction("step", @_);
}

sub useractionbyname {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->UserDefinedAction("name", @_);
}

sub useractionbyid {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->UserDefinedAction("id", @_);
}


sub useralternateactionnbystep {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->UserAlternateAction("step", @_);
}

sub useralternateactionnbyname {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->UserAlternateAction("name", @_);
}

sub useralternateactionnbyid {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->UserAlternateAction("id", @_);
}

sub logsystrace {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->LogSysTrace(@_);
}

sub loadscript {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();
	$flowCallBack->LoadScript(@_);
}

sub loadquery {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();
	$flowCallBack->LoadQuery(@_);
}

sub loadconnector {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();
	$flowCallBack->LoadConnector(@_);
}

sub loadcontainer {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();
	$flowCallBack->LoadContainer(@_);
}

sub loaduser {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();
	$flowCallBack->LoadUser(@_);
}

sub loadsever {
	my $self = shift;
	my $flowCallBack = $self->CallBackObject();
	$flowCallBack->LoadSever(@_);
}

sub runscript {
	shift->RunScript(@_);
}

sub openconnector {
	my $self = shift;
	my $connectorId = shift;
	my $containerId = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->OpenExternalConnector($connectorId, $containerId);
}

sub closeconnector {
	my $self = shift;
	my $dbh = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->CloseExternalConnector($dbh);
}

sub schedulejob {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->ScheduleJob(@_);
}

sub executeflow {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->ExecuteFlow(@_);
}

sub lastrow {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->LastRow(@_);
}

sub processpostlastrow {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->ProcessPostLastRow(@_);
}

sub ackmessageok {

	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->AknowledgeMessageOk(@_);
}

#Aziz 31/07/2003 Added those function from V1 userinsert, userupdate, userdelete
#                to allow more flexibility for aknowledgement
sub userinsert {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->AknowledgeMessageOk("insert");
}

sub userdelete {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->AknowledgeMessageOk("delete");
}

sub userupdate {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->AknowledgeMessageOk("update");
}

sub executequery {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->ExecuteQuery(@_);
}

sub executefetchquery {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->ExecuteFetchQuery(@_);
}

sub commit {
	my $self = shift;
	my $dbh = shift;

	$dbh->commit();
}

sub rollback {
	my $self = shift;
	my $dbh = shift;

	$dbh->commit();
}

sub sendmail {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->SendMailMessage(@_);
	
}

sub setevent {
	my $self = shift;

	my $flowCallBack = $self->CallBackObject();

	$flowCallBack->SetEvent(@_);
	
}

1;
