#!/usr/local/bin/perl
#
# launch.pl 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

#Main program

use Schedule::Cron;
use Getopt::Long;
use Time::ParseDate;
use Cwd;
use File::Spec;

use strict;

package launcher;

sub CronDispatcher {
	my $self = shift;

	return;

}

sub _PrintUsage {
	my $errMsg = shift;

	$errMsg .= "\nUsage : perl launch.pl --context=contextid --basedir=/path/to/base/dir --mode=daemon|once [--detach=1|0] [--flow=flowid]\n";

	$errMsg .="Example time perl launch.pl  --context=default --basedir=/home/app/cafeterra/ --mode=once --detach=0 --flow=410\n";
	die $errMsg;
}

sub _ProcessOptions {
	my %config;

	Getopt::Long::GetOptions(\%config, "context=s", "basedir=s", "mode=s", "flow=s", "detach=s");

	_PrintUsage ("") unless ($config{context} and $config{basedir} and $config{mode});

	$config{contextId} = $config{context};

	_PrintUsage("Can't change to basedir $config{basedir}\n") unless ($config{basedir} and (chdir $config{basedir}));

	my $cwd = Cwd::getcwd;

	_PrintUsage("Can't change to basedir $config{context}\n") unless ($config{context} and (chdir $config{context}));

	chdir $cwd;

	require mains::SchedRt;
	require mains::FlowTls;
	require mains::FlowRt;
	require mains::SFlowRt;
	require mains::FlowSubs;
#	require mains::FlowScrs;

	require connectors::cafDBI;
	require connectors::refDBI;
	require connectors::cafQry;
	require connectors::refQry;

	my $found;
	my $usermodfound = undef;
	my $usermod = "$config{basedir}/usermod";
	$usermod =~ s/\/\//\//g;

	foreach my $dir (@INC) {
		if ($dir eq $config{basedir}) { $found = "yes" }
		if ($dir eq $usermod) { $usermodfound = "yes" }
		last if ($found and $usermodfound);
	} 

	push @INC, $config{basedir} unless ($found);
	push @INC, $usermod unless ($usermodfound);

	my $confpkg = $config{context} . "::conf";
	eval "require $confpkg";

	_PrintUsage("Can't load $confpkg\n$@") if ($@);

	_PrintUsage("Invalid mode parameter") unless ($config{mode} =~ /daemon|once|webservice/i);

	if ($config{flow} =~ /^[-]?\d+$/) { $config{flowId} = $config{flow}; }
	elsif (! $config{flow}) { $config{flowId} = -1; }
	else {
		_PrintUsage("Invalid Flow Id");
		die "Invalid Flow name\n" if ($config{flow} !~ /^[[:alpha:]]/);
		die "Invalid Flow name\n" if ($config{flow} =~ /[^_[:alnum:]]/);
		$config{flowName} = $config{flow};
	}

	if ($config{subflow} =~ /^(\d+)$/) { $config{subFlowId} = $config{subflow}; }
	elsif ($config{subflow}) {
		_PrintUsage("Invalid SubFlow Id");
		die "Invalid Flow name\n" if ($config{subflow} !~ /^[[:alpha:]]/);
		die "Invalid Flow name\n" if ($config{subflow} =~ /[^_[:alnum:]]/);
		$config{subFlowName} = $config{subflow};
	}

	$config{detach} = 0 unless ($config{detach});
	require tools::cafUtils;
	require tools::cafDbg;
	$config{timeLastRun} = cafUtils->datetime1(1);
	$config{epochLastRun} = 1;

	my $flowDir = $config{flowDir} = File::Spec->catdir($config{basedir}, $config{contextId}, $config{flowId});
	unless (-d $flowDir) {
		mkdir $flowDir;
	}

	chdir $flowDir;

	mkdir File::Spec->catdir($flowDir, "tmp") unless (-d "tmp");
	mkdir File::Spec->catdir($flowDir, "ftp") unless (-d "ftp");
	mkdir File::Spec->catdir($flowDir, "smtp") unless (-d "smtp");
	mkdir File::Spec->catdir($flowDir, "pop3") unless (-d "pop3");
	mkdir File::Spec->catdir($flowDir, "ldap") unless (-d "ldap");
	mkdir File::Spec->catdir($flowDir, "lfs") unless (-d "lfs");
	mkdir File::Spec->catdir($flowDir, "http") unless (-d "http");
	mkdir File::Spec->catdir($flowDir, "https") unless (-d "https");
	chdir $cwd;
	return \%config;

}

sub go {

	my $cronCfg = _ProcessOptions();

	my $sub = \&launcher::CronDispatcher;
	my $cron = FlowRt->new($sub, $cronCfg);


	if ($cronCfg->{mode} eq "once") {
		if ($cronCfg->{flowId} > 0) {
			my $pLabel = "mains::FlowRt Run " . $cronCfg->{flowId};
			$0 = $pLabel;
#			my $flowObject = FlowRt->new($cronCfg);
			$cron->MySchedulerId("__manual__");
			$cron->ProcessFlow();
			exit;
		}
	}
	elsif ($cronCfg->{mode} eq "daemon") {
		$cron->run(detach => $cronCfg->{detach});
	}
	elsif ($cronCfg->{mode} eq "webservice") {
		$cron->run(detach => $cronCfg->{detach});
	}

}

#Instance variables
#Running subflows
#Running 

go();
