#!/usr/bin/perl
use strict;
use DBI;
use Getopt::Long;
use Cwd;
use File::Basename;


#CREATE VIEW V_OBJE_COLS AS
my $MigrationQueries = {
V_OBJE_COLS  => "
SELECT
cols.idnt AS object_id,
cols.idnttabl AS parent_id,
cols.enam /*|| '_' || obje.idnt*/ AS name,
cols.enam AS externalname,
cols.mnemdtyp,
cols.mnemdtyp AS datatypeid,
cols.mnemfdta AS dataformat,
cols.prec AS datalength,
cols.scal AS datascale,
cols.ordr AS fieldorder,
cols.posi AS fieldpos,
cols.kpos AS keyposition,
cols.mnemcolslocl AS localfield,
cols.xmlsntyp,
cols.xmlspere,
obje.idnt AS id,
obje.mnemotyp,
obje.mnemotyp AS type,
obje.labl AS objectlabel,
obje.odsc AS comments,
obje.mnemstatobje as status,
to_char(obje.cdat, 'YYYY/MM/DD HH24:MI:SS') AS created,
to_char(obje.mdat, 'YYYY/MM/DD HH24:MI:SS') AS modified
FROM cols, obje WHERE (cols.idnt = obje.idnt)",

#CREATE VIEW V_OBJE_DATB AS
V_OBJE_DATB  => "
SELECT
datb.idnt AS object_id,
datb.mnemdbty AS driverid,
datb.mnemdbty,
datb.enam /*|| '_' || obje.idnt*/ AS name,
datb.enam AS externalname,
-1 AS userid,
datb.usrn,
datb.pass,
datb.serv,
datb.port AS port,
datb.mnemprot,
datb.mnemprot AS protocolid,
datb.dire AS directory,
datb.xdtd,
datb.dbin,
datb.wtbl,
'master' AS ismaster,
obje.idnt AS id,
obje.mnemotyp,
obje.mnemotyp AS type,
obje.labl AS objectlabel,
obje.odsc AS comments,
obje.mnemstatobje AS status,
to_char(obje.cdat, 'YYYY/MM/DD HH24:MI:SS') AS created,
to_char(obje.mdat, 'YYYY/MM/DD HH24:MI:SS') AS modified,
obje.ddat,
obje.sdat
FROM datb, obje WHERE (datb.idnt = obje.idnt)", 


#CREATE VIEW V_OBJE_FLOW AS
V_OBJE_FLOW  => " 
SELECT
flow.idnt,
flow.idnt AS object_id,
flow.mnemftyp AS flowtype,
flow.mnemisok,
'independant' AS incomrel, 
'yes' AS bufferedflow,
1 AS commintinterv,
obje.idnt AS id,
obje.mnemotyp,
obje.mnemotyp AS type,
obje.labl /*|| '_' || obje.idnt*/ AS name,
obje.labl AS object_label,
obje.odsc AS comments,
obje.mnemstatobje AS status,
to_char(obje.cdat, 'YYYY/MM/DD HH24:MI:SS') AS created,
to_char(obje.mdat, 'YYYY/MM/DD HH24:MI:SS') AS modified,
obje.ddat,
obje.sdat
FROM flow, obje WHERE (flow.idnt = obje.idnt)", 


#CREATE VIEW V_OBJE_FTBL AS
V_OBJE_FTBL  => " 
SELECT
ftbl.idnt,
ftbl.idnt AS object_id,
ftbl.idntflow AS parent_id,
ftbl.idntflow AS flow_id,
ftbl.ordr AS floworder,
ftbl.idnttabl AS container_id,
ftbl.mnemdire,
ftbl.mnemdire AS flowdirection,
ftbl.mnemmeth,
ftbl.mnemmeth AS flowmethod,
'no' AS dependant,
'no' AS direct,
'no' AS keepalive,
'yes' AS mailonerror,
'no' AS mailonsucc,
obje.idnt AS id,
obje.mnemotyp,
obje.mnemotyp AS type,
obje.labl /*|| '_' || obje.idnt*/ AS name,
obje.labl AS objectlabel,
obje.odsc AS comments,
obje.mnemstatobje AS status,
to_char(obje.cdat, 'YYYY/MM/DD HH24:MI:SS') AS created,
to_char(obje.mdat, 'YYYY/MM/DD HH24:MI:SS') AS modified,
obje.ddat,
obje.sdat
FROM ftbl, obje WHERE (ftbl.idnt = obje.idnt)", 


#CREATE VIEW V_OBJE_PROG AS
V_OBJE_PROG  => " 
SELECT
obje.idnt,
obje.idnt AS id,
obje.mnemotyp,
obje.mnemotyp AS type1,
obje.labl /*|| '_' || obje.idnt*/ AS name,
obje.labl AS objectlabel,
obje.odsc AS comments,
obje.mnemstatobje AS status,
to_char(obje.cdat, 'YYYY/MM/DD HH24:MI:SS') AS created,
to_char(obje.mdat, 'YYYY/MM/DD HH24:MI:SS') AS modified,
obje.ddat,
obje.sdat,
prog.idnt AS object_id,
prog.mnemprogtype,
prog.mnemprogtype AS scripttype,
prog.mnemplng AS type,
'no' AS parsed,
prog.text,
prog.text AS scripttext
FROM obje, prog WHERE (obje.idnt = prog.idnt)", 


#CREATE VIEW V_OBJE_TABL AS
V_OBJE_TABL  => " 
SELECT
obje.idnt,
obje.idnt AS id,
obje.mnemotyp,
obje.mnemotyp AS type,
obje.labl AS objectlabel,
obje.odsc AS comments,
obje.mnemstatobje AS status,
to_char(obje.cdat, 'YYYY/MM/DD HH24:MI:SS') AS created,
to_char(obje.mdat, 'YYYY/MM/DD HH24:MI:SS') AS modified,
obje.ddat,
obje.sdat,
tabl.idnt AS object_id,
tabl.enam /*|| '_' || obje.idnt*/ AS name,
tabl.enam AS externalname,
tabl.idntdatb AS connector_id,
tabl.idntdatb AS parent_id,
tabl.mnemcoln AS column_names,
tabl.mnemdflw,
tabl.mnemdflw AS flowdirection,
tabl.mnemtrig,
tabl.mnempkey,
tabl.mnemelog,
tabl.mnemurbs AS rollbackspace,
tabl.mnemilog,
tabl.mnemolog,
tabl.mnemxcre AS xreate,
tabl.fsep AS field_sep,
tabl.rsep AS record_sep,
tabl.ssep AS quote_char,
tabl.idntcolsdate,
tabl.idntcolstime,
tabl.escp AS escape_char
FROM obje, tabl WHERE (obje.idnt = tabl.idnt)",

#CREATE VIEW V_OBJE_OPRG AS
V_OBJE_OPRG  => " 
SELECT
oprg.idntobje AS object_id,
oprg.idntprog AS script_id,
prog.mnemprogtype,
prog.mnemprogtype AS step
FROM oprg, prog WHERE oprg.idntprog = prog.idnt",

#CREATE VIEW V_OBJE_OBJE AS
V_OBJE_OBJE  => " 
SELECT
oprg.idntobje AS object_id,
oprg.idntprog AS script_id,
'flwdatb' AS mnemprogtype,
'flwdatb' AS step
FROM oprg, obje WHERE oprg.idntprog = obje.idnt and obje.mnemotyp != 'prog'",

#CREATE VIEW V_OBJE_FCOL AS
V_OBJE_FCOL => "SELECT
fcol.idntftbl AS subflow_id,
fcol.idntcolsout AS outgofield_id,
fcol.idntcolsin AS incomfield_id,
fcol.idntprog AS script_id
FROM fcol WHERE 1 = 1",
};

my %aldtypes_objetypes = (
			datb => ['connector', 'datb',   'Bases de donnes'],
			tabl => ['container', 'tabl',   'Tables'],
			cols => ['field', 'cols',   'Champs de table'],
			flow => ['flow', 'flow',   'Flux global'],
			ftbl => ['subflow', 'ftbl',   'Demi flux'],
			prog => ['script', 'prog',   'Scripts'],
			sql =>  ['sql', 'prog',   'Scripts'],
			perl => ['perl', 'prog',   'Scripts'],
			clnd => ['clnd', 'clnd',   'Planifiaction']
			);

my %aldtypes_evnttypes = (
			['flow',   'Planification d\'un flux'],
			['tabl',   'Planification de la purge d\'une table '],
			['prog',   'Planification d\'un script utilisateur'],
			);


my %aldtypes_dbtypes = (
			oracle    => ['Oracle', 'oracle', 'Oracle V7-V8'],
			pg        => ['Pg', 'pg',     'Postgres'],
			mysql     => ['mySql', 'Mysql',  'MySql'],
			csv       => ['CSV', 'csv',    'Fichiers avec serparateurs'],
			flff      => ['FLR', 'flff',   'Fichiers - Enr de taille fixe'],
			xml       => ['XML', 'xml',    'Fichiers XML'],
			html      => ['HTML', 'html',   'Fichiers HTML'],
			vrac      => ['VRAC', 'vrac',   'En vrac']
			);

my @aldtypes_proglang = (
			['perl',    'Perl V5'],
			['sql',     'Langage SQL'],
			);

my @aldtypes_zobjestat = (
	        ['online',       'Actif'],
		['offline',      'Inactif'],
		['running',      'En execution'],
		['error',        'En erreur'],
);

my %aldtypes_objestat = (
			online  => ['online',       'Actif'],
			offline => ['offline',      'Inactif'],
			develop => ['develop',      'En dve'],
			test    => ['test',         'En test'],
			deleted =>['deleted',      'Supprim'],
			);

my %aldtypes_prottylist = (
			dbi         => ['DBI', 'dbi',          'DBI de Perl'],
			lfs         => ['LFS', 'lfs',          'Systme de fichier local'],
			ftp         => ['FTP', 'ftp',          'Ftp'],
			http        => ['HTTP', 'http',         'HTTP'],
			smtp        => ['SMTP', 'smtp',         'SMTP'],
			pop3        => ['POP3', 'pop3',         'POP3'],
			);

my %aldtypes_flowtypes = (
			simple        => ['simple', 'simple',         'Flux simple'],
			replicat        => ['replicat', 'replicat',       'Flux de rplication'],
			);

my %aldtypes_ftblmethodsi = (
			P        => ['normal', 'P',         'NORMAL'],
			O        => ['full', 'O',         'TRUNC'],
			);

my %aldtypes_ftblmethodso = (
			IU       => ['insupd', 'IU',         'INS-UPD'],
			UI       => ['updins', 'UI',         'UPD-INS'],
			I        => ['insert', 'I',          'INSERT'],
			U        => ['update', 'U',          'UPDATE'],
			DI       => ['delins', 'DI',         'DEL-INS'],
			D        => ['delete', 'D',          'DELETE'],
			O        => ['truncate', 'O',          'TRUNC'],
			);

my %aldtypes_dflowlist = (
			inco     => ['incom', 'inco',         'Flux entrant'],
			outgo    => ['outgo', 'outgo',        'Flux sortant'],
			inou     => ['inout', 'inou',         'Flux mixte'],
			);

my %aldtypes_dflowlist2 = (
			inco        => ['incom', 'inco',         'Flux entrant'],
			outgo        => ['outgo', 'outgo',        'Flux sortant'],
			);

my @aldtypes_colnlist = (
			['none',         'Pas de nom de colonnes'],
			['first',        'Premiere ligne'],
			);

my @aldtypes_trigtypes = (
			['no',           'Pas de triggers'],
			['yes',          'Utiliser les triggers'],
			['dattim',       'Champ date heure'],
			);

my @aldtypes_tabletypes = (
		['table', 'Les tables'],
		['view',   'Les vues'],
		['both',   'Les tables et les vues']
		);
			
my %aldtypes_progtypes = (
		qrysel        => ['select', 'qrysel',     'Table : requte SELECT'],
		qryins        => ['insert', 'qryins',     'Table : requte INSERT'],
		qryupd        => ['update', 'qryupd',     'Table : requte UPDATE'],
		qrydel        => ['delete', 'qrydel',     'Table : requte DELETE'],
		qrytrunc      => ['truncate', 'qrytrunc',   'Table : requte TRUNCATE'],
		tblbopen      => ['sbopen', 'tblbopen',   'Table : avant ouvrir'],
		tblaopen      => ['saopen', 'tblaopen',   'Table : aprs ouvrir'],
		tblbread      => ['sbread', 'tblbread',   'Table : avant lecture enr'],
		tblaread      => ['saread', 'tblaread',   'Table : aprs lecture enr'],
		tbltrans      => ['stransform', 'tbltrans',   'Table : transformation'],
		tblbwrite     => ['sbwrite', 'tblbwrite',  'Table : avant criture enr'],
		tblawrite     => ['sawrite', 'tblawrite',  'Table : aprs criture enr'],
		tblbclose     => ['sbclose', 'tblbclose',  'Table : avant fermer'],
		tblaclose     => ['saclose', 'tblaclose',  'Table : aprs fermer'],
		flwbopen      => ['bstart', 'flwbopen',   'Flux  : avant ouvrir'],
		flwaopen      => ['astart', 'flwaopen',   'Flux  : aprs ouvrir'],
		flwbclose     => ['bstop', 'flwbclose',  'Flux  : avant fermer'],
		flwaclose     => ['astop', 'flwaclose',  'Flux  : aprs fermer'],
		flwdatb       => ['flwdatb', 'flwdatb',  'Flux  : autre base de donne'],
		flwdatb       => ['flwdatb', 'flwdatb',  'Flux  : autre base de donne'],
		flwqry        => ['flwqry', 'flwqry',   'Flux  : autre requte'],
		flwqry        => ['flwqry', 'flwqry',   'Flux  : autre requte'],
		flwqry        => ['flwqry', 'flwqry',   'Flux  : autre requte'],
		flwqry        => ['flwqry', 'flwqry',   'Flux  : autre requte'],
		coltrans      => ['ctransform', 'coltrans',   'Champ : transformation'],
#		dtbbopen      => ['dtbbopen', 'dtbbopen',   'BdD   : avant connexion'],
#		dtbaopen      => ['dtbaopen', 'dtbaopen',   'BdD   : aprs connexion'],
#		dtbbclose     => ['dtbbclose', 'dtbbclose',  'BdD   : avant dconnexion'],
#		dtbaclose     => ['dtbaclose', 'dtbaclose',  'BdD   : aprs dconnexion'],
		userscript    => ['user', 'userscript', 'Scripts utilisateur'],
		onerror       => ['onerror', 'onerror',    'Gestion d\'erreurs'],
		);

my @aldtypes_tblprogtypes = (
		['qrysel',     'Table : requte SELECT'],
		['qryins',     'Table : requte INSERT'],
		['qryupd',     'Table : requte UPDATE'],
		['qrydel',     'Table : requte DELETE'],
		['qrytrunc',   'Table : requte TRUNCATE'],
		['tblbopen',   'Table : avant ouvrir'],
		['tblaopen',   'Table : aprs ouvrir'],
		['tblbread',   'Table : avant lecture enr'],
		['tblaread',   'Table : aprs lecture enr'],
		['tbltrans',   'Table : transformation'],
		['tblbwrite',  'Table : avant criture enr'],
		['tblawrite',  'Table : aprs criture enr'],
		['tblbclose',  'Table : avant fermer'],
		['tblaclose',  'Table : aprs fermer'],
		['onerror',    'Gestion d\'erreurs'],
		);

my @aldtypes_flwprogtypes = (
		['flwbopen',   'Flux  : avant ouvrir'],
		['flwaclose',  'Flux  : aprs fermer'],
		['onerror',    'Gestion d\'erreurs'],
		);

my @aldtypes_dtbprogtypes = (
		['dtbbopen',   'BdD   : avant connexion'],
		['dtbaopen',   'BdD   : aprs connexion'],
		['dtbbclose',  'BdD   : avant dconnexion'],
		['dtbaclose',  'BdD   : aprs dconnexion'],
		['onerror',    'Gestion d\'erreurs'],
		);

my %aldtypes_sqlprogtypes = (
		'qrysel'   => 1,
		'qryins'   => 1,
		'qryupd'   => 1,
		'qrydel'   => 1,
		'qrytrunc' => 1,
		);

# Les protocoles
my @aldtypes_prottypes = (
			['dbi',     'Driver DBI'],
			['lfs',     'System de fichier local'],
			['ftp',     'service ftp'],
			['mail',    'Mail (pop3)'],
			['http',    'Serveur www'],
			['telnet',  'Service telnet']
			);

# Type de champ <=> XML
my @aldtypes_xmlelttypes = (
				[ 'node',    'Noeud' ],
				[ 'leaf',    'Feuille' ],
				[ 'attrib',  'Attribut' ],
);

#Format de donnes

#Types de donnes

my %aldtypes_datatypesconv = (
'standard' => {
         0 => 'SQL_ALL_TYPES',
         1 => 'SQL_CHAR',
         2 => 'SQL_NUMERIC',
         3 => 'SQL_DECIMAL',
         4 => 'SQL_INTEGER',
         5 => 'SQL_SMALLINT',
         6 => 'SQL_FLOAT',
         7 => 'SQL_REAL',
         8 => 'SQL_DOUBLE',
         9 => 'SQL_DATE',
        10 => 'SQL_TIME',
        11 => 'SQL_TIMESTAMP',
        12 => 'SQL_VARCHAR',
        -1 => 'SQL_LONGVARCHAR',
        -2 => 'SQL_BINARY',
        -3 => 'SQL_VARBINARY',
        -4 => 'SQL_LONGVARBINARY',
        -5 => 'SQL_BIGINT',
        -6 => 'SQL_TINYINT',
        -7 => 'SQL_BIT',
        -8 => 'SQL_WCHAR',
        -9 => 'SQL_WVARCHAR',
       -10 => 'SQL_WLONGVARCHAR'
				},
'mysql'    => {
        'VARCHAR'    =>  12,
        'DECIMAL'    =>   3,
        'TINYINT'    =>  -6,
        'SMALLINT'   =>   5,
        'INTEGER'    =>   4,
        'FLOAT'      =>   7,
        'DOUBLE'     =>   8,
        'TIMESTAMP'  =>   11,
        'BIGINT'     =>   -5,
        'MIDDLEINT'  =>   4,
        'DATE'       =>   9,
        'TIME'       =>   10,
        'DATETIME'   =>   11,
        'YEAR'       =>   5,
        'DATE'       =>   9,
        'ENUM'       =>   12,
        'SET'        =>   12,
        'BLOB'       =>   -1,
        'TINYBLOB'   =>   -1,
        'MEDIUMBLOB' =>   -1,
        'LONGBLOB'   =>   -1
				},
'pg'       => {
        'BOOL'       =>   0,
        'INT8'       =>   8,
        'INT2'       =>   5,
        'INT4'       =>   4,
        'TEXT'       =>  12,
        'FLOAT4'     =>   6,
        'FLOAT8'     =>   7,
        'ABSTIME'    =>  10,
        'RELTIME'    =>  10,
        'TINTERVAL'  =>  11,
        'MONEY'      =>   0,
        'BPCHAR'     =>  12,
        'VARCHAR'    =>  12,
        'DATE'       =>   9,
        'TIME'       =>  10,
        'DATETIME'   =>  11,
        'TIMESPAN'   =>  11,
        'TIMESTAMP'  =>  10
        },
'oracle'    => {
        'LONG_RAW'   =>  -4,
        'RAW'        =>  -3,
        'LONG'       =>  -1,
        'CHAR'       =>   1,
        'NUMBER'     =>   3,
        'DOUBLE'     =>   8,
        'DATE'       =>  11,
        'VARCHAR2'   =>  12
        },
'csv'       => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'flff'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'xml'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'html'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
'vrac'      => {
        'VARCHAR'    =>  12,
        'CHAR'       =>   1,
        'INTEGER'    =>   4,
        'REAL'       =>   7,
        'BLOB'       =>  -4,
        'DATETIME'   =>  11,
        'TEXT'       =>  -1
				},
);

my %aldtypes_datatypes = (
'standard' => [
        ['SQL_ALL_TYPES', 'SQL_ALL_TYPES'],
        ['SQL_CHAR', 'SQL_CHAR'],
        ['SQL_NUMERIC', 'SQL_NUMERIC'],
        ['SQL_DECIMAL', 'SQL_DECIMAL'],
        ['SQL_INTEGER', 'SQL_INTEGER'],
        ['SQL_SMALLINT', 'SQL_SMALLINT'],
        ['SQL_FLOAT', 'SQL_FLOAT'],
        ['SQL_REAL', 'SQL_REAL'],
        ['SQL_DOUBLE', 'SQL_DOUBLE'],
        ['SQL_DATE', 'SQL_DATE'],
        ['SQL_TIME', 'SQL_TIME'],
        ['SQL_TIMESTAMP', 'SQL_TIMESTAMP'],
        ['SQL_VARCHAR', 'SQL_VARCHAR'],
        ['SQL_LONGVARCHAR', 'SQL_LONGVARCHAR'],
        ['SQL_BINARY', 'SQL_BINARY'],
        ['SQL_VARBINARY', 'SQL_VARBINARY'],
        ['SQL_LONGVARBINARY', 'SQL_LONGVARBINARY'],
        ['SQL_BIGINT', 'SQL_BIGINT'],
        ['SQL_TINYINT', 'SQL_TINYINT'],
        ['SQL_BIT', 'SQL_BIT'],
        ['SQL_WCHAR', 'SQL_WCHAR'],
        ['SQL_WVARCHAR', 'SQL_WVARCHAR'],
        ['SQL_WLONGVARCHAR', 'SQL_WLONGVARCHAR']
		],
'mysql'    => [
        ['VARCHAR', 'VARCHAR'],
        ['DECIMAL', 'DECIMAL'],
        ['TINYINT', 'TINYINT'],
        ['INT', 'INT'],
        ['SMALLINT', 'SMALLINT'],
        ['INTEGER', 'INTEGER'],
        ['FLOAT', 'FLOAT'],
        ['DOUBLE', 'DOUBLE'],
        ['TIMESTAMP', 'TIMESTAMP'],
        ['BIGINT', 'BIGINT'],
        ['MIDDLEINT', 'MIDDLEINT'],
        ['DATE', 'DATE'],
        ['TIME', 'TIME'],
        ['DATETIME', 'DATETIME'],
        ['YEAR', 'YEAR'],
        ['DATE', 'DATE'],
        ['ENUM', 'ENUM'],
        ['SET', 'SET'],
        ['BLOB', 'BLOB'],
        ['TINYBLOB', 'TINYBLOB'],
        ['MEDIUMBLOB', 'MEDIUMBLOB'],
        ['LONGBLOB', 'LONGBLOB']
		],
'pg'       => [
        ['BOOL', 'BOOL'],
        ['INT8', 'INT8'],
        ['INT2', 'INT2'],
        ['INT4', 'INT4'],
        ['TEXT', 'TEXT'],
        ['FLOAT4', 'FLOAT4'],
        ['FLOAT8', 'FLOAT8'],
        ['ABSTIME', 'ABSTIME'],
        ['RELTIME', 'RELTIME'],
        ['TINTERVAL', 'TINTERVAL'],
        ['MONEY', 'MONEY'],
        ['BPCHAR', 'BPCHAR'],
        ['VARCHAR', 'VARCHAR'],
        ['DATE', 'DATE'],
        ['TIME', 'TIME'],
        ['DATETIME', 'DATETIME'],
        ['TIMESPAN', 'TIMESPAN'],
        ['TIMESTAMP', 'TIMESTAMP']
     ],
'oracle'    => [
        ['LONG_RAW', 'LONG_RAW'],
        ['RAW', 'RAW'],
        ['LONG', 'LONG'],
        ['CHAR', 'CHAR'],
        ['NUMBER', 'NUMBER'],
        ['DOUBLE', 'DOUBLE'],
        ['DATE', 'DATE'],
        ['VARCHAR2', 'VARCHAR2']
     ],
'csv'       => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
'flff'      => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
'xml'      => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
'html'      => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
'vrac'      => [
        ['VARCHAR', 'VARCHAR'],
        ['CHAR', 'CHAR'],
        ['INTEGER', 'INTEGER'],
        ['REAL', 'REAL'],
        ['BLOB', 'BLOB'],
        ['DATETIME', 'DATETIME'],
        ['TEXT', 'TEXT']
			],
);

sub Question {
	my ($question, $answer, $pattern) = (shift, shift, shift);

	my $ans;
	while (1) {
		print  "$question [$answer] : ";
		$ans = <STDIN>;
		chomp $ans;
		if (defined($pattern)) { $ans = undef unless ($ans =~ /$pattern/); }
		if ($answer) { return $answer unless ($ans); }
		last if $ans;

	}
	return $ans;
}

sub YesNo {
	my ($question, $answer) = (shift, shift);
	while (1) {
		my $ans = Question($question . " (YES/NO)", $answer);
		$ans = uc($ans);
		if (($ans eq "YES") or ($ans eq "Y")) { return "yes"; }
		elsif (($ans eq "NO") or ($ans eq "N")) { return "no"; }
		print "\n";
	}
}

sub Usage {
	die "Usage initialize install {Q|R} dbname aliphepw [contextid]\n";
}

my ($dsn, $user, $pwd);
my ($v2server, $v2database, $v2user, $v2pwd);



my %config;
sub getparam  {
	Getopt::Long::GetOptions(\%config, "dsn=s", "user=s", "pwd=s", "flow=s", "ofile=s", "context=s");
	my $usage = "perl $0 --dsn=dbi:Pg:dbname=aliphev1db --user=aliphe --pwd=aliphe --flow=2238   --context=aliphe";
	unless ($config{user} and $config{pwd} and $config{flow} and $config{context} and $config{dsn}) {
		print  STDERR "ERROR : Usage $usage\n";
		die;
	}
#	print " ==== Base de donnes Aliphe V1====\n";
	$config{dsn} = Question ("DBI DSN ") unless ($config{dsn});
	$config{user}     = Question ("Utilisateur Postgres", "aliphe") unless ($config{user});
	$config{pwd}     = Question ("Mot de passe Postgres", "aliphe") unless ($config{pwd});
	$config{flow} = undef unless ($config{flow} =~ /^[[:digit:]]+$/);
	$config{flow}    = Question ("Id du flux a migrer", undef, '^[[:digit:]]*$') unless ($config{flow});
	$config{context}    = Question ("Id du flux a migrer") unless ($config{flow});

	$config{cwd} = Cwd::cwd();
 
	my ($name,$path,$suffix) = fileparse($0);

	chdir $path;
	my $path = Cwd::cwd();
	chdir "..";
	my $cwd = Cwd::cwd();
	push @INC, "$cwd";

	chdir $path;

	require tools::cafUtils;
	require tools::cafDbg;
	$config{opath} = $path;
	my $date = cafUtils->datetime1();
	$config{ofile} = $config{context} . "_" . $config{flow} . "_" . $date;
	$config{opackage} = $config{context} . "_" . $config{flow};
	$config{ofile} =~ s/[\/]/_/g;
	$config{ofile} =~ s/ ..:..:...*//g;
	$config{ofile} .= ".pm";
	$config{COMMENTS} =~ "Generated by $0 : $date"
	

}

sub executeqry {
	my $dbh = shift;
	my $qry = shift;
	my $keyfld = shift;
	my $p = shift;
#	$p=1;

	if ($p) { print "\n\nQUERY = $qry\n\n"; }
	my $sth = $dbh->prepare($qry);
	$sth->execute();
	my @ret = ();
	while (my $row = $sth->fetchrow_hashref()) {
		my %row = %{$row};
		push @ret, \%row;
	}
	$sth->finish();
	\@ret;
}


sub convqry {
	my $scripttext = shift;
	my $COLS=$1;
	my $COND=$2;
	my $QRY=$3;
	if ($scripttext =~ /##COLS##(.*)##.*##COND##/s) { $COLS=$1; }
	if ($scripttext =~ /##COND##(.*)##.*##QRY##/s) { $COND=$1; }
	if ($scripttext =~ /##QRY##(.*)/s) { $QRY=$1;}
	$QRY =~ s/^\s*//;
	
	my @cols = split(",",$COLS);
	my @bind = split(",",$COND);
	
	my $query = "";
	my $i = 0;
	my $inQ;
	my $inDQ;
	my $inP;
	my $in = 0;
	my $inAl = 0;
	my $iCols = 0;
	my $iCond = 0;
	my $qlen = length($QRY);
	if ($QRY =~ /^\s*SELECT/) {
		my $alias = "";
		$query="SELECT ";
		$QRY =~ /^(\s*SELECT\s*)/;
		$i = length ($1);
		$qlen = length($QRY);
		for (; $i < $qlen; $i++) {
			my $c = substr($QRY, $i, 1);
			if ($c eq "\\") {
				if ($inAl) { $alias += $c; } else { $query .= $c; }
				$i++;
				$c = substr($QRY, $i, 1);
				if ($inAl) { $alias += $c; }
				else { $query .= $c; }
				next;
			}
			elsif ($c eq "?") { if (!$inQ and !$inDQ) { $query .= ":c_$bind[$iCond]"; $iCond++; next; } }
			elsif ($c eq "'") {
				if ($inQ) { $inQ = undef; $in--; }
				elsif (!$inDQ) { $inQ = 1; $in += 1; }
			}
			elsif ($c eq '"') {
				if ($inDQ) { $inDQ = undef; $in--; }
				elsif (!$inQ) { $inDQ = 1; $in += 1; }
			}
			elsif ($c eq "(") {
				if (!$inQ && !$inDQ) { $inP++; $in++; }
			}
			elsif ($c eq ")") {
				if ($inP and !$inQ and !$inDQ) { $inP--; $in--; }
			}
			elsif ($c =~ /\s/) {
				if (!$in) {
#					$query .= " \@c_$cols[$iCols]$c" ; $iCols++; $inAl = 0; $alias = "";
					$inAl=1;
#					next;
				}
			}
			elsif ($c eq ",") {
				if (!$in) {
					$query .= " \@c_$cols[$iCols], " ; $iCols++; $inAl = 0; $alias = "";
					$i++;
					while (substr($QRY, $i, 1) =~ /\s/) { $i++; };
					$i--;
					next;
				}
			}
			if ($inAl == 1) { $alias += $c; }
#			elsif ($inAl == 2) { $query .= " \@c_$cols[$iCols]$c" ; $iCols++; $inAl = 0; $alias = ""; }
			else { $query .= $c; }
			if (!$in && (substr ($QRY, $i+1, 4) =~ /^FROM$/i)) {
				$query .= " \@c_$cols[$iCols]" ; $iCols++; $inAl = 0; $alias = "";
#				while (substr($QRY, $i +1, 1) =~ /\s/) { $i++; };
				last;
			}
		}
#		if ($inAl == 2) { $query .= " \@c_$cols[$iCols]" ; $iCols++; $inAl = 0; $alias = ""; }
	}
	
	
	for (; $i < $qlen; $i++) {
		my $c = substr($QRY, $i, 1);
		if ($c eq "\\") {
			$query .= $c;
			$i++;
			$c = substr($QRY, $i, 1);
			$query .= $c;
			next;
		}
		elsif ($c eq "?") { if (!$inQ and !$inDQ) { $query .= ":c_$bind[$iCond]"; $iCond++; next; } }
		elsif ($c eq "'") {
			if ($inQ) { $inQ = undef; $in = undef; }
			elsif (!$inDQ) { $inQ = 1; $in += 1; }
		}
		elsif ($c eq '"') {
			if ($inDQ) { $inDQ = undef; $in = undef; }
			elsif (!$inQ) { $inDQ = 1; $in += 1; }
		}
		$query .= $c;
	}
	
#	print "$QRY => $query \n";
	$query;
}



getparam();

my $migrobjs = {
		objects => {},
		thedump => {},
		attributes => {},
		mapping => [],
		objscr => {},
		otherobj => {},
		config => \%config,
		mapping => {}
	};

my $objects = $migrobjs->{objects};
my $thedump = $migrobjs->{thedump};
my $attributes = $migrobjs->{attributes};
my $otherobj = $migrobjs->{otherobj};
my $objscr = $migrobjs->{objscr};
my $mapping = $migrobjs->{mapping};



my $dbh;
eval {

	require Data::Dumper;
	$dbh = DBI->connect ($config{dsn}, $config{user}, $config{pawd}, {RaiseError => 1});
#	$dbh->{FetchHashKeyName} = 'NAME_lc';

	my $rows = executeqry($dbh, $MigrationQueries->{V_OBJE_FLOW} . " AND obje.idnt = $config{flow}", "object_id");
	my $row = $rows->[0];

	if ($row and $row->{object_id}) {
		$row->{type} = 'flow';
		$objects->{$row->{object_id}} = { last_modified => $row->{modified} || cafUtils->datetime3(1) };
		my %f =  %{$row};
		$thedump->{$row->{object_id}} = \%f;
	}
	else { die "$config{flow} is not a flow" unless ($row->{mnemotyp} eq "flow"); }

	$rows = executeqry($dbh, $MigrationQueries->{V_OBJE_FTBL} . " AND ftbl.idntflow = $config{flow}", "object_id");
	my $wtab = "";
	my $wftbl = "";
	my $wsep = "";
	my @tabs = ();
	foreach  $row (@$rows) {
		$row->{type} = 'subflow';
		$objects->{$row->{object_id}} = { last_modified => $row->{modified} || cafUtils->datetime3(1) };
		$row->{flowdirection} = $aldtypes_dflowlist{$row->{mnemdire}}[0];
		$row->{flowmethod} = $aldtypes_ftblmethodsi{$row->{mnemmeth}}[0] if ($row->{flowdirection} eq 'incom');
		$row->{flowmethod} = $aldtypes_ftblmethodso{$row->{mnemmeth}}[0] if ($row->{flowdirection} eq 'outgo');
		my %f =  %{$row};
		$thedump->{$row->{object_id}} = \%f;
		$wtab = "$wtab$wsep$row->{container_id}";
		push @tabs, $row->{container_id};
		$wftbl = "$wftbl$wsep$row->{object_id}";
		$wsep=", ";
	}

	my $wdbs = "";

#	print "QUERY = $MigrationQueries->{V_OBJE_TABL}  AND tabl.idnt in ($wtab)\n";
	if ($wtab) {
		$rows = executeqry($dbh, $MigrationQueries->{V_OBJE_TABL} . " AND tabl.idnt in ($wtab)", "object_id");
		$wsep = "";
		foreach  $row (@$rows) {
			$row->{type} = 'container';
			$objects->{$row->{object_id}} = { last_modified => $row->{modified} || cafUtils->datetime3(1) };
			$row->{flowdirection} = $aldtypes_dflowlist{$row->{mnemdflw}}[0];
			my %f =  %{$row};
			$thedump->{$row->{object_id}} = \%f;
			$wdbs = "$wdbs$wsep$row->{connector_id}";
			$wsep=", ";
		}
	}

	
	if ($wdbs) {
		$rows = executeqry($dbh, $MigrationQueries->{V_OBJE_DATB} . " AND datb.idnt in ($wdbs)", "object_id", 0);
		$wsep = "";
		foreach  $row (@$rows) {
			$row->{type} = 'connector';
			$objects->{$row->{object_id}} = { last_modified => $row->{modified} || cafUtils->datetime3(1) };
			$row->{driverid} = $aldtypes_dbtypes{$row->{mnemdbty}}[0];
			$row->{protocolid} = $aldtypes_prottylist{$row->{mnemprot}}[0];
			if ($row->{protocolid} =~ /^LFS|^FTP/) {
				$attributes->{$row->{object_id}} = {} unless ($attributes->{$row->{object_id}});
				$attributes->{$row->{object_id}}{DIRECTORY} = $row->{directory};
				foreach my $obj (@tabs) {
					my $tab = $thedump->{$obj};
					if (($tab->{connector_id} == $row->{object_id}) and ($row->{driverid} eq 'CSV')) {
						$attributes->{$tab->{object_id}} = {} unless ($attributes->{$tab->{object_id}});
						$attributes->{$tab->{object_id}}{COLUMN_NAMES} = $tab->{column_names} if ($tab->{column_names});
						$attributes->{$tab->{object_id}}{RECORD_SEP} = $tab->{record_sep} if ($tab->{record_sep});
						$attributes->{$tab->{object_id}}{FIELD_SEP} = $tab->{field_sep} if ($tab->{field_sep});
						$attributes->{$tab->{object_id}}{QUOTE_CHAR} = $tab->{quote_char} if ($tab->{quote_char});
						$attributes->{$tab->{object_id}}{ESCAPE_CHAR} = $tab->{escape_char} if ($tab->{escape_char});
					}
				}
			}
			elsif ($row->{protocolid} =~ /^DBI/) {
				$attributes->{$row->{object_id}} = {} unless ($attributes->{$row->{object_id}});
				$attributes->{$row->{object_id}}{AutoCommit} = 0;
				$attributes->{$row->{object_id}}{RaiseError} = 1;
				$attributes->{$row->{object_id}}{PrintError} = 0;
				if ($row->{driverid} eq 'mySql') {$attributes->{$row->{object_id}}{AutoCommit} = 1; }
			}
			my %f =  %{$row};
			$thedump->{$row->{object_id}} = \%f;
		}
	}


	if ($wtab) {
		$rows = executeqry($dbh, $MigrationQueries->{V_OBJE_COLS} . " AND cols.idnttabl in ($wtab)", "object_id", 0);
		$wsep = "";
		foreach  $row (@$rows) {
				$row->{type} = 'field';
			$objects->{$row->{object_id}} = { last_modified => $row->{modified} || cafUtils->datetime3(1) };
			my $table = $thedump->{$row->{parent_id}};
			my $datb = $thedump->{$table->{parent_id}};
			my $conv = $aldtypes_datatypesconv{$datb->{mnemdbty}};
			my $standard = $aldtypes_datatypesconv{standard};
			$row->{datatypeid} = $standard->{$conv->{$row->{mnemdtyp}}};
			$row->{datatypeid} = $row->{mnemdtyp} unless ($row->{datatypeid});
			$row->{localfield} = 'no' unless ($row->{localfield});
			my %f =  %{$row};
			$thedump->{$row->{object_id}} = \%f;
		}
	}


	my $woprg;
	if ($wftbl) { $woprg = "$wftbl, $config{flow}"; }
	else { $woprg = "$config{flow}"; }
	my $query = $MigrationQueries->{V_OBJE_OPRG} . " AND oprg.idntobje in ($woprg)";
	$query .= " UNION " . $MigrationQueries->{V_OBJE_OBJE} . " AND oprg.idntobje = $config{flow}",
	$rows = executeqry($dbh, $query, "object_id", 0);
#	$migrobjs->{scrobjs} = $rows;
	my $wprg = "";
	my $wprgsep = "";
	
	foreach  $row (@$rows) {
		if ($row->{script_id}) {
			if ($row->{mnemprogtype} eq 'flwdatb') {
				$otherobj->{$row->{object_id}} = [] unless ($otherobj->{$row->{object_id}});
				push @{$otherobj->{$row->{object_id}}}, {child_id => $row->{script_id}, perent_id => $row->{object_id}};
			}
			else {
				$wprg = "$wprg$wprgsep$row->{script_id}";
				$row->{step} = $aldtypes_progtypes{$row->{mnemprogtype}}[0];
				$objscr->{$row->{object_id}} = [] unless ($objscr->{$row->{object_id}});
				push @{$objscr->{$row->{object_id}}}, { step => $row->{step}, object_id => $row->{object_id}, script_id => $row->{script_id}};
				$wprgsep=", ";
			}
		}
	}

	if ($wftbl) {
		$rows = executeqry($dbh, $MigrationQueries->{V_OBJE_FCOL} . " AND fcol.idntftbl in ($wftbl)", "object_id", 0);
		foreach  $row (@$rows) {
			my $subflow_id = $row->{subflow_id};
			$mapping->{$subflow_id} = [] unless ($mapping->{$subflow_id});
			push @{$mapping->{$subflow_id}}, $row;
			if ($row->{script_id}) { $wprg = "$wprg$wprgsep$row->{script_id}"; $wprgsep=", "; }
		}
	}
	
	if ($wprg) {
		$rows = executeqry($dbh, $MigrationQueries->{V_OBJE_PROG} . " AND prog.idnt in ($wprg)", "object_id", 0);
		$wsep = "";
		foreach  $row (@$rows) {
			$objects->{$row->{object_id}} = { last_modified => $row->{modified} || cafUtils->datetime3(1) };
			$row->{scripttype} = $aldtypes_progtypes{$row->{mnemprogtype}}[0];
			if ($row->{type} eq 'sql') {
				$row->{scripttext} = convqry($row->{scripttext});
				$row->{parsetext} = cafUtils->parsesql($row->{scripttext});
				my $dump = Data::Dumper->new([$row->{parsetext}], ["parsedtext"]);
				$dump->Indent(1);
				$row->{parsetext} = $dump->Dump;
			}
			my %f =  %{$row};
			$thedump->{$row->{object_id}} = \%f;
		}
	}





	my $dump = Data::Dumper->new([$migrobjs], ["migrobjs"]);
	my $ptext = $dump->Dump;
	chdir $config{opath};
	open FOUT, ">$config{ofile}";
	print FOUT "package $config{opackage};\n";
	print FOUT $ptext, "\n";
	print FOUT "sub objectsrefs { return \$migrobjs; }\n\n1;\n";
	close FOUT;
	chdir $config{cwd};
	$dbh->disconnect();

};

if ($@) { print "$@ " . "\n"; }

1;
