from common import *
from pgtmlgraph import *
from pgmlgraph import *

SERIALTYPE = 'integer'
KEYROW = 'key_row'

class PgtmlPhp(PgtmlGraph):
	def write_update_query(self, output):
		if self.name == '':
			stderr.write('ERROR : no view name in pgtml !')
			exit(0)
		
		attributes = []
		indexes = []
		s_params = []

		for vtable in self.values():
			for attr in vtable.object.values() + vtable.object.constraints.values():
				if attr.has_key('rank') and attr['update'] != 'no':
					indexes.append(attr['rank'])
					attr['table'] = vtable.object.table_name;
					attributes.append(attr)

		indexes.sort()
		attributes.sort(self._compare_attribute)
		for attr in attributes:
			s_params.append("$%s___%s" % (attr['table'],attr['name']))
		
		output.write("<?$query=\"select update_%s(%s)\";?>" % (self.name,joinfields(s_params, ',')))

	def write_insert_query(self, output):
		if self.name == '':
			stderr.write('ERROR : no view name in pgtml !')
			exit(0)
		
		attributes = []
		indexes = []
		s_params = []

		for vtable in self.values():
			for attr in vtable.object.values():
				if attr.has_key('rank') and attr['insert'] != 'no':
					indexes.append(attr['rank'])
					attr['table'] = vtable.object.table_name;
					attributes.append(attr)

		indexes.sort()
		attributes.sort(self._compare_attribute)
		for attr in attributes:
			s_params.append("$%s___%s" % (attr['table'],attr['name']))
		
		output.write("<?$query=\"select insert_%s(%s)\";?>" % (self.name,joinfields(s_params, ',')))
	
	def write_select_query(self, output):
		if self.name == '':
			stderr.write('ERROR : no view name in pgtml !')
			exit(0)
		output.write("<?$query=\"");
		PgtmlGraph.write_select_query(self,output)
		output.write("\";?>");

		
	def write_insert_form(self, output):
		if self.name == '':
			stderr.write('ERROR : no view name in pgtml !')
			exit(0)
		
		for vtable in self.values():
			for c in vtable.object.values():
				type=""
				if c['as']==KEYROW:
					output.write("<input type=\"hidden\" name=\"%s___%s\" value=\"<?echo $GLOBALS[\"%s___%s\"];?>\">\n" % (vtable.object.table_name,c['name'], vtable.object.table_name,c['name']))
				else:
					if c['insert']!='no':
						name = "%s___%s" % (vtable.object.table_name,c['name'])
						output.write("<tr><td>%s</td><td>" % (c['show-as'] or c['name']))
						if c['show-type']:
							type=split(c['show-type'],",")
							while len(type)<3:
								type.append(0)
						else:
							type=["text",0,0]
						if type[0]=="password":
							if not type[1]:
								type[1]=30
							output.write("<input type=\"password\" name=\"%s\" value=\"<?echo $GLOBALS[\"%s\"];?>\" size=\"%s\">" % (name,name,type[1]));
						elif type[0]=="text" and type[2]>1:
							if not type[1]:
								type[1]=30
							if not type[2]:
								type[2]=5
							output.write("<textarea name=\"%s\" cols=\"%s\" rows=\"%s\"><?echo $GLOBALS[\"%s\"];?></textarea>" % (name,type[1],type[2],name));
						else:
							if not type[1]:
								type[1]=30
							output.write("<input type=\"text\" name=\"%s\" value=\"<?echo $GLOBALS[\"%s\"];?>\" size=\"%s\">" % (name,name,type[1]));
						output.write("</td></tr>\n")
