""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from log import *
from dbhandler import DbHandler
from sax import *
from common import *
from string import *

class XmlDb(DbHandler):

	class XmlHandler(CommonHandler):
		def __init__(self, name, xmldb):
			CommonHandler.__init__(self, name)
			self.xmldb = xmldb
			self.oidStack = Stack()
			self.parentOid = None
			self.oidStack.push(self.parentOid)
			
		def startElement(self, name, attrs):
			CommonHandler.startElement(self, name, attrs)

			self.parentOid = self.oidStack.top()
			
			parentUid = None
			if self.parentOid:
				if self.xmldb.uidName:
					src = 'select %s from %s where oid = %s;' % (self.xmldb.uidName,self.parentTag,self.parentOid)
				else:
					src = 'select id_%s from %s where oid = %s;' % (self.parentTag,self.parentTag,self.parentOid)
				query = self.xmldb.query(src)
				parentUid = query.getresult()[0][0]
				
			src = 'insert into %s (' % self.stack.top()
			
			commaFlag = 0
			for attr in attrs:
				if commaFlag:
					src = "%s, %s" % (src, attr)
				else:
					src = "%s%s" % (src, attr)
					commaFlag = 1

			if parentUid:
				if commaFlag:
					src = "%s, ref_%s" % (src, self.parentTag)
				else:
					src = "%sref_%s" % (src, self.parentTag)
				
			src = "%s) values (" % src

			commaFlag = 0
			for attr in attrs:
				if commaFlag:
					src = "%s, '%s'" % (src, attrs[attr])
				else:
					src = "%s'%s'" % (src, attrs[attr])
					commaFlag = 1

			if parentUid:
				if commaFlag:
					src = "%s, %s" % (src, parentUid)
				else:
					src = "%s%s" % (src, parentUid)

			src = "%s);" % src
			
			self.xmldb.stderr.write(src)
			self.xmldb.stderr.write("\n")
			
			try:
				oid = self.xmldb.query(src)
				self.oidStack.push(oid)
			except:
				try:
					if self.xmldb.uidName:
						oid = self.xmldb.query('insert into %s (%s) values (0);' % (self.stack.top(),self.xmldb.uidName))
					else:
						oid = self.xmldb.query('insert into %s (id_%s) values (0);' % (self.stack.top(),self.stack.top()))
				except:
					if self.xmldb.uidName:
						query = self.xmldb.query('select oid from %s where %s=0;' % (self.stack.top(),self.xmldb.uidName))
					else:
						query = self.xmldb.query('select oid from %s where id_%s=0;' % (self.stack.top(),self.stack.top()))
					oid = query.getresult()[0][0]
				self.oidStack.push(oid)
				
			
		def characters(self,data,start,length):
			if not strip(data[start:start+length]):
				return
			src = "update %s set PCDATA = '%s' where oid = %s;" % (self.stack.top(),data[start:start+length],self.oidStack.top())
			self.xmldb.stderr.write(src)
			self.xmldb.stderr.write("\n")
			self.xmldb.query(src)
			
		def endElement(self, name):
			CommonHandler.endElement(self, name)
			
			self.oidStack.pop()
			self.parentOid = self.oidStack.top()
				
	def __init__(self, DBNAME, DBHOST, DBPORT, DBUSER, DBPWD, log = LOG('XmlDb.log'), name = 'XmlDb', debug = None, uidName=None):
		DbHandler.__init__(self, DBNAME, DBUSER, DBPWD, DBHOST, DBPORT, log, name, debug)
		self.uidName = uidName
		
	def read(self, filename):
		pf=saxexts.ParserFactory()
		p=pf.make_parser('xml.sax.drivers.drv_xmlproc')
		p.setDocumentHandler(self.XmlHandler('doc_handler', self))
		p.setDTDHandler(self.XmlHandler('dtd_handler', self))
		p.setErrorHandler(self.XmlHandler('err_handler', self))
		p.setEntityResolver(self.XmlHandler('ent_handler', self))
		p.parse(filename)
