/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.ResultSet;
import org.postgresql.jdbc2.Connection;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    Connection connection;
    static final int iVarcharOid = 1043;
    static final int iBoolOid = 16;
    static final int iInt2Oid = 21;
    static final int iInt4Oid = 23;
    static final int VARHDRSZ = 4;
    private static final byte[] defaultRemarks = "no remarks".getBytes();
    private static final String[][] getTableTypes = new String[][]{{"TABLE", "(relkind='r' and relname !~ '^pg_' and relname !~ '^xinv')"}, {"INDEX", "(relkind='i' and relname !~ '^pg_' and relname !~ '^xinx')"}, {"LARGE OBJECT", "(relkind='r' and relname ~ '^xinv')"}, {"SEQUENCE", "(relkind='S' and relname !~ '^pg_')"}, {"SYSTEM TABLE", "(relkind='r' and relname ~ '^pg_')"}, {"SYSTEM INDEX", "(relkind='i' and relname ~ '^pg_')"}};
    private static final String[] defaultTableTypes = new String[]{"TABLE", "INDEX", "SEQUENCE"};

    public DatabaseMetaData(Connection conn) {
        this.connection = conn;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    public boolean deletesAreDetected(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        Field[] f = new Field[8];
        Vector v = new Vector();
        f[0] = new Field(this.connection, new String("SCOPE"), 21, 2);
        f[1] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        f[2] = new Field(this.connection, new String("DATA_TYPE"), 21, 2);
        f[3] = new Field(this.connection, new String("TYPE_NAME"), 1043, 32);
        f[4] = new Field(this.connection, new String("COLUMN_SIZE"), 23, 4);
        f[5] = new Field(this.connection, new String("BUFFER_LENGTH"), 23, 4);
        f[6] = new Field(this.connection, new String("DECIMAL_DIGITS"), 21, 2);
        f[7] = new Field(this.connection, new String("PSEUDO_COLUMN"), 21, 2);
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public String getCatalogSeparator() throws SQLException {
        return new String("");
    }

    public String getCatalogTerm() throws SQLException {
        return new String("Catalog");
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        Field[] f = new Field[1];
        Vector<byte[][]> v = new Vector<byte[][]>();
        byte[][] tuple = new byte[1][0];
        f[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        tuple[0] = "".getBytes();
        v.addElement(tuple);
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public Class getClass(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw Driver.notImplemented();
    }

    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Field[] f = new Field[8];
        Vector v = new Vector();
        if (table == null) {
            table = "%";
        }
        columnNamePattern = columnNamePattern == null ? "%" : columnNamePattern.toLowerCase();
        f[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        f[1] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        f[2] = new Field(this.connection, new String("TABLE_NAME"), 1043, 32);
        f[3] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        f[4] = new Field(this.connection, new String("GRANTOR"), 1043, 32);
        f[5] = new Field(this.connection, new String("GRANTEE"), 1043, 32);
        f[6] = new Field(this.connection, new String("PRIVILEGE"), 1043, 32);
        f[7] = new Field(this.connection, new String("IS_GRANTABLE"), 1043, 32);
        java.sql.ResultSet r = this.connection.ExecSQL("SELECT relname, relacl FROM pg_class, pg_user WHERE ( relkind = 'r' OR relkind = 'i') and relname !~ '^pg_' and relname !~ '^xin[vx][0-9]+' and usesysid = relowner and relname like '" + table.toLowerCase() + "' ORDER BY relname");
        while (r.next()) {
            byte[][] tuple = new byte[8][0];
            tuple[1] = "".getBytes();
            tuple[0] = tuple[1];
            DriverManager.println("relname=\"" + r.getString(1) + "\" relacl=\"" + r.getString(2) + "\"");
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Field[] f = new Field[18];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        f[1] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        f[2] = new Field(this.connection, new String("TABLE_NAME"), 1043, 32);
        f[3] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        f[4] = new Field(this.connection, new String("DATA_TYPE"), 21, 2);
        f[5] = new Field(this.connection, new String("TYPE_NAME"), 1043, 32);
        f[6] = new Field(this.connection, new String("COLUMN_SIZE"), 23, 4);
        f[7] = new Field(this.connection, new String("BUFFER_LENGTH"), 1043, 32);
        f[8] = new Field(this.connection, new String("DECIMAL_DIGITS"), 23, 4);
        f[9] = new Field(this.connection, new String("NUM_PREC_RADIX"), 23, 4);
        f[10] = new Field(this.connection, new String("NULLABLE"), 23, 4);
        f[11] = new Field(this.connection, new String("REMARKS"), 1043, 32);
        f[12] = new Field(this.connection, new String("COLUMN_DEF"), 1043, 32);
        f[13] = new Field(this.connection, new String("SQL_DATA_TYPE"), 23, 4);
        f[14] = new Field(this.connection, new String("SQL_DATETIME_SUB"), 23, 4);
        f[15] = new Field(this.connection, new String("CHAR_OCTET_LENGTH"), 1043, 32);
        f[16] = new Field(this.connection, new String("ORDINAL_POSITION"), 23, 4);
        f[17] = new Field(this.connection, new String("IS_NULLABLE"), 1043, 32);
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        java.sql.ResultSet r = this.connection.ExecSQL("select a.oid,c.relname,a.attname,a.atttypid,a.attnum,a.attnotnull,a.attlen,a.atttypmod from pg_class c, pg_attribute a where a.attrelid=c.oid and c.relname like '" + tableNamePattern.toLowerCase() + "' and a.attname like '" + columnNamePattern.toLowerCase() + "' and a.attnum>0 order by c.relname,a.attnum");
        while (r.next()) {
            int atttypmod;
            byte[][] tuple = new byte[18][0];
            java.sql.ResultSet dr = this.connection.ExecSQL("select description from pg_description where objoid=" + r.getInt(1));
            if (((ResultSet)((Object)dr)).getTupleCount() == 1) {
                dr.next();
                tuple[11] = dr.getBytes(1);
            } else {
                tuple[11] = defaultRemarks;
            }
            dr.close();
            tuple[0] = "".getBytes();
            tuple[1] = "".getBytes();
            tuple[2] = r.getBytes(2);
            tuple[3] = r.getBytes(3);
            dr = this.connection.ExecSQL("select typname from pg_type where oid = " + r.getString(4));
            dr.next();
            String typname = dr.getString(1);
            dr.close();
            tuple[4] = Integer.toString(Field.getSQLType(typname)).getBytes();
            tuple[5] = typname.getBytes();
            tuple[6] = typname.equals("bpchar") || typname.equals("varchar") ? Integer.toString((atttypmod = r.getInt(8)) != -1 ? atttypmod - 4 : 0).getBytes() : r.getBytes(7);
            tuple[7] = null;
            tuple[8] = "0".getBytes();
            tuple[9] = "10".getBytes();
            tuple[12] = null;
            tuple[13] = null;
            tuple[14] = null;
            tuple[15] = tuple[6];
            tuple[16] = r.getBytes(5);
            String nullFlag = r.getString(6);
            tuple[10] = Integer.toString(nullFlag.equals("f") ? 1 : 0).getBytes();
            tuple[17] = (nullFlag.equals("f") ? "YES" : "NO").getBytes();
            v.addElement(tuple);
        }
        r.close();
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public java.sql.ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return null;
    }

    public String getDatabaseProductName() throws SQLException {
        return new String("PostgreSQL");
    }

    public String getDatabaseProductVersion() throws SQLException {
        return "6.5.2";
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public int getDriverMajorVersion() {
        return this.connection.this_driver.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.connection.this_driver.getMinorVersion();
    }

    public String getDriverName() throws SQLException {
        return new String("PostgreSQL Native Driver");
    }

    public String getDriverVersion() throws SQLException {
        return new String(String.valueOf(Integer.toString(this.connection.this_driver.getMajorVersion())) + "." + Integer.toString(this.connection.this_driver.getMinorVersion()));
    }

    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    public String getExtraNameCharacters() throws SQLException {
        return new String("");
    }

    public String getIdentifierQuoteString() throws SQLException {
        return null;
    }

    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    public java.sql.ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        Field[] f = new Field[13];
        Vector v = new Vector();
        f[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        f[1] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        f[2] = new Field(this.connection, new String("TABLE_NAME"), 1043, 32);
        f[3] = new Field(this.connection, new String("NON_UNIQUE"), 16, 1);
        f[4] = new Field(this.connection, new String("INDEX_QUALIFIER"), 1043, 32);
        f[5] = new Field(this.connection, new String("INDEX_NAME"), 1043, 32);
        f[6] = new Field(this.connection, new String("TYPE"), 21, 2);
        f[7] = new Field(this.connection, new String("ORDINAL_POSITION"), 21, 2);
        f[8] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        f[9] = new Field(this.connection, new String("ASC_OR_DESC"), 1043, 32);
        f[10] = new Field(this.connection, new String("CARDINALITY"), 23, 4);
        f[11] = new Field(this.connection, new String("PAGES"), 23, 4);
        f[12] = new Field(this.connection, new String("FILTER_CONDITION"), 1043, 32);
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 8190;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.getMaxColumnsInTable();
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 32;
    }

    public int getMaxIndexLength() throws SQLException {
        return 8192;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 32;
    }

    public int getMaxRowSize() throws SQLException {
        return 8192;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxStatementLength() throws SQLException {
        return 8192;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 1024;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 32;
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.connection.createStatement().executeQuery("SELECT '' as TABLE_CAT,'' AS TABLE_SCHEM,bc.relname AS TABLE_NAME,a.attname AS COLUMN_NAME,a.attnum as KEY_SEQ,ic.relname as PK_NAME  FROM pg_class bc, pg_class ic, pg_index i, pg_attribute a WHERE bc.relkind = 'r'   and upper(bc.relname) = upper('" + table + "')" + "  and i.indrelid = bc.oid" + "  and i.indexrelid = ic.oid" + "  and ic.oid = a.attrelid" + "  and i.indisprimary='t' " + " ORDER BY table_name, pk_name, key_seq");
    }

    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        if (procedureNamePattern == null) {
            procedureNamePattern = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        Field[] f = new Field[13];
        Vector v = new Vector();
        f[0] = new Field(this.connection, new String("PROCEDURE_CAT"), 1043, 32);
        f[1] = new Field(this.connection, new String("PROCEDURE_SCHEM"), 1043, 32);
        f[2] = new Field(this.connection, new String("PROCEDURE_NAME"), 1043, 32);
        f[3] = new Field(this.connection, new String("COLUMN_NAME"), 1043, 32);
        f[4] = new Field(this.connection, new String("COLUMN_TYPE"), 21, 2);
        f[5] = new Field(this.connection, new String("DATA_TYPE"), 21, 2);
        f[6] = new Field(this.connection, new String("TYPE_NAME"), 1043, 32);
        f[7] = new Field(this.connection, new String("PRECISION"), 23, 4);
        f[8] = new Field(this.connection, new String("LENGTH"), 23, 4);
        f[9] = new Field(this.connection, new String("SCALE"), 21, 2);
        f[10] = new Field(this.connection, new String("RADIX"), 21, 2);
        f[11] = new Field(this.connection, new String("NULLABLE"), 21, 2);
        f[12] = new Field(this.connection, new String("REMARKS"), 1043, 32);
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public String getProcedureTerm() throws SQLException {
        return new String("Procedure");
    }

    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        Field[] f = new Field[8];
        Vector<byte[][]> v = new Vector<byte[][]>();
        byte[] remarks = defaultRemarks;
        f[0] = new Field(this.connection, "PROCEDURE_CAT", 1043, 32);
        f[1] = new Field(this.connection, "PROCEDURE_SCHEM", 1043, 32);
        f[2] = new Field(this.connection, "PROCEDURE_NAME", 1043, 32);
        f[5] = null;
        f[4] = null;
        f[3] = null;
        f[6] = new Field(this.connection, "REMARKS", 1043, 8192);
        f[7] = new Field(this.connection, "PROCEDURE_TYPE", 21, 2);
        if (procedureNamePattern == null) {
            procedureNamePattern = "%";
        }
        java.sql.ResultSet r = this.connection.ExecSQL("select proname, proretset from pg_proc where proname like '" + procedureNamePattern.toLowerCase() + "' order by proname");
        while (r.next()) {
            byte[][] tuple = new byte[8][0];
            tuple[0] = null;
            tuple[1] = null;
            tuple[2] = r.getBytes(1);
            tuple[5] = null;
            tuple[4] = null;
            tuple[3] = null;
            tuple[6] = remarks;
            tuple[7] = r.getBoolean(2) ? Integer.toString(2).getBytes() : Integer.toString(1).getBytes();
            v.addElement(tuple);
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public String getSQLKeywords() throws SQLException {
        return new String("abort,acl,add,aggregate,append,archive,arch_store,backward,binary,change,cluster,copy,database,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version");
    }

    public String getSchemaTerm() throws SQLException {
        return new String("Schema");
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] f = new Field[1];
        Vector<byte[][]> v = new Vector<byte[][]>();
        byte[][] tuple = new byte[1][0];
        f[0] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        tuple[0] = "".getBytes();
        v.addElement(tuple);
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public String getSearchStringEscape() throws SQLException {
        return new String("\\");
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        Field[] f = new Field[1];
        Vector<byte[][]> v = new Vector<byte[][]>();
        byte[][] tuple = new byte[1][0];
        f[0] = new Field(this.connection, new String("TABLE_TYPE"), 1043, 32);
        int i = 0;
        while (i < getTableTypes.length) {
            tuple[0] = getTableTypes[i][0].getBytes();
            v.addElement(tuple);
            ++i;
        }
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (types == null) {
            types = defaultTableTypes;
        }
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        Field[] f = new Field[5];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, new String("TABLE_CAT"), 1043, 32);
        f[1] = new Field(this.connection, new String("TABLE_SCHEM"), 1043, 32);
        f[2] = new Field(this.connection, new String("TABLE_NAME"), 1043, 32);
        f[3] = new Field(this.connection, new String("TABLE_TYPE"), 1043, 32);
        f[4] = new Field(this.connection, new String("REMARKS"), 1043, 32);
        StringBuffer sql = new StringBuffer("select relname,oid from pg_class where (");
        boolean notFirst = false;
        int i = 0;
        while (i < types.length) {
            if (notFirst) {
                sql.append(" or ");
            }
            int j = 0;
            while (j < getTableTypes.length) {
                if (getTableTypes[j][0].equals(types[i])) {
                    sql.append(getTableTypes[j][1]);
                    notFirst = true;
                }
                ++j;
            }
            ++i;
        }
        sql.append(") and relname like '");
        sql.append(tableNamePattern.toLowerCase());
        sql.append("'");
        java.sql.ResultSet r = this.connection.ExecSQL(sql.toString());
        while (r.next()) {
            byte[] remarks;
            byte[][] tuple = new byte[5][0];
            java.sql.ResultSet dr = this.connection.ExecSQL("select description from pg_description where objoid=" + r.getInt(2));
            if (((ResultSet)((Object)dr)).getTupleCount() == 1) {
                dr.next();
                remarks = dr.getBytes(1);
            } else {
                remarks = defaultRemarks;
            }
            dr.close();
            tuple[0] = null;
            tuple[1] = null;
            tuple[2] = r.getBytes(1);
            tuple[3] = null;
            tuple[4] = remarks;
            v.addElement(tuple);
        }
        r.close();
        return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
    }

    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        java.sql.ResultSet rs = this.connection.ExecSQL("select typname from pg_type");
        if (rs != null) {
            Field[] f = new Field[18];
            Vector<byte[][]> v = new Vector<byte[][]>();
            f[0] = new Field(this.connection, new String("TYPE_NAME"), 1043, 32);
            f[1] = new Field(this.connection, new String("DATA_TYPE"), 21, 2);
            f[2] = new Field(this.connection, new String("PRECISION"), 23, 4);
            f[3] = new Field(this.connection, new String("LITERAL_PREFIX"), 1043, 32);
            f[4] = new Field(this.connection, new String("LITERAL_SUFFIX"), 1043, 32);
            f[5] = new Field(this.connection, new String("CREATE_PARAMS"), 1043, 32);
            f[6] = new Field(this.connection, new String("NULLABLE"), 21, 2);
            f[7] = new Field(this.connection, new String("CASE_SENSITIVE"), 16, 1);
            f[8] = new Field(this.connection, new String("SEARCHABLE"), 21, 2);
            f[9] = new Field(this.connection, new String("UNSIGNED_ATTRIBUTE"), 16, 1);
            f[10] = new Field(this.connection, new String("FIXED_PREC_SCALE"), 16, 1);
            f[11] = new Field(this.connection, new String("AUTO_INCREMENT"), 16, 1);
            f[12] = new Field(this.connection, new String("LOCAL_TYPE_NAME"), 1043, 32);
            f[13] = new Field(this.connection, new String("MINIMUM_SCALE"), 21, 2);
            f[14] = new Field(this.connection, new String("MAXIMUM_SCALE"), 21, 2);
            f[15] = new Field(this.connection, new String("SQL_DATA_TYPE"), 23, 4);
            f[16] = new Field(this.connection, new String("SQL_DATETIME_SUB"), 23, 4);
            f[17] = new Field(this.connection, new String("NUM_PREC_RADIX"), 23, 4);
            byte[] b9 = "9".getBytes();
            byte[] b10 = "10".getBytes();
            byte[] bf = "f".getBytes();
            byte[] bnn = Integer.toString(0).getBytes();
            byte[] bts = Integer.toString(3).getBytes();
            while (rs.next()) {
                byte[][] tuple = new byte[18][];
                String typname = rs.getString(1);
                tuple[0] = typname.getBytes();
                tuple[1] = Integer.toString(Field.getSQLType(typname)).getBytes();
                tuple[2] = b9;
                tuple[6] = bnn;
                tuple[7] = bf;
                tuple[8] = bts;
                tuple[9] = bf;
                tuple[10] = bf;
                tuple[11] = bf;
                tuple[17] = b10;
                v.addElement(tuple);
            }
            rs.close();
            return new org.postgresql.jdbc2.ResultSet(this.connection, f, v, "OK", 1);
        }
        return null;
    }

    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw Driver.notImplemented();
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowChangesAreDetected(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowChangesAreVisible(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8 || level == 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }
}

