/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.postgresql.Driver;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.fastpath.FastpathArg;

public class LargeObject {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private Fastpath fp;
    private int oid;
    private int fd;

    protected LargeObject(Fastpath fp, int oid, int mode) throws SQLException {
        this.fp = fp;
        this.oid = oid;
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(oid), new FastpathArg(mode)};
        this.fd = fp.getInteger("lo_open", args);
    }

    public void close() throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd)};
        this.fp.fastpath("lo_close", false, args);
    }

    public InputStream getInputStream() throws SQLException {
        throw Driver.notImplemented();
    }

    public int getOID() {
        return this.oid;
    }

    public OutputStream getOutputStream() throws SQLException {
        throw Driver.notImplemented();
    }

    public byte[] read(int len) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(len)};
        return this.fp.getData("loread", args);
    }

    public void read(byte[] buf, int off, int len) throws SQLException {
        System.arraycopy(this.read(len), 0, buf, off, len);
    }

    public void seek(int pos) throws SQLException {
        this.seek(pos, 0);
    }

    public void seek(int pos, int ref) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(pos), new FastpathArg(ref)};
        this.fp.fastpath("lo_lseek", false, args);
    }

    public int size() throws SQLException {
        int cp = this.tell();
        this.seek(0, 2);
        int sz = this.tell();
        this.seek(cp, 0);
        return sz;
    }

    public int tell() throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fp.getInteger("lo_tell", args);
    }

    public void write(byte[] buf) throws SQLException {
        FastpathArg[] args = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(buf)};
        this.fp.fastpath("lowrite", false, args);
    }

    public void write(byte[] buf, int off, int len) throws SQLException {
        byte[] data = new byte[len];
        System.arraycopy(buf, off, data, 0, len);
        this.write(data);
    }
}

