/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Random;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Javac
extends MatchingTask {
    private static final int MODERN_COMPILER_SUCCESS = 0;
    private static final String FAIL_MSG = "Compile failed, messages should have been provided.";
    private static String lSep = System.getProperty("line.separator");
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private String encoding;
    private boolean debug = false;
    private boolean optimize = false;
    private boolean deprecation = false;
    private boolean depend = false;
    private boolean verbose = false;
    private String target;
    private Path bootclasspath;
    private Path extdirs;
    protected File[] compileList = new File[0];
    private static /* synthetic */ Class class$Ljava$io$OutputStream;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class array$Ljava$lang$String;

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.project);
        }
        return this.src.createPath();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setBootclasspath(Path bootclasspath) {
        if (this.bootclasspath == null) {
            this.bootclasspath = bootclasspath;
        } else {
            this.bootclasspath.append(bootclasspath);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.project);
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference r) {
        this.createBootclasspath().setRefid(r);
    }

    public void setExtdirs(Path extdirs) {
        if (this.extdirs == null) {
            this.extdirs = extdirs;
        } else {
            this.extdirs.append(extdirs);
        }
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.project);
        }
        return this.extdirs.createPath();
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setDepend(boolean depend) {
        this.depend = depend;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void execute() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.location);
        }
        String[] list = this.src.list();
        if (list.length == 0) {
            throw new BuildException("srcdir attribute must be set!", this.location);
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.location);
        }
        this.resetFileLists();
        int i = 0;
        while (i < list.length) {
            File srcDir = this.project.resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.location);
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
            ++i;
        }
        String compiler = this.project.getProperty("build.compiler");
        if (compiler == null) {
            compiler = Project.getJavaVersion().startsWith("1.3") ? "modern" : "classic";
        }
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            if (compiler.equalsIgnoreCase("classic")) {
                this.doClassicCompile();
            } else if (compiler.equalsIgnoreCase("modern")) {
                this.doModernCompile();
            } else if (compiler.equalsIgnoreCase("jikes")) {
                this.doJikesCompile();
            } else if (compiler.equalsIgnoreCase("jvc")) {
                this.doJvcCompile();
            } else {
                String msg = "Don't know how to use compiler " + compiler;
                throw new BuildException(msg, this.location);
            }
        }
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.java");
        m.setTo("*.class");
        SourceFileScanner sfs = new SourceFileScanner(this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, m);
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    protected Path getCompileClasspath(boolean addRuntime) {
        Path classpath = new Path(this.project);
        if (this.destDir != null) {
            classpath.setLocation(this.destDir);
        }
        if (this.compileClasspath == null) {
            classpath.addExisting(Path.systemClasspath);
        } else {
            String order = this.project.getProperty("build.sysclasspath");
            if (order == null) {
                order = "first";
            }
            if (order.equals("only")) {
                classpath.addExisting(Path.systemClasspath);
            } else if (order.equals("last")) {
                classpath.addExisting(this.compileClasspath);
                classpath.addExisting(Path.systemClasspath);
            } else if (order.equals("ignore")) {
                classpath.addExisting(this.compileClasspath);
                addRuntime = true;
            } else {
                classpath.addExisting(Path.systemClasspath);
                classpath.addExisting(this.compileClasspath);
            }
        }
        if (addRuntime) {
            if (System.getProperty("java.vendor").toLowerCase().indexOf("microsoft") >= 0) {
                FileSet msZipFiles = new FileSet();
                msZipFiles.setDir(new File(System.getProperty("java.home") + File.separator + "Packages"));
                msZipFiles.setIncludes("*.ZIP");
                classpath.addFileset(msZipFiles);
            } else if (Project.getJavaVersion() == "1.1") {
                classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "classes.zip"));
            } else {
                classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
                classpath.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
            }
        }
        return classpath;
    }

    private void doClassicCompile() throws BuildException {
        this.log("Using classic compiler", 3);
        Commandline cmd = this.setupJavacCommand();
        try {
            LogOutputStream logstr = new LogOutputStream(this, 1);
            Class<?> c = Class.forName("sun.tools.javac.Main");
            Constructor<?> cons = c.getConstructor(class$Ljava$io$OutputStream != null ? class$Ljava$io$OutputStream : (class$Ljava$io$OutputStream = Javac.class$("java.io.OutputStream")), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Javac.class$("java.lang.String")));
            Object compiler = cons.newInstance(logstr, "javac");
            Method compile = c.getMethod("compile", array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = Javac.class$("[Ljava.lang.String;")));
            Boolean ok = (Boolean)compile.invoke(compiler, new Object[]{cmd.getArguments()});
            if (!ok.booleanValue()) {
                throw new BuildException(FAIL_MSG, this.location);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new BuildException("Cannot use classic compiler, as it is not available A common solution is to set the environment variable JAVA_HOME to your jdk directory.", this.location);
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Error starting classic compiler: ", ex, this.location);
        }
    }

    private void doModernCompile() throws BuildException {
        try {
            Class.forName("com.sun.tools.javac.Main");
        }
        catch (ClassNotFoundException cnfe) {
            this.log("Modern compiler is not available - using classic compiler", 1);
            this.doClassicCompile();
            return;
        }
        this.log("Using modern compiler", 3);
        Commandline cmd = this.setupJavacCommand();
        PrintStream err = System.err;
        PrintStream out = System.out;
        try {
            try {
                PrintStream logstr = new PrintStream(new LogOutputStream(this, 1));
                System.setOut(logstr);
                System.setErr(logstr);
                Class<?> c = Class.forName("com.sun.tools.javac.Main");
                Object compiler = c.newInstance();
                Method compile = c.getMethod("compile", new String[0].getClass());
                int result = (Integer)compile.invoke(compiler, new Object[]{cmd.getArguments()});
                if (result != 0) {
                    throw new BuildException(FAIL_MSG, this.location);
                }
                Object var5_11 = null;
            }
            catch (Exception ex) {
                if (ex instanceof BuildException) {
                    throw (BuildException)ex;
                }
                throw new BuildException("Error starting modern compiler", ex, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            System.setErr(err);
            System.setOut(out);
            throw throwable;
        }
        System.setErr(err);
        System.setOut(out);
    }

    private Commandline setupJavacCommand() {
        Commandline cmd = new Commandline();
        Path classpath = this.getCompileClasspath(false);
        if (this.deprecation) {
            cmd.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir);
        }
        cmd.createArgument().setValue("-classpath");
        if (Project.getJavaVersion().startsWith("1.1")) {
            cmd.createArgument().setValue(classpath.toString() + File.pathSeparator + this.src.toString());
        } else {
            cmd.createArgument().setPath(classpath);
            cmd.createArgument().setValue("-sourcepath");
            cmd.createArgument().setPath(this.src);
            if (this.target != null) {
                cmd.createArgument().setValue("-target");
                cmd.createArgument().setValue(this.target);
            }
        }
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            cmd.createArgument().setValue("-g");
        }
        if (this.optimize) {
            cmd.createArgument().setValue("-O");
        }
        if (this.bootclasspath != null) {
            cmd.createArgument().setValue("-bootclasspath");
            cmd.createArgument().setPath(this.bootclasspath);
        }
        if (this.extdirs != null) {
            cmd.createArgument().setValue("-extdirs");
            cmd.createArgument().setPath(this.extdirs);
        }
        if (this.depend) {
            if (Project.getJavaVersion().startsWith("1.1")) {
                cmd.createArgument().setValue("-depend");
            } else if (Project.getJavaVersion().startsWith("1.2")) {
                cmd.createArgument().setValue("-Xdepend");
            } else {
                this.log("depend attribute is not supported by the modern compiler", 1);
            }
        }
        if (this.verbose) {
            cmd.createArgument().setValue("-verbose");
        }
        this.logAndAddFilesToCompile(cmd);
        return cmd;
    }

    protected void logAndAddFilesToCompile(Commandline cmd) {
        this.log("Compilation args: " + cmd.toString(), 3);
        StringBuffer niceSourceList = new StringBuffer("File");
        if (this.compileList.length != 1) {
            niceSourceList.append("s");
        }
        niceSourceList.append(" to be compiled:");
        niceSourceList.append(lSep);
        int i = 0;
        while (i < this.compileList.length) {
            String arg = this.compileList[i].getAbsolutePath();
            cmd.createArgument().setValue(arg);
            niceSourceList.append("    " + arg + lSep);
            ++i;
        }
        this.log(niceSourceList.toString(), 3);
    }

    private void doJikesCompile() throws BuildException {
        String fullDependProperty;
        String pedanticProperty;
        String warningsProperty;
        String emacsProperty;
        this.log("Using jikes compiler", 3);
        Path classpath = new Path(this.project);
        if (this.bootclasspath != null) {
            classpath.append(this.bootclasspath);
        }
        this.addExtdirsToClasspath(classpath);
        classpath.append(this.getCompileClasspath(true));
        classpath.append(this.src);
        String jikesPath = System.getProperty("jikes.class.path");
        if (jikesPath != null) {
            classpath.append(new Path(this.project, jikesPath));
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable("jikes");
        if (this.deprecation) {
            cmd.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir);
        }
        cmd.createArgument().setValue("-classpath");
        cmd.createArgument().setPath(classpath);
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            cmd.createArgument().setValue("-g");
        }
        if (this.optimize) {
            cmd.createArgument().setValue("-O");
        }
        if (this.verbose) {
            cmd.createArgument().setValue("-verbose");
        }
        if (this.depend) {
            cmd.createArgument().setValue("-depend");
        }
        if ((emacsProperty = this.project.getProperty("build.compiler.emacs")) != null && Project.toBoolean(emacsProperty)) {
            cmd.createArgument().setValue("+E");
        }
        if ((warningsProperty = this.project.getProperty("build.compiler.warnings")) != null && !Project.toBoolean(warningsProperty)) {
            cmd.createArgument().setValue("-nowarn");
        }
        if ((pedanticProperty = this.project.getProperty("build.compiler.pedantic")) != null && Project.toBoolean(pedanticProperty)) {
            cmd.createArgument().setValue("+P");
        }
        if ((fullDependProperty = this.project.getProperty("build.compiler.fulldepend")) != null && Project.toBoolean(fullDependProperty)) {
            cmd.createArgument().setValue("+F");
        }
        int firstFileName = cmd.size();
        this.logAndAddFilesToCompile(cmd);
        if (this.executeJikesCompile(cmd.getCommandline(), firstFileName) != 0) {
            throw new BuildException(FAIL_MSG, this.location);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeJikesCompile(String[] args, int firstFileName) {
        String[] commandArray = null;
        File tmpFile = null;
        try {
            block16: {
                if (Commandline.toString(args).length() > 4096) {
                    PrintWriter out = null;
                    try {
                        try {
                            tmpFile = new File("jikes" + new Random(System.currentTimeMillis()).nextLong());
                            out = new PrintWriter(new FileWriter(tmpFile));
                            int i = firstFileName;
                            while (true) {
                                if (i >= args.length) {
                                    out.flush();
                                    commandArray = new String[firstFileName + 1];
                                    System.arraycopy(args, 0, commandArray, 0, firstFileName);
                                    commandArray[firstFileName] = "@" + tmpFile.getAbsolutePath();
                                    break;
                                }
                                out.println(args[i]);
                                ++i;
                            }
                        }
                        catch (IOException e) {
                            throw new BuildException("Error creating temporary file", e, this.location);
                        }
                        Object var10_11 = null;
                        if (out == null) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        if (out == null) throw throwable;
                        try {
                            out.close();
                            throw throwable;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (Throwable t) {}
                    out.close();
                } else {
                    commandArray = args;
                }
            }
            try {
                Execute exe = new Execute(new LogStreamHandler(this, 2, 1));
                exe.setAntRun(this.project);
                exe.setWorkingDirectory(this.project.getBaseDir());
                exe.setCommandline(commandArray);
                exe.execute();
                int n = exe.getExitValue();
                Object var6_15 = null;
                if (tmpFile == null) return n;
                tmpFile.delete();
                return n;
            }
            catch (IOException e) {
                throw new BuildException("Error running Jikes compiler", e, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            if (tmpFile == null) throw throwable;
            tmpFile.delete();
            throw throwable;
        }
    }

    protected void addExtdirsToClasspath(Path classpath) {
        if (this.extdirs == null) {
            String extProp = System.getProperty("java.ext.dirs");
            if (extProp != null) {
                this.extdirs = new Path(this.project, extProp);
            } else {
                return;
            }
        }
        String[] dirs = this.extdirs.list();
        int i = 0;
        while (i < dirs.length) {
            if (!dirs[i].endsWith(File.separator)) {
                int n = i;
                dirs[n] = dirs[n] + File.separator;
            }
            File dir = this.project.resolveFile(dirs[i]);
            FileSet fs = new FileSet();
            fs.setDir(dir);
            fs.setIncludes("*");
            classpath.addFileset(fs);
            ++i;
        }
    }

    private void doJvcCompile() throws BuildException {
        this.log("Using jvc compiler", 3);
        Path classpath = new Path(this.project);
        if (this.bootclasspath != null) {
            classpath.append(this.bootclasspath);
        }
        this.addExtdirsToClasspath(classpath);
        classpath.append(this.getCompileClasspath(true));
        classpath.append(this.src);
        Commandline cmd = new Commandline();
        cmd.setExecutable("jvc");
        if (this.destDir != null) {
            cmd.createArgument().setValue("/d");
            cmd.createArgument().setFile(this.destDir);
        }
        cmd.createArgument().setValue("/cp:p");
        cmd.createArgument().setPath(classpath);
        cmd.createArgument().setValue("/x-");
        cmd.createArgument().setValue("/nomessage");
        cmd.createArgument().setValue("/nologo");
        if (this.debug) {
            cmd.createArgument().setValue("/g");
        }
        if (this.optimize) {
            cmd.createArgument().setValue("/O");
        }
        int firstFileName = cmd.size();
        this.logAndAddFilesToCompile(cmd);
        if (this.executeJikesCompile(cmd.getCommandline(), firstFileName) != 0) {
            throw new BuildException(FAIL_MSG, this.location);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

