/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class FormatterElement {
    private String classname;
    private String extension;
    private OutputStream out = System.out;
    private File outFile;
    private boolean useFile = true;

    public void setType(TypeAttribute type) {
        if ("xml".equals(type.getValue())) {
            this.setClassname("org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter");
            this.setExtension(".xml");
        } else {
            this.setClassname("org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter");
            this.setExtension(".txt");
        }
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setExtension(String ext) {
        this.extension = ext;
    }

    public String getExtension() {
        return this.extension;
    }

    void setOutfile(File out) {
        this.outFile = out;
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    boolean getUseFile() {
        return this.useFile;
    }

    JUnitResultFormatter createFormatter() throws BuildException {
        if (this.classname == null) {
            throw new BuildException("you must specify type or classname");
        }
        Class<?> f = null;
        try {
            f = Class.forName(this.classname);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        Object o = null;
        try {
            o = f.newInstance();
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        if (!(o instanceof JUnitResultFormatter)) {
            throw new BuildException(this.classname + " is not a JUnitResultFormatter");
        }
        JUnitResultFormatter r = o;
        if (this.useFile && this.outFile != null) {
            try {
                this.out = new FileOutputStream(this.outFile);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        r.setOutput(this.out);
        return r;
    }

    public static class TypeAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"plain", "xml"};
        }
    }
}

