/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class JUnitTask
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;

    public void setHaltonerror(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setHaltonerror(value);
        }
    }

    public void setHaltonfailure(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setHaltonfailure(value);
        }
    }

    public void setPrintsummary(boolean value) {
        this.summary = value;
    }

    public void setMaxmemory(String max) {
        if (Project.getJavaVersion().startsWith("1.1")) {
            this.createJvmarg().setValue("-mx" + max);
        } else {
            this.createJvmarg().setValue("-Xmx" + max);
        }
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public void setFork(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setFork(value);
        }
    }

    public void setJvm(String value) {
        this.commandline.setVm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.project).createPath();
    }

    public void addTest(JUnitTest test) {
        this.tests.addElement(test);
    }

    public BatchTest createBatchTest() {
        BatchTest test = new BatchTest(this.project);
        this.batchTests.addElement(test);
        return test;
    }

    public void addFormatter(FormatterElement fe) {
        this.formatters.addElement(fe);
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void execute() throws BuildException {
        BaseTest test;
        boolean errorOccurred = false;
        boolean failureOccurred = false;
        Vector runTests = (Vector)this.tests.clone();
        Enumeration list = this.batchTests.elements();
        while (list.hasMoreElements()) {
            test = (BatchTest)list.nextElement();
            Enumeration list2 = ((BatchTest)test).elements();
            while (list2.hasMoreElements()) {
                runTests.addElement(list2.nextElement());
            }
        }
        list = runTests.elements();
        while (list.hasMoreElements()) {
            boolean failureOccurredHere;
            FormatterElement[] add;
            test = (JUnitTest)list.nextElement();
            if (!((JUnitTest)test).shouldRun(this.project)) continue;
            if (test.getTodir() == null) {
                test.setTodir(this.project.resolveFile("."));
            }
            if (((JUnitTest)test).getOutfile() == null) {
                ((JUnitTest)test).setOutfile("TEST-" + ((JUnitTest)test).getName());
            }
            int exitValue = 2;
            if (!test.getFork()) {
                if (this.dir != null) {
                    this.log("dir attribute ignored if running in the same VM", 1);
                }
                JUnitTestRunner runner = null;
                Path classpath = this.commandline.getClasspath();
                if (classpath != null) {
                    this.log("Using CLASSPATH " + classpath, 3);
                    AntClassLoader l = new AntClassLoader(this.project, classpath, false);
                    l.addSystemPackageRoot("junit");
                    l.addSystemPackageRoot("org.apache.tools.ant");
                    runner = new JUnitTestRunner((JUnitTest)test, test.getHaltonerror(), test.getHaltonfailure(), (ClassLoader)l);
                } else {
                    runner = new JUnitTestRunner((JUnitTest)test, test.getHaltonerror(), test.getHaltonfailure());
                }
                if (this.summary) {
                    this.log("Running " + ((JUnitTest)test).getName(), 2);
                    SummaryJUnitResultFormatter f = new SummaryJUnitResultFormatter();
                    f.setOutput((OutputStream)new LogOutputStream((Task)this, 2));
                    runner.addFormatter(f);
                }
                int i = 0;
                while (i < this.formatters.size()) {
                    FormatterElement fe = (FormatterElement)this.formatters.elementAt(i);
                    this.setOutput(fe, (JUnitTest)test);
                    runner.addFormatter(fe.createFormatter());
                    ++i;
                }
                add = ((JUnitTest)test).getFormatters();
                int i2 = 0;
                while (i2 < add.length) {
                    this.setOutput(add[i2], (JUnitTest)test);
                    runner.addFormatter(add[i2].createFormatter());
                    ++i2;
                }
                runner.run();
                exitValue = runner.getRetCode();
            } else {
                String filename;
                File destFile;
                CommandlineJava cmd = (CommandlineJava)this.commandline.clone();
                cmd.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
                cmd.createArgument().setValue(((JUnitTest)test).getName());
                cmd.createArgument().setValue("haltOnError=" + test.getHaltonerror());
                cmd.createArgument().setValue("haltOnFailure=" + test.getHaltonfailure());
                if (this.summary) {
                    this.log("Running " + ((JUnitTest)test).getName(), 2);
                    cmd.createArgument().setValue("formatter=org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter");
                }
                StringBuffer formatterArg = new StringBuffer();
                int i = 0;
                while (i < this.formatters.size()) {
                    FormatterElement fe = (FormatterElement)this.formatters.elementAt(i);
                    formatterArg.append("formatter=");
                    formatterArg.append(fe.getClassname());
                    if (fe.getUseFile()) {
                        formatterArg.append(",");
                        destFile = new File(test.getTodir(), ((JUnitTest)test).getOutfile() + fe.getExtension());
                        filename = destFile.getAbsolutePath();
                        formatterArg.append(this.project.resolveFile(filename));
                    }
                    cmd.createArgument().setValue(formatterArg.toString());
                    formatterArg.setLength(0);
                    ++i;
                }
                add = ((JUnitTest)test).getFormatters();
                int i3 = 0;
                while (i3 < add.length) {
                    formatterArg.append("formatter=");
                    formatterArg.append(add[i3].getClassname());
                    if (add[i3].getUseFile()) {
                        formatterArg.append(",");
                        destFile = new File(test.getTodir(), ((JUnitTest)test).getOutfile() + add[i3].getExtension());
                        filename = destFile.getAbsolutePath();
                        formatterArg.append(this.project.resolveFile(filename));
                    }
                    cmd.createArgument().setValue(formatterArg.toString());
                    formatterArg.setLength(0);
                    ++i3;
                }
                Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), this.createWatchdog());
                execute.setCommandline(cmd.getCommandline());
                if (this.dir != null) {
                    execute.setWorkingDirectory(this.dir);
                    execute.setAntRun(this.project);
                }
                this.log("Executing: " + cmd.toString(), 3);
                try {
                    exitValue = execute.execute();
                }
                catch (IOException e) {
                    throw new BuildException("Process fork failed.", (Throwable)e, this.location);
                }
            }
            boolean errorOccurredHere = exitValue == 2;
            boolean bl = failureOccurredHere = exitValue != 0;
            if (errorOccurredHere && test.getHaltonerror() || failureOccurredHere && test.getHaltonfailure()) {
                throw new BuildException("Test " + ((JUnitTest)test).getName() + " failed", this.location);
            }
            if (!errorOccurredHere && !failureOccurredHere) continue;
            this.log("TEST " + ((JUnitTest)test).getName() + " FAILED", 0);
        }
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout.intValue());
    }

    private void rename(String source, String destination) throws BuildException {
        File src = new File(source);
        File dest = new File(destination);
        if (dest.exists()) {
            dest.delete();
        }
        src.renameTo(dest);
    }

    protected Enumeration allTests() {
        JUnitTask jUnitTask = this;
        if (jUnitTask == null) {
            throw null;
        }
        return new Enumeration(jUnitTask){
            private Enumeration testEnum;
            private Enumeration batchEnum;
            private final /* synthetic */ JUnitTask this$0;

            public boolean hasMoreElements() {
                return this.testEnum.hasMoreElements() || this.batchEnum.hasMoreElements();
            }

            public Object nextElement() {
                if (this.testEnum.hasMoreElements()) {
                    return this.testEnum.nextElement();
                }
                return this.batchEnum.nextElement();
            }
            {
                this.this$0 = this$0;
                this.testEnum = JUnitTask.access$0(this.this$0).elements();
                this.batchEnum = JUnitTask.access$1(this.this$0).elements();
                this.constructor$0(this$0);
            }

            private final void constructor$0(JUnitTask jUnitTask) {
            }
        };
    }

    protected void setOutput(FormatterElement fe, JUnitTest test) {
        if (fe.getUseFile()) {
            File destFile = new File(test.getTodir(), test.getOutfile() + fe.getExtension());
            String filename = destFile.getAbsolutePath();
            fe.setOutfile(this.project.resolveFile(filename));
        } else {
            fe.setOutput((OutputStream)new LogOutputStream((Task)this, 2));
        }
    }

    static /* synthetic */ Vector access$0(JUnitTask jUnitTask) {
        return jUnitTask.tests;
    }

    static /* synthetic */ Vector access$1(JUnitTask jUnitTask) {
        return jUnitTask.batchTests;
    }

    public JUnitTask() throws Exception {
        this.commandline.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
    }
}

