/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/


void sql::getDatabaseName(QString dbName)
{
    db=QSqlDatabase::database(dbName);   
}


void sql::wykonajSlot() 
{
 
    for (int i=0;i<skrypty->numRows();i++)    
    {
	if (skrypty->isRowSelected(i) &&((QCheckTableItem *)(skrypty->item(i,2)))->isChecked())
	{
	    if (!(skrypty->text(i,4).stripWhiteSpace().lower().left(6)=="select"))
	    {
		if (((QCheckTableItem *)(skrypty->item(i,3)))->isChecked())
		{
		    sqlLog->append("---------------------------------------------------------------------");
		    sqlLog->append(skrypty->text(i,4));
	  	    sqlView *b  =new sqlView;
		    b->getDatabaseName(db->databaseName());
		    b->setPgTableName(skrypty->text(i,4));
		    b->wypelnij();
		    b->setCaption("zawartosc->"+skrypty->text(i,4)+"->"+caption());
		    b->show();
		}
		else
		{
		    QStringList polecenia=parsujPolecenie(skrypty->text(i,4));
		    for ( QStringList::Iterator it = polecenia.begin(); it != polecenia.end(); ++it ) 
		    {
			sqlLog->append("---------------------------------------------------------------------");
			sqlLog->append(*it);
	  
			QSqlQuery Baza(*it,db);
			if (!Baza.isActive())
			{
			    QMessageBox::warning(0, "okno",Baza.lastError().databaseText());
			    sqlLog->append("---------------------------------------------------------------------");
			    sqlLog->append(Baza.lastError().databaseText());
			}
		    }
		}
	    }
	    else
	    {
		if (((QCheckTableItem *)(skrypty->item(i,3)))->isChecked())
		{
		    sqlLog->append("---------------------------------------------------------------------");
		    sqlLog->append(skrypty->text(i,4));
		    sqlSelect *b  =new sqlSelect;
		    b->getDatabaseName(db->databaseName());
		    b->setSqlSelect(skrypty->text(i,4));
		    b->wypelnij();
		    b->setCaption("zawartosc->"+skrypty->text(i,4)+"->"+caption());
		    b->show();
		}
	    }
	}
    }
} 





void sql::wczytajSlot()
{
   QFileDialog* fd = new QFileDialog( this, "file dialog", TRUE );
   while (skrypty->numRows())
	skrypty->removeRow(0);
    
   sqlEdit->clear();
   lista->clear();
   
    fd->setMode( QFileDialog::ExistingFile);
    fd->setFilter( "XML (*.xml)");
    fd->setDir(QDir::homeDirPath()+"/.pgagp/"+db->hostName()+"/"+db->databaseName());
     if ( fd->exec() == QDialog::Accepted )
    {  
	fileName = fd->selectedFile();
	QFile opmlFile( fileName );
	if (!opmlFile.open(IO_ReadOnly))
	{
	       QMessageBox::critical( 0,
				   tr( "Critical Error" ),
				   tr( "Bd otwarcia pliku %1" ).arg( fileName ) );
	 return;
	}
	domTree.clear();
	if ( !domTree.setContent( &opmlFile) ) 
	{
	    QMessageBox::critical( 0,
				   tr( "Critical Error" ),
				   tr( "Parsing error for file %1" ).arg( fileName ) );
	    opmlFile.close();
	    return;
	}
	rootElement = domTree.documentElement();
	QDomNode node = rootElement.firstChild();
	while ( !node.isNull() )
	{
	    if ( node.isElement() && node.nodeName() == "skrypt" )
	    {
		new QListViewItem( lista,node.toElement().attribute( "nazwa" ) );
	    }
	    node = node.nextSibling();
	}    
	opmlFile.flush();
	opmlFile.close();   
}
  
 
}


void sql::dodajSkrypt_clicked()
{
    int i;
    QListViewItem *TMPViewItem;
    nazwa_skryptu *b  =new nazwa_skryptu(this);
    i=b->exec();
    if (i==QDialog::Accepted)
    {
	if (b->getNazwa().stripWhiteSpace()!="")
	    TMPViewItem = new QListViewItem( lista, b->getNazwa().stripWhiteSpace());
	else
	    TMPViewItem = new QListViewItem( lista, "nowe skrypty");
	lista->setSelected(TMPViewItem,TRUE);
	rootElement =domTree.documentElement();
	dodajSkrypt(TMPViewItem->text(0));
        }   
    delete b;
}


void sql::edytujSkrypt_clicked()
{
    int i;
    QListViewItem *TMPViewItem;
    TMPViewItem=lista->selectedItem();
    if(TMPViewItem)
    {
	nazwa_skryptu *b  =new nazwa_skryptu(this);
	b->setNazwa(TMPViewItem->text(0));	
	i=b->exec();
	if (i==QDialog::Accepted)
	{
	    if (b->getNazwa().stripWhiteSpace()!="")
	    {
		biezNode.toElement().setAttribute("nazwa",b->getNazwa().stripWhiteSpace());
		TMPViewItem->setText(0,b->getNazwa().stripWhiteSpace());

	    }
	}   
	delete b;    
	
    }
}




void sql::init()
{

    skrypty->setColumnWidth(0,30);
    skrypty->setColumnWidth(1,50);
    skrypty->setColumnWidth(2,30);
    skrypty->setColumnWidth(3,30);
    skrypty->setColumnWidth(4,100);
    skrypty->setColumnReadOnly(4,true);
    skrypty->setColumnStretchable(4,true);
    //skrypty->setColumnStretchable(1,true);
    skrypty->adjustColumn(1);
    skrypty->adjustColumn(4);
}


void sql::sqlEdit_textChanged()
{
    
    skrypty->setText(skrypty->currentRow(),4,sqlEdit->text());
}



void sql::skrypty_selectionChanged()
{    
    sqlEdit->setText( skrypty->text(skrypty->currentRow(),4));
}


void sql::zapisz_clicked()
{
    QFile opmlFile( fileName );
    opmlFile.open( IO_WriteOnly );    
    QTextStream st(&opmlFile);
    usunPolecenia(&biezNode);
    dodajPolecenia(&biezNode);
    
    
    st<<domTree;
    opmlFile.flush();
    opmlFile.close();    
    
}


void sql::zapiszJako_clicked()
{
    
    QFileDialog* fd = new QFileDialog( this, "file dialog", TRUE );
    fd->setMode( QFileDialog::AnyFile);
    fd->setFilter( "XML (*.xml)");
    fd->setDir(QDir::homeDirPath()+"/.pgagp/"+db->hostName()+"/"+db->databaseName());
    if ( fd->exec() == QDialog::Accepted )
    {  
	fileName = fd->selectedFile();
   }   
    else
	return;
    QFile opmlFile( fileName );
    opmlFile.open( IO_WriteOnly );    
     QTextStream st(&opmlFile);
/*     if (!domTree.hasChildNodes())     
     {
	 QDomDocument tmp(db->databaseName());
	 QDomElement tmp1=tmp.createElement("skrypty");
	 tmp.appendChild(tmp1);
	 domTree=tmp;
     }*/
      
    st<<domTree;
    opmlFile.flush();
    opmlFile.close();    

}






void sql::dodajSkrypt(QString nazwa_skryptu)
{
    QDomElement skrypt = domTree.createElement( "skrypt" );
    skrypt.setAttribute("nazwa",nazwa_skryptu);
    rootElement.appendChild( skrypt);
    biezNode=skrypt;
}









void sql::nowy_clicked()
{
    QFileDialog* fd = new QFileDialog( this, "file dialog", TRUE );
    fd->setMode( QFileDialog::AnyFile);
    fd->setFilter( "XML (*.xml)");
    fd->setDir(QDir::homeDirPath()+"/.pgagp/"+db->hostName()+"/"+db->databaseName());
    if ( fd->exec() == QDialog::Accepted )
    {  
	fileName = fd->selectedFile();
   }   
    else
	return;
    QFile opmlFile( fileName );
    opmlFile.open( IO_WriteOnly );    
    QTextStream st(&opmlFile);
    QDomDocument tmp(db->databaseName());
    QDomElement tmp1=tmp.createElement("skrypty");
    tmp.appendChild(tmp1);
   
    st<<tmp;
    opmlFile.flush();
    opmlFile.close();    
    
    opmlFile.setName( fileName );
    if (!opmlFile.open(IO_ReadOnly))
    {
	QMessageBox::critical( 0,
			       tr( "Critical Error" ),
			       tr( "Bd otwarcia pliku %1" ).arg( fileName ) );
	return;
    }
    domTree.clear();
    if ( !domTree.setContent( &opmlFile) ) 
    {
	QMessageBox::critical( 0,
			       tr( "Critical Error" ),
			       tr( "Parsing error for file %1" ).arg( fileName ) );
	opmlFile.close();
	return;
    }
    QDomNodeList lista_tag;
    lista->clear();
    while (skrypty->numRows())
	skrypty->removeRow(0);
   
    lista_tag=domTree.elementsByTagName("skrypt");
    for (uint i=0;i<lista_tag.count();i++)
    {
	new QListViewItem( lista,(lista_tag.item(i).firstChild()).toElement().text()  );
    }
    opmlFile.flush();
    opmlFile.close();   
}



void sql::usunSkrypt_clicked()
{
    if (lista->selectedItem())
    {
	while (skrypty->numRows())
	    skrypty->removeRow(0);
	usunSkrypt(lista->selectedItem()->text(0));
	lista->removeItem(lista->selectedItem());
    }
}


void sql::odswiez_clicked()
{
   while (skrypty->numRows())
	skrypty->removeRow(0);
    
   sqlEdit->clear();
   lista->clear();
   
  QFile opmlFile( fileName );
  if (!opmlFile.open(IO_ReadOnly))
  {
      QMessageBox::critical( 0,
			     tr( "Critical Error" ),
			     tr( "Bd otwarcia pliku %1" ).arg( fileName ) );
      return;
  }
  domTree.clear();
  if ( !domTree.setContent( &opmlFile) ) 
  {
      QMessageBox::critical( 0,
			     tr( "Critical Error" ),
			     tr( "Parsing error for file %1" ).arg( fileName ) );
      opmlFile.close();
      return;
  }
 rootElement = domTree.documentElement();
 QDomNode node = rootElement.firstChild();
 while ( !node.isNull() )
 {
     if ( node.isElement() && node.nodeName() == "skrypt" )
     {
	 new QListViewItem( lista,node.toElement().attribute( "nazwa" ) );
     }
     node = node.nextSibling();
 }    
 opmlFile.flush();
 opmlFile.close();
}








void sql::lista_selectionChanged( QListViewItem * tmp )
{

while (skrypty->numRows())
    skrypty->removeRow(0);
   sqlEdit->clear();
 QDomNode node = rootElement.firstChild();
 while ( !node.isNull() )
 {
     if ( node.isElement() && node.nodeName() == "skrypt" )
     {
	if (node.toElement().attribute( "nazwa" ) ==tmp->text(0))
	 {
	     biezNode=node;
	      QDomNode node1 = node.firstChild();
	      while ( !node1.isNull() )
	      {
	  
		  skrypty->insertRows(skrypty->numRows());
		  QCheckTableItem * item = new QCheckTableItem( skrypty,"");
		  skrypty->setItem( skrypty->numRows()-1, 2,item);
		  item = new QCheckTableItem( skrypty,"");
		  skrypty->setItem( skrypty->numRows()-1, 3,item);
		  skrypty->setText(skrypty->numRows()-1,0,node1.toElement().attribute( "lp" ));
		  skrypty->setText(skrypty->numRows()-1,1,node1.toElement().attribute( "nazwa" ));
		  if (node1.toElement().attribute( "u" ) =="t")
		  ((QCheckTableItem *)(skrypty->item(skrypty->numRows()-1,2)))->setChecked(true);
		  if (node1.toElement().attribute( "d" ) =="t")
		  ((QCheckTableItem *)(skrypty->item(skrypty->numRows()-1,3)))->setChecked(true);
		  skrypty->setText(skrypty->numRows()-1,4,node1.toElement().attribute( "tresc" ));
		  node1 = node1.nextSibling(); 
	      }
	      }
	     } 
     node = node.nextSibling();   
    }
}


void sql::usunSkrypt( QString tmp )
{
    QDomNode node = rootElement.firstChild();
    while ( !node.isNull() )
    {
	if ( node.isElement() && node.nodeName() == "skrypt" )
	{
	    if (node.toElement().attribute( "nazwa" ) ==tmp)
	    {
		rootElement.removeChild(node);
		sqlLog->append("Dd");
		break;
	    }
	}
	node.nextSibling();   
    }
 }


void sql::dodajPolecenie_clicked()
{
    int i=0;
    i=skrypty->currentRow();
    if (i!=-1)
    {
	skrypty->insertRows(i+1);
	QCheckTableItem * item = new QCheckTableItem( skrypty,"");
	skrypty->setItem( i+1, 2,item);
	item = new QCheckTableItem( skrypty,"");
	skrypty->setItem( i+1, 3,item);
    }
    else
    {
	skrypty->insertRows(0);
	QCheckTableItem * item = new QCheckTableItem( skrypty,"");
	skrypty->setItem(0, 2,item);
	item = new QCheckTableItem( skrypty,"");
	skrypty->setItem( 0, 3,item);
    }

}


void sql::usunPolecenie_clicked()
{
    skrypty->removeRow(skrypty->currentRow());
    
}



void sql::znajdzSkrypt( QDomNode *node,QString nazwa)
{
  
    while ( !node->isNull() )
    {
	if ( node->isElement() && node->nodeName() == "skrypt"  &&node->toElement().attribute("nazwa")==nazwa)
	{
	    break;
	}
	*node = node->nextSibling();
    }    
return;
}


void sql::usunPolecenia(QDomNode *node)
{
    QDomNode child,tmp;
    child=node->firstChild();
    while (!child.isNull())
    {
	tmp=child.nextSibling();
	node->removeChild(child);
	child=tmp;
    }
 return;   
}

void sql::dodajPolecenia(QDomNode *node)
{
    int i=0;
    QString u,d;
    u="";
    d="";
    while (i<skrypty->numRows())
    {
	u="";
	d="";
	if (((QCheckTableItem *)(skrypty->item(i,2)))->isChecked())
	    u="t";
	if (((QCheckTableItem *)(skrypty->item(i,3)))->isChecked())
	    d="t";
	dodajPolecenie(node,skrypty->text(i,0),skrypty->text(i,1),u,d,skrypty->text(i,4));
	i++;
    }
    return;   
}


void sql::dodajPolecenie( QDomNode *node, QString lp,QString nazwa,
			 QString u,QString d,QString tresc)
{
    QDomElement   polecenie=domTree.createElement("polecenie");
    polecenie.setAttribute("lp",lp) ;
    polecenie.setAttribute("nazwa",nazwa) ;
    polecenie.setAttribute("u",u) ;
    polecenie.setAttribute("d",d) ;
    polecenie.setAttribute("tresc",tresc) ;
    node->appendChild(polecenie);
}


QStringList sql::parsujPolecenie(QString tmp)
{
    
    QStringList wynik;
    QString tmp1="";
     for (uint i=0;i<tmp.length();i++)
    {
	tmp1=tmp1+tmp.mid(i,1);
	if (tmp.mid(i,1)==";")
	{
	    if ((i>0)&&(tmp.mid(i-1,1)!="\\"))
	    {
		wynik<<tmp1;
		tmp1="";
	    }
	}	
    }
    return wynik;   
}





