/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.largeobject;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.postgresql.Connection;
import org.postgresql.Driver;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class PGblob
implements Blob {
    private Connection conn;
    private int oid;
    private LargeObject lo;

    public PGblob(Connection connection, int n) throws SQLException {
        this.conn = connection;
        this.oid = n;
        LargeObjectManager largeObjectManager = connection.getLargeObjectAPI();
        this.lo = largeObjectManager.open(n);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.lo.getInputStream();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        this.lo.seek((int)l, 0);
        return this.lo.read(n);
    }

    public long length() throws SQLException {
        return this.lo.size();
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        throw Driver.notImplemented();
    }
}

