/*
 * DataPanelToolbar.java
 *
 * Created on 31 de julio de 2002, 18:05
 */

package components.view;
import components.*;
import javax.swing.*;
import java.awt.event.*;

/**
 *
 * @author  nestor
 */
public class DataPanelToolbar extends JToolBar {
    DataPanel panel = null;
    JButton sort = null;
    
    /** Creates a new instance of DataPanelToolbar */
    public DataPanelToolbar(DataPanel _panel) {
        panel = _panel;
        
        sort = new JButton(new ImageIcon("images/sort.png"));
        sort.setActionCommand(DataPanelListener.AC_SORT);
        sort.setToolTipText("Sort view");
        sort.addActionListener(panel.getListener());
        this.add(sort);
        
        this.add(Box.createHorizontalGlue());
    }
    
    public void refreshValidation(){
        if(panel.getView() != null){
            boolean valid = panel.getView() != null;
            sort.setEnabled(valid);
        }
    }
}
