/*
 * Decompiled with CFR 0.152.
 */
package components.view;

import components.view.DataPanel;
import components.view.DataPanelOrderDialogListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import pgclibrary.objects.TableColumn;
import pgclibrary.utilities.SUtilities;

public class DataPanelOrderDialog
extends JDialog {
    DataPanel view_panel = null;
    JList columns = new JList();
    JList columns1 = new JList();
    DataPanelOrderDialogListener listener = null;

    public DataPanelOrderDialog(DataPanel _view_panel) {
        super((Frame)null, "Change view order");
        this.view_panel = _view_panel;
        this.listener = new DataPanelOrderDialogListener(this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DataPanelOrderDialog.this.close();
            }
        });
        this.getContentPane().add(this.getContents(), "Center");
        this.getContentPane().add(this.getButtons(), "South");
        this.setModal(true);
        this.pack();
    }

    private void initComponents() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        DefaultListModel<String> model1 = new DefaultListModel<String>();
        Vector cols = this.view_panel.getView().getColumns();
        int i = 0;
        while (i < cols.size()) {
            String name = ((TableColumn)cols.get(i)).getName();
            if (this.view_panel.getOrderPos(name) > 0) {
                model1.addElement(name);
            } else {
                model.addElement(name);
            }
            ++i;
        }
        this.columns.setModel(model);
        this.columns1.setModel(model1);
        this.columns.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DataPanelOrderDialog.this.addSelection();
                }
            }
        });
        this.columns1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    DataPanelOrderDialog.this.removeSelection();
                }
            }
        });
    }

    private Component getContents() {
        this.initComponents();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        panel1.add(new JLabel("Columns"));
        panel1.add(new JScrollPane(this.columns));
        panel1.setPreferredSize(new Dimension(200, 200));
        JToggleButton left = new JToggleButton(new ImageIcon(this.getClass().getResource("/images/left.png")));
        left.setToolTipText("Removes selected orders");
        left.setActionCommand("remove");
        left.addActionListener(this.listener);
        JButton right = new JButton(new ImageIcon(this.getClass().getResource("/images/right.png")));
        right.setToolTipText("Add selected orders");
        right.setActionCommand("add");
        right.addActionListener(this.listener);
        JPanel panel2 = new JPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(SUtilities.resizeComponent(right));
        panel2.add(SUtilities.resizeComponent(left));
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BoxLayout(panel3, 1));
        panel3.add(new JLabel("Order by"));
        panel3.add(new JScrollPane(this.columns1));
        panel3.setPreferredSize(new Dimension(200, 200));
        panel.add(panel1);
        panel.add(panel2);
        panel.add(panel3);
        return panel;
    }

    private Component getButtons() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        JButton okey = new JButton("Acept");
        okey.setActionCommand("okey");
        okey.addActionListener(this.listener);
        panel.add(okey);
        panel.add(Box.createHorizontalStrut(5));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("cancel");
        cancel.addActionListener(this.listener);
        panel.add(cancel);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public void addSelection() {
        Object[] elements = this.columns.getSelectedValues();
        int i = 0;
        while (i < elements.length) {
            ((DefaultListModel)this.columns.getModel()).removeElement(elements[i]);
            ((DefaultListModel)this.columns1.getModel()).addElement(elements[i]);
            ++i;
        }
    }

    public void removeSelection() {
        Object[] elements = this.columns1.getSelectedValues();
        int i = 0;
        while (i < elements.length) {
            ((DefaultListModel)this.columns1.getModel()).removeElement(elements[i]);
            ((DefaultListModel)this.columns.getModel()).addElement(elements[i]);
            ++i;
        }
    }

    protected void acept() {
        this.view_panel.clearOrder();
        int i = 0;
        while (i < this.columns1.getModel().getSize()) {
            this.view_panel.addOrder((String)this.columns1.getModel().getElementAt(i));
            ++i;
        }
        this.view_panel.refresh();
        this.close();
    }

    protected void close() {
        this.dispose();
    }
}

