/*
 * Decompiled with CFR 0.152.
 */
package components.treeObjects;

import components.treeObjects.Element;
import components.treeObjects.RootElement;
import components.treeObjects.TreeInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.Database;
import pgclibrary.objects.Sequence;

public class SequenceList
extends TreeInfo {
    public SequenceList(RootElement rootElement) {
        super(rootElement);
        this.setIcon("/images/sequence.png");
    }

    public void rebuildProperties() {
        this.removeAllProperties();
        try {
            ResultSet resultSet = this.getConnection().getQueryGenerator().getSequenceNames();
            while (resultSet.next()) {
                this.addProperty(new Element(this, new Sequence(this.getDatabase(), resultSet.getString("sequence_name"))));
            }
            resultSet.close();
            resultSet.getStatement().close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Object getOID() {
        return this.toString();
    }

    public String toString() {
        return "Sequences";
    }

    public Database getDatabase() {
        return ((RootElement)this.getOwner()).getDatabase();
    }
}

