/*
 *
 * PrincipalFrame.java
 *
 * Created on 18 de julio de 2002, 12:12
 */

package frames;

import pgclibrary.objects.*;
import components.treeObjects.*;
import pgclibrary.dataaccess.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import pgclibrary.utilities.*;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public class PrincipalFrame extends JFrame
{
    private PrincipalFrameListener listener = null;
    private Database current_database = new Database(null);
    private  SystemProps systemProperties = new SystemProps();

    private PrincipalFrameToolbar toolbar = null;
    private PrincipalFrameComponent component = null;
    private PrincipalFrameMenu menu = null;

    /** Creates a new instance of PrincipalFrame */
    public PrincipalFrame() {
        super("PGCup - Postgress Administration Tool");

        listener = new PrincipalFrameListener(this);
        menu = new PrincipalFrameMenu(this);
        toolbar = new PrincipalFrameToolbar(this);
        component = new PrincipalFrameComponent(this);

        setJMenuBar(menu);

        getContentPane().add(toolbar, BorderLayout.NORTH);
        getContentPane().add(component, BorderLayout.CENTER);

        try{
            setLocation(Integer.parseInt(systemProperties.getProperty("MAIN_WINDOW_POSX")),
                             Integer.parseInt(systemProperties.getProperty("MAIN_WINDOW_POSY")));
            component.setPreferredSize(new Dimension(Integer.parseInt(systemProperties.getProperty("MAIN_WINDOW_WIDTH")),
                             Integer.parseInt(systemProperties.getProperty("MAIN_WINDOW_HEIGHT"))));
        } catch (Exception e){};


        addWindowListener(new closeAdapter(this));

        refreshValidation();
    }

    public void updateSelectedObject(TreeInfo _obj){
        component.updateSelectedObject(_obj);
    }

    public void openNewSQLWindow(){
        SQLExecutionFrame tmp = new SQLExecutionFrame(this);
        tmp.show();
    }

    public void disconnect(){
        current_database = new Database(null);
        refreshData();
        refreshValidation();
    }

    public void refreshData(){
        component.refreshTree();
        refreshValidation();
        repaint();
    }

    public void  refreshValidation(){
        toolbar.refreshValidation();
        menu.refreshValidation();
        component.refreshValidation();
    }

    public void  vacuum(){
        if ((current_database != null) && (current_database.validate())){
            try{
                current_database.getConnection().executeUpdate("VACUUM");
            } catch (SQLException e){
                JOptionPane.showMessageDialog(this, e.getMessage(), "Command Error", JOptionPane.ERROR_MESSAGE);
            }
        }
    }

    // - - - -  SET AND GETS METHDS  - - - - -

    public Database getDatabase(){
        return current_database;
    }
    public void setDatabase(MainConnection _connection){
        current_database = new Database(_connection);
    }

    public SystemProps getSystemProperties(){
        return systemProperties;
    }

    public PrincipalFrameListener getListener(){
        return listener;
    }
    public void close(){
        systemProperties.setProperty("MAIN_WINDOW_POSX", String.valueOf((int) this.getLocation().getX()));
        systemProperties.setProperty("MAIN_WINDOW_POSY", String.valueOf((int) this.getLocation().getY()));
        systemProperties.setProperty("MAIN_WINDOW_HEIGHT", String.valueOf((int) component.getSize().getHeight()));
        systemProperties.setProperty("MAIN_WINDOW_WIDTH", String.valueOf((int) component.getSize().getWidth()));
        systemProperties.setProperty("LOG_DIVIDER_LOCATION", String.valueOf((int) component.getDataComponent().getDividerLocation()));
        systemProperties.writeProperties();
        System.exit(0);
    }
}

class closeAdapter extends WindowAdapter{
    PrincipalFrame frame = null;

    public closeAdapter(PrincipalFrame _frame){
        frame = _frame;
    }

    public void windowClosing(WindowEvent e) {
        frame.close();
    }
}
