/*
 * dataSourceVector.java
 *
 * Created on 14 de septiembre de 2001, 11:16
 */

package pgclibrary.dataaccess;

import java.text.*;
import java.sql.*;
import java.util.*;

/** Implements a datasource from a Matrix (Vector of Vectors),
 * this can be used for cursom dataSources.
 *
 * @author NMarsollier
 * @version 1.0
 * @see DataSource
 */
public class dataSourceVector extends dataSource {
    SimpleDateFormat espFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    
    private Vector data = new Vector();
    private int pos = 0;
    private Vector column_sizes = new Vector();
    
    public dataSourceVector() {
        goTop();
    }
    
    /** Clean the Vector elements. */
    public void close() {
        data = new Vector();
    }
    
    /** Return all the data.
     * @return Data.
     */    
    protected Vector getData(){
        return data;
    }
    
    /** Makes a new datasource from the data specified.
     * @param _data Vector of Vector of data.
     */
    public dataSourceVector(Vector _data){
        setVector(_data);
    }
    
    /** Retrieve the row count.
     * @return Row count.
     */
    public int getRowCount(){
        return data.size();
    }
    
    /** Sets the data vector table.
     * @param _data Vector table.
     */    
    public void setVector(Vector _data){
        if (_data != null){
            data = _data;
        }
        goTop();
    }
    
    /** Moves to the first record.
     */    
    public void goTop(){
        pos = 0;
        if(isFiltered()){
            pos = getRowBegin();
        }
        super.setRowNum(pos+1);
    }
    
    /** Moves to the next record.
     * @return True if has more records.
     */    
    public boolean next(){
        boolean retorno = false;
        if (!eof()){
            pos ++;
            retorno = !eof();
            super.setRowNum(pos+1);
        }
        return retorno;
    }
    
    /** Return if the last record is arrived.
     * @return true if we are in the last record.
     */    
    public boolean eof(){
        boolean retorno = false;
        retorno = data.size() < pos;
        if(!retorno && isFiltered()){
            retorno = getRowEnd() < pos;
        }
        return retorno;
    }
    
    /** Retieve the element at the specific position.
     * @param _col Column number.
     * @return Value stored.
     */    
    public String getElementAt(int _col){
        String resultado = new String();
        
        Vector temp = (Vector) data.elementAt(pos);
        Object res = temp.elementAt(_col-1);
        
        if (res.getClass() == java.util.Date.class) {
            resultado = espFormat.format(res);
        } else {
            resultado = res.toString();
        }
        return resultado;
    }
    
    /** Retrieve the column count.
     * @return number of columns.
     */    
    public int getColumnCount(){
        return getColumnNames().size();
    }
    
    /** Clear data.
     */    
    public void removeElements(){
        data.removeAllElements();
    }
    /** Adds a new element.
     *
     * @param _element Vector of "String" column values.
     */    
    public void addElement(Vector _element) {
        if(_element != null){
            int cols = getColumnCount();
            if(((cols > 0) && (_element.size() == cols))
            || (cols == 0)) {
                data.add(_element);
            }
        }
    }
    /** Removes the specific row.
     * @param _elem Element number to remove.
     */    
    public void removeElementAt(int _elem) {
        data.removeElementAt(_elem);
    }
    
    /** Define the next column size.
     * @param _size Size
     */    
    public void addColumnSize(int _size){
        column_sizes.add(new Integer(_size));
    }
    
    /** Return the size of the specific column.
     * @param _col Column to retrieve.
     * @return Column size.
     */    
    public int getColumnSize(int _col) {
        int retorno = 0;
        
        if(_col <= getColumnCount()){
            if(_col <= column_sizes.size()){
                retorno =  ((Integer) column_sizes.get(_col-1)).intValue();
            } else {
                retorno = ((String) getColumnNames().get(_col)).length();
            };
        }
        
        return validateColumnSize(retorno);
    }
}
