/*
 * TableForeignKey.java
 *
 * Created on 20 de agosto de 2002, 15:57
 */

package pgclibrary.objects;
import pgclibrary.dataaccess.*;
import java.sql.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class TableForeignKey extends DBObject {
    private boolean enabled = false;
    private String tablename = new String();
    private String onDelete = new String();
    private String onUpdate = new String();
    private Vector scolumns = new Vector();
    private Vector dcolumns = new Vector();
    private boolean deferrable = false;
    
    /** Creates a new instance of TableForeignKey */
    public TableForeignKey(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        return new String();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(30);
        retorno.append("CONSTRAINT ");
        retorno.append(getName());
        retorno.append(" FOREIGN KEY (");
        
        for(int i=0; i<getSourceColumnNames().size(); i++){
            retorno.append(getSourceColumnNames().get(i));
            if(i<getSourceColumnNames().size()-1){
                retorno.append(", ");
            }
        }
        
        retorno.append(" ) REFERENCES ").append(getTableName()).append(" (");
        for(int i=0; i<getDestColumnNames().size(); i++){
            retorno.append(getDestColumnNames().get(i));
            if(i<getDestColumnNames().size()-1){
                retorno.append(", ");
            }
        }
        
        retorno.append(" ) ON DELETE ").append(getOnDelete());
        retorno.append(" ON UPDATE ").append(getOnUpdate());
        if(isDeferrable()){
            retorno.append(" DEFERRABLE ");
        } else {
            retorno.append(" NOT DEFERRABLE ");
        }
        
        retorno.append(" INITIALLY IMMEDIATE");
        return retorno.toString();
    }
    
    /** Find the object asociated with the Name.
     * @param _namae name to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();
            
            ResultSet rs = getConnection().getQueryGenerator().getTableForeignKey(getOwner().getName(), _name);
            if((rs != null) && (rs.next())){
                setEnabled(rs.getBoolean("fk_enabled"));
                setName(rs.getString("fk_name"));
                setTableName(rs.getString("fk_table"));
                setDeferrable(rs.getBoolean("fk_deferrable"));
                setOnDelete(rs.getString("del_proc"));
                setOnUpdate(rs.getString("upd_proc"));
                setColumns(rs.getInt("fk_argnum"), rs.getString("fk_arguments")); 
                
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        enabled = false;
        tablename = new String();
        scolumns = new Vector();
        dcolumns = new Vector();
    }
    
    // ---------SET AND GET-------------
    public boolean isEnabled(){
        return enabled;
    }
    public boolean isDeferrable(){
        return deferrable;
    }
    public String getTableName(){
        return tablename;
    }
    public String getOnDelete(){
        return onDelete;
    }
    public String getOnUpdate(){
        return onUpdate;
    }
    
    public String getSourceColumns(){
        String retorno = new String();
        for(int i= 0; i<getSourceColumnNames().size(); i++){
            if(i>0){
                retorno = retorno + ", ";
            }
            retorno=retorno + (String) getSourceColumnNames().get(i);
        }
        return retorno;
    }
    public Vector getSourceColumnNames(){
        return scolumns;
    }
    
    public String getDestColumns(){
        String retorno = new String();
        for(int i= 0; i<getDestColumnNames().size(); i++){
            if(i>0){
                retorno = retorno + ", ";
            }
            retorno=retorno + (String) getDestColumnNames().get(i);
        }
        return retorno;
    }
    public Vector getDestColumnNames(){
        return dcolumns;
    }
    
    /** refresh the data from database.
     */
    public void refresh() {
        search(getName());
    }
    
    // --- PRIVATE METHODS  ---
    private void setEnabled(boolean _enabled){
        enabled = _enabled;
    }
    private void setDeferrable(boolean _deferrable){
        deferrable = _deferrable;
    }
    private void setTableName(String _table_name){
        if(_table_name != null){
            tablename = _table_name;
        } else {
            tablename = new String();
        }
    }
    
    private String getAction(String _originalAction){
        String retorno = "NO ACTION";
        if(_originalAction.indexOf("cascade") > 0){
            retorno = "CASCADE";
        } else if(_originalAction.indexOf("restrict") > 0){
            retorno = "RESTRICT";
        } else if(_originalAction.indexOf("null") > 0){
            retorno = "SET NULL";
        } else if(_originalAction.indexOf("default") > 0){
            retorno = "SET DEFAULT";
        }
        return retorno;
    }
    
    private void setOnDelete(String _onDelete){
        onDelete = getAction(_onDelete);
    }
    private void setOnUpdate(String _onUpdate){
        onUpdate = getAction(_onUpdate);
    }
    
    private void setColumns(int _argnum, String _arguments){
        StringTokenizer sto = new StringTokenizer(_arguments, "\\000");

        for(int i= 0; (i<4)  && sto.hasMoreTokens(); i++){
            sto.nextToken();
        }
        
        scolumns = new Vector();
        dcolumns = new Vector();
        while(sto.hasMoreTokens()){
            scolumns.add(sto.nextToken());
            dcolumns.add(sto.nextToken());
        }
    }
}
