/*-------------------------------------------------------------------------
 *
 * FILE
 *    newid.c
 *
 * DESCRIPTION
 *    generate a new UUID for PosgreSQL
 *
 * Copyright (c) 2002-2003, Mike Wang <xylophone2001@hotmail.com>
 *
 *-------------------------------------------------------------------------
 *
 * different uuid type implement method
 *
 * $Header: /usr/local/cvsroot/pguuid/pguuid/src/newid.c,v 1.5 2003/06/11 05:43:24 xylophone Exp $
 *
 *-------------------------------------------------------------------------
 */
#include <uuid.h>

#include <postgres.h>
#include <fmgr.h>

/* random base UUID */
PG_FUNCTION_INFO_V1(newid_random);
Datum newid_random(PG_FUNCTION_ARGS)
{
	uuid_p result;

	result = (uuid_p)palloc(sizeof(uuid_t));

	uuid_generate_random(result);

	PG_RETURN_POINTER(result);
}

/* Time base UUID */
PG_FUNCTION_INFO_V1(newid_time);
Datum newid_time(PG_FUNCTION_ARGS)
{
	uuid_p result;

	result = (uuid_p)palloc(sizeof(uuid_t));

	uuid_generate_time(result);

	PG_RETURN_POINTER(result);
}

/* NIL UUID */
PG_FUNCTION_INFO_V1(newid_nil);
Datum newid_nil(PG_FUNCTION_ARGS)
{
	uuid_p result;

	result = (uuid_p)palloc(sizeof(uuid_t));

	uuid_generate_nil(result);

	PG_RETURN_POINTER(result);
}

/* Name base UUID */
PG_FUNCTION_INFO_V1(newid_name);
Datum newid_name(PG_FUNCTION_ARGS)
{
	uuid_p result;

	const uuid_p nsid= (uuid_p) PG_GETARG_POINTER(0);
	const char* name = PG_GETARG_CSTRING(1);

	result = (uuid_p)palloc(sizeof(uuid_t));

	uuid_generate_name(nsid, name, result);

	PG_RETURN_POINTER(result);
}

PG_FUNCTION_INFO_V1(newid_name2);
Datum newid_name2(PG_FUNCTION_ARGS)
{
	uuid_p result;

	const char* nsid= PG_GETARG_CSTRING(0);
	const char* name = PG_GETARG_CSTRING(1);

	result = (uuid_p)palloc(sizeof(uuid_t));

	uuid_generate_name2(nsid, name, result);

	PG_RETURN_POINTER(result);
}
