#include <uuid.h>

#include <postgres.h>
#include <fmgr.h>

#include <utils/timestamp.h>
#include <utils/inet.h>

#include <time.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>

static void adjustment_tm(struct tm* t)
{
/*
	Note PostgreSQL's year is _not_ 1900-based, but is an explicit full value.
	Also, month is one-based, _not_ zero-based.
*/
	++(t->tm_mon);
	t->tm_year += 1900;
}

PG_FUNCTION_INFO_V1(util_uuid_timestamp);
Datum util_uuid_timestamp(PG_FUNCTION_ARGS)
{
	struct tm* t;
	Timestamp result;

	struct timeval tv;

	uuid_p p = (uuid_p) PG_GETARG_POINTER(0);

	/* if p is not point to time-base uuid return null*/
	if (uuid_time(p, &tv))
	{
		PG_RETURN_NULL();
	}

	t = localtime(&(tv.tv_sec));

	adjustment_tm(t);

	if (tm2timestamp(t, 0, 0, &result) != 0)
	{
		elog(ERROR, "Unable to decode TIMESTAMP");
	}

	PG_RETURN_TIMESTAMP(result);
}

PG_FUNCTION_INFO_V1(util_uuid_macaddr);
Datum util_uuid_macaddr(PG_FUNCTION_ARGS)
{
	uuid_p p = (uuid_p) PG_GETARG_POINTER(0);

	macaddr* mdp = (macaddr*)palloc(sizeof(macaddr));

	if (uuid_type(p) != UUID_TYPE_TIME_BASE)
	{
		PG_RETURN_NULL();
	}

	memcpy(mdp, p->node, 6);

	PG_RETURN_MACADDR_P(mdp);
}
