#include "util.h"

#include <uuid.h>

#include <sys/time.h>
#include <sys/types.h>

int get_clock(uuid_u32_t *clock_high, uuid_u32_t *clock_low, uuid_u16_t *ret_clock_seq)
{
	static int adjustment = 0;
	static struct timeval last = {0, 0};
	static uuid_u16_t clock_seq;
	struct timeval tv;
	uuid_u64_t clock_reg;

	const int MAX_ADJUSTMENT = 10;
	
try_again:
	gettimeofday(&tv, 0);
	if ((last.tv_sec == 0) && (last.tv_usec == 0)) {
		get_random_buffer(&clock_seq, sizeof(clock_seq));
		clock_seq &= 0x1FFF;
		last = tv;
		last.tv_sec--;
	}
	if ((tv.tv_sec < last.tv_sec) ||
	    ((tv.tv_sec == last.tv_sec) &&
	     (tv.tv_usec < last.tv_usec))) {
		clock_seq = (clock_seq+1) & 0x1FFF;
		adjustment = 0;
		last = tv;
	} else if ((tv.tv_sec == last.tv_sec) &&
	    (tv.tv_usec == last.tv_usec)) {
		if (adjustment >= MAX_ADJUSTMENT)
			goto try_again;
		adjustment++;
	} else {
		adjustment = 0;
		last = tv;
	}
		
	clock_reg = tv.tv_usec*10 + adjustment;
	clock_reg += ((uuid_u64_t) tv.tv_sec)*10000000;
	clock_reg += (((uuid_u64_t) 0x01B21DD2) << 32) + 0x13814000;

	*clock_high = clock_reg >> 32;
	*clock_low = clock_reg;
	*ret_clock_seq = clock_seq;

	return 0;
}
