/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: query.c */
#include <libpq-fe.h>
#include "consoleout.h"
#include "query.h"

PGconn* connect_db(char* arg)
{
 PGconn* conn;
 char* strarg;
 conn=0;
 strarg = (char*)malloc(strlen(arg)+16);
 debug("\nconnect to database %s\n", arg);
 sprintf(strarg,"dbname=%s", arg);
 conn = PQconnectdb(strarg);
 if (PQstatus(conn) == CONNECTION_BAD)
   {
    error("\nCannot connect to DB:%s\n", arg);
    ERR
    return NULL;
   }
 free(strarg);
 return conn;
}


void clear_result(PGresult** r)
{
 if (*r) PQclear(*r);
 debug("clear result\n");
 *r=0;
}


void disconnect_db(PGconn** c)
{
 debug("disconnect DB\n");
 PQfinish(*c);
}


PGresult* execute_silent_query(PGconn* c,  char* query)
{
 PGresult* r;
 int stat;
 debug("SQLquery: \"%s\"\n", query);
 if (!query)
   {
    debug("NULL query passed\n");
    return NULL;
   }
 r= PQexec(c, query);
 if (!r)
   {
    debug("PQresult is NULL %s\n", PQerrorMessage(c));
    return NULL;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    debug("PQexec error: %s %s",PQcmdStatus(r),PQresultErrorMessage(r));
    debug("Failed query was: \"%s\"\n", query);
    return NULL;
   }
 return r;
}


PGresult* execute_query(PGconn* c,  char* query)
{
 PGresult* r;
 int stat;
 debug("SQLquery: \"%s\"\n", query);
 if (!query)
   {
    ERR error("NULL query passed\n");
    return NULL;
   }
 r= PQexec(c, query);
 if (!r)
   {
    ERR error("PQresult is NULL %s\n", PQerrorMessage(c));
    return NULL;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    ERR error("PQexec: %s %s",PQcmdStatus(r),PQresultErrorMessage(r));
    error("Failed query was: \"%s\"\n", query);
    return NULL;
   }
 return r;
}


char*** pgres2pc3(const PGresult* r, int* a, int* b)
{
 char*** result;
 int i,j;
 if (!r) return 0;
 i=j=0;
 debug("pgres2pc3: %p\n", (void*)r);
 *a = PQntuples(r);
 *b = PQnfields(r);
 /*printf("ntuples=%d,%d\n", *a,*b);*/
 result = (char***)malloc((*a)<<2);
 if (!result) { ERR error("malloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)malloc((*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) free(result[i]);
       ERR error("malloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)malloc(PQgetlength(r,i,j)+1);
    if (!result[i][j])
      {
       free_p3c(&result,*a,*b);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i,j));
   }
#ifdef DEBUG
  debug("char*** result is (%d:%d):\n",i,j);
  for (i=0;i<*a;i++)
    {
     for (j=0;j<*b;j++) debug("%-15s ", result[i][j]);
     ln();
    }
#endif
 return result;
}


void free_p3c(char**** p, int a, int b)
{
 int i,j;
 debug("free_p3c: ****p=%p, a=%d, b=%d\n",(void*)p,a,b);
 if (!(*p)) return ;
 for (i=0;i<a;i++) if (!(*p)[i]) return ;
 for (i=0;i<a;i++)
 for (j=0;j<b;j++) if ((*p)[i][j]) free((*p)[i][j]);
 for (i=0;i<a;i++) if ((*p)[i])    free((*p)[i]);
 free(*p);
}

