<?php // $Id: maintenance-activation.php,v 1.2 2001/07/09 16:43:06 ciaccia Exp $ - #phpAdsNew Revision: 1.1 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/






/*********************************************************/
/* Mail clients and check for activation  				 */
/* and expiration dates					 				 */
/*********************************************************/

$res_clients = db_query("
	SELECT
		clientid,
		clientname,
		contact,
		email,
		language,
		reportdeactivate
	FROM
		$phpAds_tbl_clients
	WHERE
		parent = 0
	
	") or die($strLogErrorClients);

for ($pgc = 0; $client = @pg_fetch_array($res_clients, $pgc); $pgc++)
{
	// Process this client
	print "<br>Processing client ".$client["clientname"]."...<BR>\n";
	flush();
    
	// Load client language strings
	if (isset($client["language"]) && $client["language"] != "")
		include ("../language/".$client["language"].".inc.php");
	else
		include ("../language/$phpAds_language.inc.php");
	
	// Change date/time formats to match Postgres Syntax
	$date_format = strtr($date_format, array("%d" => "DD", "%m" => "MM", "%Y" => "YYYY"));
	$time_format = strtr($time_format, array("%H" => "HH24", "%i" => "MI", "%S" => "SS"));
	
	// Send Query
	$res_campaigns = db_query("
		SELECT
			clientid,
			clientname,
			views,
			clicks,
			expire,
			UNIX_TIMESTAMP(expire) as expire_st,
			activate,
			UNIX_TIMESTAMP(activate) as activate_st,
			active
		FROM
			$phpAds_tbl_clients
		WHERE
			parent = ".$client['clientid']."
		") or die($strLogErrorClients);
	
	
	for ($pgx = 0; $campaign = @pg_fetch_array($res_campaigns, $pgx); $pgx++)
	{
		// Process this client
		print "&nbsp;&nbsp;&nbsp;Processing campaign ".$campaign["clientname"]."...<BR>\n";
		flush();
	    
		
		print "&nbsp;&nbsp;&nbsp;- Current status: ".$campaign["active"]."<BR>\n";
		
		$active = "t";
		
		if ($campaign["clicks"] == 0 || $campaign["views"] == 0)
			$active = "f";
		
		if (time() < $campaign["activate_st"])
			$active = "f";
		
		if (time() > $campaign["expire_st"] && $campaign["expire_st"] != 0)
			$active = "f";
		
		if ($campaign["active"] != $active)
		{
			$client_name = $campaign["clientname"];
			$client_ID 	 = $campaign['clientid'];
			
			print "&nbsp;&nbsp;&nbsp;- Setting activation to $active<br>";
			$activateresult = db_query("UPDATE $phpAds_tbl_clients SET active='$active' WHERE clientid=$client_ID") or pg_die ("$strLogErrorDisactivate");
			
			if ($active == "f")
			{
				// Email deactivation warning
				if ($client["email"] != '' && $client["reportdeactivate"] == 't')
				{
					$Subject = $strMailSubjectDeleted.": ".$campaign["clientname"];
	        		$To		 = $client["contact"]." <".$client["email"].">";
					
					$Body = "$strMailHeader\n";
					$Body .= $strMailClientDeactivated;
					if ($campaign['clicks'] == 0) 			$Body .= ", $strNoMoreClicks";
					if ($campaign['views'] == 0) 			$Body .= ", $strNoMoreViews";
					if (time() < $campaign["activate_st"])	$Body .= ", $strBeforeActivate";
					if (time() > $campaign["expire_st"] && $campaign["expire_st"] != 0)
						$Body .= ", $strAfterExpire";
					$Body .= ".\n\n";
					
					
					$res_banners = db_query("
						SELECT
							bannerid,
							URL,
							description,
							alt
						FROM
							$phpAds_tbl_banners
						WHERE
							clientid = ".$campaign['clientid']."
						") or die($strLogErrorBanners);
					
					if (pg_numrows($res_banners) > 0)
					{
						$Body .= "-------------------------------------------------------\n";
						
						for ($pgy = 0; $row_banners = @pg_fetch_array($res_banners, $pgy); $pgy++)
						{
							$Body .= $strBanner."  ".phpAds_buildBannerName ($row_banners['bannerid'], $row_banners['description'], $row_banners['alt'])."\n";
							$Body .= "linked to: ".$row_banners['url']."\n";
							$Body .= "-------------------------------------------------------\n";
						}
					}
					
					$Body .= "\n";
					$Body .= "$strMailNothingLeft\n\n";
					$Body .= "$strMailFooter";
					
					$Body  = str_replace ("{clientname}", $client["clientname"], $Body);
					$Body  = str_replace ("{contact}", $client["contact"], $Body);
					$Body  = str_replace ("{adminfullname}", $phpAds_admin_fullname, $Body);
					
					mail ($To, $Subject, $Body, $phpAds_admin_email_headers);
					unset ($Subject) ;
					
					print "&nbsp;&nbsp;&nbsp;- Report sent to ".$client["email"]."...<BR>\n";
					flush();
				}
			}
		}
	}
}

echo "<br><br>$strLogMailSent\n";


?>
