/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.EOXactListener;
import org.postgresql.pljava.internal.TransactionEvent;
import org.postgresql.pljava.internal.TransactionListener;
import org.postgresql.pljava.internal.TransactionalMap;

public class Session
implements EOXactListener,
org.postgresql.pljava.Session {
    private final ArrayList m_xactListeners = new ArrayList();
    private final TransactionalMap m_attributes = new TransactionalMap((Map)new HashMap());

    public void addTransactionListener(TransactionListener transactionListener) {
        if (!this.m_xactListeners.contains(transactionListener)) {
            this.m_xactListeners.add(transactionListener);
        }
    }

    public Object getAttribute(String string) {
        return this.m_attributes.get(string);
    }

    public TransactionListener[] getTransactionListeners() {
        return this.m_xactListeners.toArray(new TransactionListener[this.m_xactListeners.size()]);
    }

    public String getUserName() {
        return AclId.getUser().getName();
    }

    public String getSessionUserName() {
        return AclId.getSessionUser().getName();
    }

    public void onEOXact(boolean bl) {
        if (bl) {
            this.m_attributes.commit();
        } else {
            this.m_attributes.abort();
        }
        int n = this.m_xactListeners.size();
        if (n == 0) {
            return;
        }
        TransactionEvent transactionEvent = new TransactionEvent(this);
        TransactionListener[] transactionListenerArray = this.getTransactionListeners();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                transactionListenerArray[i].afterCommit(transactionEvent);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                transactionListenerArray[i].afterAbort(transactionEvent);
            }
        }
    }

    public void removeAttribute(String string) {
        this.m_attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.m_attributes.put(string, object);
    }

    public void removeTransactionListener(TransactionListener transactionListener) {
        this.m_xactListeners.remove(transactionListener);
    }
}

