/*==============================================================*/
/* Database name:  PHYSICALDATAMODEL_1                          */
/* DBMS name:      PostgreSQL 7                                 */
/* Created on:     6/02/2003 11:59:03 PM                        */
/*==============================================================*/


drop index protocol_number_IDX;

drop table protocol;

drop table usage;

/*==============================================================*/
/* Table: protocol                                              */
/*==============================================================*/
create table protocol (
number               INT2                 not null,
description          TEXT                 null
);

comment on table protocol is
'IP protocol number';

comment on column protocol.number is
'protocol assigned number';

comment on column protocol.description is
'text describing the protocol';

/*==============================================================*/
/* Index: protocol_number_IDX                                   */
/*==============================================================*/
create unique index protocol_number_IDX on protocol (
number
);

/*==============================================================*/
/* Table: usage                                                 */
/*==============================================================*/
create table usage (
ip_src               CHAR(15)             not null,
ip_dst               CHAR(15)             null,
port_src             INT4                 null,
port_dst             INT4                 null,
number               INT2                 null,
first_seen           TIMESTAMP            null,
last_seen            TIMESTAMP            null,
volume               INT4                 null
);

comment on table usage is
'A usage record containing endpoints and volume';

comment on column usage.first_seen is
'start of this capture record';

alter table usage
   add constraint FK_USAGE_REFERENCE_PROTOCOL foreign key (number)
      references protocol (number);

