
struct CRecord {
    struct in_addr  ip_src_m;
	int	srcSerial_m;
    struct in_addr  ip_dst_m;
	int dstSerial_m;
    u_int16_t port_src_m;
    u_int16_t port_dst_m;
    u_int8_t ip_proto_m;
    int volume_m;
	int packets_m;
    struct timeval lastUpdate_m;
    struct timeval firstUpdate_m;
	char *llSrc_m;
	char *llDst_m;

	CRecord() {
		abort();
	}
    CRecord(const struct my_ip *ip, int volume, const char *llSrc, const char *llDst);
    ~CRecord();

    friend ostream& operator<<(ostream &os, const CRecord *cr);
};


struct CompareCRecord  {
    bool operator()(const CRecord *s1, const CRecord* s2) const {
		in_addr_t src1 = s1->ip_src_m.s_addr;
		in_addr_t dest1 = s1->ip_dst_m.s_addr;
		in_addr_t src2 = s2->ip_src_m.s_addr;
		in_addr_t dest2 = s2->ip_dst_m.s_addr;

		if (src1 == src2) {
			if (dest1 == dest2) {
				if (s1->port_src_m == s2->port_src_m) {
					if (s1->port_dst_m == s2->port_dst_m) {
						return s1->ip_proto_m < s2->ip_proto_m;
					} else {
						return s1->port_dst_m < s2->port_dst_m;
					}
				} else {
					return s1->port_src_m < s2->port_src_m;
				}
			} else {
				return dest1 < dest2;
			}
		} else {
			return src1 < src2;
		}
    }
};

typedef list<CRecord *> CRecordList;
typedef CRecordList::iterator	CRecordListIter;

// map of a partially filled in CRecord to the one in the list
typedef map<CRecord *,	CRecordListIter, CompareCRecord> CRecordMap;
typedef CRecordMap::iterator CRecordMapIter;

class RTable {
	CRecordMap	crm;
	CRecordList	crl_m;
	int		SleepTime_m;
	pthread_mutex_t mutex_m;
	int	dataLinkType_m;
	DnsCache	*dnsCache_m;
	int	age_m;
	string	interfaceName_m;
	pcap_t *descr_m;
public:
	RTable(int SleepTime, int dataLinkType, DnsCache *dnsCache_m, int age, char *device, pcap_t *descr);
	void	Add(CRecord *cr, struct timeval when);
	void	MakeListOfFlushItems(CRecordList *ulist, struct timeval *since);
	int	Get_DataLinkType() const { return dataLinkType_m; }
	int	Get_Age() const { return age_m; }
	int FindHostFromIP(const struct in_addr& ip, const char *mac) const  { 
		return dnsCache_m->FindHostFromIP(ip, mac);
	}
	string Get_InterfaceName()  const { return interfaceName_m; }
	DnsCache	*Get_DnsCache() const { return dnsCache_m; }
	int	Get_SleepTime() const { return SleepTime_m; }
	pcap_t	*Get_descr() const { return descr_m; }
	friend ostream& operator<<(ostream &os, RTable& rtt);
};


extern ostream& operator<<(ostream &os, struct timeval tv);
