#include <windows.h>
#include <winreg.h>
#include <stdio.h>
#include <assert.h>
#include "main.h"
#include "profile.h"
//------------------------------------------------------------------------------
#ifdef _MSC_VER
#include "direct.h"
#define getcwd _getcwd
#else
#include <unistd.h>
#endif
//------------------------------------------------------------------------------
ProfileReader::ProfileReader(LPSTR lpszProfile)
{
	MyKey = 0;
	m_outputFile = NULL;
	SetProfile(lpszProfile);
}
ProfileReader::~ProfileReader()
{
}
void ProfileReader::SetProfile(LPSTR lpszProfile)
{
	if(lpszProfile)
		sprintf(m_subkey, "%s\\%s", SUBKEY, lpszProfile);
	else
	{
	    char defprofile[MAX_BUF_LEN];
		strcpy(m_subkey, SUBKEY);
		
		if( ReadValue( VAL_DEFPROFILE, defprofile, sizeof(defprofile)) )
        	sprintf(m_subkey, "%s\\%s", SUBKEY, defprofile);
        else
        	strcpy(m_subkey, SUBKEY);
	}


		

	if(MyKey)
		RegCloseKey(MyKey);

	MyKey = 0;
}
//------------------------------------------------------------------------------
void ProfileReader::Log(char *buf)
{
	if(m_outputFile)
		fwrite(buf, 1, strlen(buf), m_outputFile);
}
//------------------------------------------------------------------------------
int ProfileReader::OpenKey( HKEY hKey, LPCTSTR lpSubKey )
{
	LPTSTR lpClass=NULL;
	DWORD Disposition;
	
	assert(lpSubKey);

	if( RegCreateKeyEx( hKey,						// handle of an open key
						lpSubKey,					// address of subkey name
						0,							// reserved
						lpClass,					// address of class string
						REG_OPTION_NON_VOLATILE	,	// special options flag
						KEY_ALL_ACCESS,				// desired security access
						NULL,						// address of key security structure
						&MyKey,						// address of buffer for opened handle
						&Disposition 				// address of disposition value buffer
						)  != ERROR_SUCCESS )
	{
		ShowLastError( "ProfileReader : OpenKey" );
		return FALSE;
	}
	return TRUE;
}
//------------------------------------------------------------------------------
int ProfileReader::ReadValue( LPTSTR lpValueName, LPSTR lpszReturn, DWORD cb )
{
	DWORD	lpType;
	DWORD 	lpcbData = MAX_BUF_LEN;
	char	msg [MAX_BUF_LEN];
	
	if( MyKey == 0 )
		OpenKey(HKEY_LOCAL_MACHINE, m_subkey);
	
	long error = ::RegQueryValueEx(	
					MyKey,				// handle of key to query
					lpValueName,		// address of name of value to query
					NULL,				// reserved
					&lpType,			// address of buffer for value type
					(LPBYTE)lpszReturn,	// address of data buffer
					&cb 				// address of data buffer size
					 	);
	if(error != ERROR_SUCCESS && error != ERROR_FILE_NOT_FOUND)
	{
		sprintf( msg, MSGFMT_READVAL_ERR_SL, lpValueName, error );
		ShowLastError( msg  );
		return FALSE;
	}
	return error == ERROR_SUCCESS;
}
//------------------------------------------------------------------------------
int ProfileReader::SetValue( LPTSTR lpValueName, LPTSTR lpValue )
{
	char	msg [MAX_BUF_LEN];
	
	if( MyKey == 0 )
		OpenKey(HKEY_LOCAL_MACHINE, m_subkey);

	long error = RegSetValueEx(	
				MyKey,					// handle of key to set value for
				lpValueName,			// address of value to set
				0,						// reserved
				REG_SZ,					// flag for value type
				(CONST BYTE *)lpValue,	// address of value data
				strlen(lpValue) + 1 	// size of value data
				);
	if(error != ERROR_SUCCESS )
	{
		sprintf( msg, MSGFMT_SETVAL_ERR_SL, lpValueName, error );
		ShowLastError( msg  );
		return FALSE;
	}
    return TRUE;
}
//------------------------------------------------------------------------------
BOOL ProfileReader::ReadBoolValue(LPTSTR lpValueName, BOOL def)
{
	char buffer[256];

	if(ReadValue(lpValueName, buffer, sizeof(buffer)))
	{
		if( (strcasecmp(buffer, "TRUE") == 0) ||\
			(strcasecmp(buffer, "1") == 0) ||
			(strcasecmp(buffer, "YES") == 0))
			return TRUE;
		else
			return FALSE;
	}
	return def;
}
//------------------------------------------------------------------------------
int ProfileReader::ReadValues( void )
{
	if( !ReadValue( VAL_COMMAND, m_command, sizeof(m_command)) )
		return FALSE;

	if( !ReadValue( VAL_BINDIR, m_bindir, sizeof(m_bindir)) )
		return FALSE;
	
	if( !ReadValue( VAL_KILL, m_kill, sizeof(m_kill)) )
		return FALSE;

	if( !ReadValue( VAL_PIDFILE, m_pidfile, sizeof(m_pidfile)) )
		memset(m_pidfile, 0, sizeof(m_pidfile));

	if( !ReadValue( VAL_PRERUN, m_prerun, sizeof(m_prerun)) )
		memset(m_prerun, 0, sizeof(m_prerun));

	if( !ReadValue(VAL_TITLE, m_title, sizeof(m_title)) )
		strcpy(m_title, SYSTEM_TITLE);

	if( !ReadValue(VAL_READY, m_ready, sizeof(m_ready)) )
		strcpy(m_ready, FLAG_SYS_READY);

	if( !ReadValue(VAL_SHUTDOWN, m_shutdown, sizeof(m_shutdown)) )
		strcpy(m_shutdown, FLAG_SYS_SHUTDOWN);

	if( !ReadValue(VAL_LOGFILE, m_logfile, sizeof(m_logfile)) )
		memset(m_logfile, 0, sizeof(m_logfile));

	Prf.m_stopquit = ReadBoolValue(VAL_STOPQUIT, FALSE);
	Prf.m_logout = ReadBoolValue(VAL_LOGOUT, FALSE);

	if(m_logout)
	{
		if(m_outputFile != NULL)
			fclose(m_outputFile);

		m_outputFile = fopen(m_logfile, "a+");

		if(!m_outputFile)
		{
			char buffer[MAX_BUF_LEN];
			sprintf(buffer, MSGFMT_LOGERR_OPEN_S, m_logfile);
			MessageBox (0, buffer, MSG_ERROR, MB_ICONEXCLAMATION | MB_OK);
			return FALSE;
		}
	}

	return TRUE;
}
//------------------------------------------------------------------------------
int ProfileReader::SetValues( void )
{
	if( !SetValue( VAL_COMMAND, m_command ) ) 
		return FALSE;

	if( !SetValue( VAL_PRERUN, m_prerun ) )
		return FALSE;

	if( !SetValue( VAL_KILL, m_kill ) )
		return FALSE;

	if( !SetValue( VAL_PIDFILE, m_pidfile ) )
		return FALSE;

	if( !SetValue( VAL_BINDIR, m_bindir ) )
		return FALSE;

	if( !SetValue(VAL_READY, m_ready) )
		return FALSE;

	if( !SetValue(VAL_SHUTDOWN, m_shutdown) )
		return FALSE;

	SetValue(VAL_TITLE, m_title);

	SetValue(VAL_LOGFILE, m_logfile);

	SetValue(VAL_STOPQUIT, (LPTSTR) ((m_stopquit) ? "TRUE" : "FALSE"));
	SetValue(VAL_LOGOUT, (LPTSTR) ((m_logout) ? "TRUE" : "FALSE"));

	if(!m_logout && m_outputFile)
	{
		fclose(m_outputFile);
		m_outputFile=0;
	}

	return TRUE;

}
//------------------------------------------------------------------------------
extern "C" int ProfileRead( char *profile )
{
	if(profile)
		Prf.SetProfile(profile);

	return Prf.ReadValues();
}
//------------------------------------------------------------------------------
