/**
 - gc_pathexp.sql,v 1.1 2003/07/17 14:10:45 myui Exp
 */

--BEGIN;

CREATE OR REPLACE FUNCTION plpgsql_call_handler () RETURNS LANGUAGE_HANDLER AS
    '$libdir/plpgsql' LANGUAGE C;

DROP FUNCTION gc_pathexp();

DROP LANGUAGE plpgsql;
CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql
    HANDLER plpgsql_call_handler;

CREATE OR REPLACE FUNCTION gc_pathexp() RETURNS BOOL AS'
DECLARE
    mviews RECORD;
BEGIN
    RAISE NOTICE ''[gc_pathexp] start'';
    FOR mviews IN
                    SELECT
                       xp.pathid as oldpid,
                       p1.pathid as newpid
                    FROM
                        xml_path xp,
                        --xml_node xn,
                        (SELECT
                            pathexp,
                            min(pathid) as pathid
                        FROM
                            xml_path
                        GROUP BY
                            pathexp
                        ) p1
                    WHERE
                        xp.pathexp = p1.pathexp and
                        xp.pathid != p1.pathid
                        --and xn.pathid = xp.pathid and
                        --xp.united IS NULL and _int_vdim(xn.dewey,1) != -1
    LOOP
        --PERFORM
            UPDATE
		xml_node
            SET
                pathid=mviews.newpid
            WHERE
                pathid=mviews.oldpid;
        --PERFORM
--        	UPDATE
--        		xml_path
--        	SET
--        		united = ''true''
--        	WHERE
--        		pathid = mviews.newpid;
        --PERFORM
            DELETE FROM
                xml_path
            WHERE
                pathid=mviews.oldpid;
    END LOOP;
    RAISE NOTICE ''[gc_pathexp] finish'';
    RETURN TRUE;
END;'
LANGUAGE 'plpgsql';

/*
CREATE or REPLACE FUNCTION gc_pathexp() RETURNS TRIGGER AS '
    BEGIN
	update
		xml_node
	set
		pathid = (
			select
				min(pathid)
			from
				xml_path
			where
				pathexp = OLD.pathexp
			)
	where
		pathid = OLD.pathid;
	RETURN NULL;
    END;
' LANGUAGE 'plpgsql';

DROP TRIGGER gc_pathexp ON xml_path;
CREATE TRIGGER gc_pathexp AFTER DELETE ON xml_path
    FOR EACH ROW EXECUTE PROCEDURE gc_pathexp();
*/

--END;
