set enable_seqscan=on

drop table tmp_xn_68393_4668;
drop view tmp_xn_68393_4668;
create local temp table tmp_xn_68393_4668 as
--create or replace view tmp_xn_68393_4668 as
SELECT
    trg.kind,
    trg.dewey,
    trg.tagid,
    trg.value
FROM
    xml_node trg,
    xml_node xn
WHERE
    xn.id = 68393 AND
    trg.dewey > xn.dewey AND
    trg.dewey < nextSibling(xn.dewey)

explain analyze
SELECT
    xn.dewey as dewey,
    1 as seq,
    '<' || xt.name as parsed_text
FROM
    tmp_xn_68393_4668 xn,
    xml_tag xt
WHERE
    xn.tagid = xt.tagid AND
    xn.kind = '1'
UNION ALL
SELECT
    xn.dewey,
    xn.kind - 3,
    case when xn.kind = '5' then ' ' || xa.name || '="' || xn.value || '"' else ' ' || ns.name || '="' || xn.value || '"' end
FROM
    tmp_xn_68393_4668 xn left join xml_attribute xa using(tagid) left join xml_namespace ns using(tagid)
WHERE
    xn.kind = '5' OR
    xn.kind = '6'
UNION ALL
SELECT
    xn.dewey + 0,
    4 as seq,
    '>'
FROM
    tmp_xn_68393_4668 xn
WHERE
    xn.kind = '1'
UNION ALL
SELECT
    xn.dewey,
    5,
    case when xn.kind = '2' then xn.value when xn.kind = '3' then '<!-- ' || xn.value || ' -->' else '<?' || pi.name || xn.value || '?>' end
FROM
    tmp_xn_68393_4668 xn left join xml_pi pi using(tagid)
WHERE
    xn.kind = '2' OR
    xn.kind = '3' OR
    xn.kind = '4'
UNION ALL
SELECT
    xn.dewey + 2147483647,
    6 as seq,
    '</' || xt.name || '>'
FROM
    tmp_xn_68393_4668 xn,
    xml_tag xt
WHERE
    xn.tagid = xt.tagid AND
    xn.kind = '1'
ORDER BY
    dewey,
    seq

*** TMP TABLE ***
QUERY PLAN
Sort  (cost=500000139.91..500000140.00 rows=35 width=107) (actual time=0.35..0.35 rows=0 loops=1)
  Sort Key: dewey, seq
  ->  Append  (cost=100000022.58..500000139.02 rows=35 width=107) (actual time=0.28..0.28 rows=0 loops=1)
        ->  Subquery Scan "*SELECT* 1"  (cost=100000022.58..100000026.26 rows=2 width=40) (actual time=0.05..0.05 rows=0 loops=1)
              ->  Merge Join  (cost=100000022.58..100000026.24 rows=2 width=40) (actual time=0.05..0.05 rows=0 loops=1)
                    Merge Cond: ("outer".tagid = "inner".tagid)
                    ->  Sort  (cost=100000022.58..100000022.59 rows=6 width=36) (actual time=0.05..0.05 rows=0 loops=1)
                          Sort Key: xn.tagid
                          ->  Seq Scan on tmp_xn_68393_4668 xn  (cost=100000000.00..100000022.50 rows=6 width=36) (actual time=0.00..0.00 rows=0 loops=1)
                                Filter: (kind = 1::smallint)
                    ->  Index Scan using xml_tag_pkey on xml_tag xt  (cost=0.00..3.49 rows=46 width=12) (never executed)
        ->  Subquery Scan "*SELECT* 2"  (cost=100000006.75..100000032.24 rows=10 width=107) (actual time=0.15..0.15 rows=0 loops=1)
              ->  Hash Left Join  (cost=100000006.75..100000032.14 rows=10 width=107) (actual time=0.15..0.15 rows=0 loops=1)
                    Hash Cond: ("outer".tagid = "inner".tagid)
                    ->  Hash Left Join  (cost=100000003.07..100000028.15 rows=10 width=79) (actual time=0.10..0.10 rows=0 loops=1)
                          Hash Cond: ("outer".tagid = "inner".tagid)
                          ->  Seq Scan on tmp_xn_68393_4668 xn  (cost=100000000.00..100000025.00 rows=10 width=70) (actual time=0.00..0.00 rows=0 loops=1)
                                Filter: ((kind = 5::smallint) OR (kind = 6::smallint))
                          ->  Hash  (cost=3.05..3.05 rows=5 width=13) (actual time=0.07..0.07 rows=0 loops=1)
                                ->  Index Scan using xml_attribute_pkey on xml_attribute xa  (cost=0.00..3.05 rows=5 width=13) (actual time=0.02..0.05 rows=5 loops=1)
                    ->  Hash  (cost=3.68..3.68 rows=1 width=36) (actual time=0.01..0.01 rows=0 loops=1)
                          ->  Index Scan using xml_namespace_pkey on xml_namespace ns  (cost=0.00..3.68 rows=1 width=36) (actual time=0.01..0.01 rows=0 loops=1)
        ->  Subquery Scan "*SELECT* 3"  (cost=100000000.00..100000022.58 rows=6 width=32) (actual time=0.00..0.00 rows=0 loops=1)
              ->  Seq Scan on tmp_xn_68393_4668 xn  (cost=100000000.00..100000022.52 rows=6 width=32) (actual time=0.00..0.00 rows=0 loops=1)
                    Filter: (kind = 1::smallint)
        ->  Subquery Scan "*SELECT* 4"  (cost=100000003.68..100000031.68 rows=15 width=98) (actual time=0.04..0.04 rows=0 loops=1)
              ->  Hash Left Join  (cost=100000003.68..100000031.53 rows=15 width=98) (actual time=0.03..0.03 rows=0 loops=1)
                    Hash Cond: ("outer".tagid = "inner".tagid)
                    ->  Seq Scan on tmp_xn_68393_4668 xn  (cost=100000000.00..100000027.50 rows=15 width=70) (actual time=0.00..0.00 rows=0 loops=1)
                          Filter: ((kind = 2::smallint) OR (kind = 3::smallint) OR (kind = 4::smallint))
                    ->  Hash  (cost=3.68..3.68 rows=1 width=36) (actual time=0.01..0.01 rows=0 loops=1)
                          ->  Index Scan using xml_pi_pkey on xml_pi pi  (cost=0.00..3.68 rows=1 width=36) (actual time=0.01..0.01 rows=0 loops=1)
        ->  Subquery Scan "*SELECT* 5"  (cost=100000022.58..100000026.27 rows=2 width=40) (actual time=0.03..0.03 rows=0 loops=1)
              ->  Merge Join  (cost=100000022.58..100000026.25 rows=2 width=40) (actual time=0.03..0.03 rows=0 loops=1)
                    Merge Cond: ("outer".tagid = "inner".tagid)
                    ->  Sort  (cost=100000022.58..100000022.59 rows=6 width=36) (actual time=0.02..0.02 rows=0 loops=1)
                          Sort Key: xn.tagid
                          ->  Seq Scan on tmp_xn_68393_4668 xn  (cost=100000000.00..100000022.50 rows=6 width=36) (actual time=0.00..0.00 rows=0 loops=1)
                                Filter: (kind = 1::smallint)
                    ->  Index Scan using xml_tag_pkey on xml_tag xt  (cost=0.00..3.49 rows=46 width=12) (never executed)
Total runtime: 0.80 msec

ͻ: Ϥ˷оݤʤäƤΤǡ®٤ϤϤ䤤
	PostgreSQLtemp tableϥǥȯΤǡϤtemp table˽񤯥
	礭ˤϡ񤭹ߤˤٱ䤬Ǥ뤫⤷ʤ
	ޤxn.tagid = xt.tagidjoinԤʤȤ

*** VIEW ***
QUERY PLAN
Sort  (cost=4899.92..4928.02 rows=11239 width=402) (actual time=1.54..1.54 rows=0 loops=1)
  Sort Key: dewey, seq
  ->  Append  (cost=3.60..2965.72 rows=11239 width=402) (actual time=1.47..1.47 rows=0 loops=1)
        ->  Subquery Scan "*SELECT* 1"  (cost=3.60..594.09 rows=1903 width=62) (actual time=0.54..0.54 rows=0 loops=1)
              ->  Hash Join  (cost=3.60..575.06 rows=1903 width=62) (actual time=0.54..0.54 rows=0 loops=1)
                    Hash Cond: ("outer".tagid = "inner".tagid)
                    ->  Nested Loop  (cost=0.00..529.54 rows=3627 width=58) (actual time=0.12..0.12 rows=0 loops=1)
                          ->  Index Scan using xml_node_pkey on xml_node xn  (cost=0.00..3.01 rows=1 width=54) (actual time=0.03..0.03 rows=1 loops=1)
                                Index Cond: (id = 68393)
                          ->  Index Scan using xml_node_dewey on xml_node trg  (cost=0.00..463.06 rows=3626 width=58) (actual time=0.03..0.03 rows=0 loops=1)
                                Index Cond: ((trg.dewey > "outer".dewey) AND (trg.dewey < nextsibling("outer".dewey)))
                                Filter: (kind = 1::smallint)
                    ->  Hash  (cost=3.49..3.49 rows=46 width=12) (actual time=0.37..0.37 rows=0 loops=1)
                          ->  Index Scan using xml_tag_pkey on xml_tag xt  (cost=0.00..3.49 rows=46 width=12) (actual time=0.03..0.27 rows=46 loops=1)
        ->  Subquery Scan "*SELECT* 2"  (cost=6.75..509.50 rows=273 width=402) (actual time=0.24..0.24 rows=0 loops=1)
              ->  Hash Left Join  (cost=6.75..506.77 rows=273 width=402) (actual time=0.23..0.23 rows=0 loops=1)
                    Hash Cond: ("outer".tagid = "inner".tagid)
                    ->  Hash Left Join  (cost=3.07..494.89 rows=273 width=374) (actual time=0.19..0.19 rows=0 loops=1)
                          Hash Cond: ("outer".tagid = "inner".tagid)
                          ->  Nested Loop  (cost=0.00..489.42 rows=273 width=365) (actual time=0.09..0.09 rows=0 loops=1)
                                ->  Index Scan using xml_node_pkey on xml_node xn  (cost=0.00..3.01 rows=1 width=54) (actual time=0.02..0.02 rows=1 loops=1)
                                      Index Cond: (id = 68393)
                                ->  Index Scan using xml_node_dewey on xml_node trg  (cost=0.00..481.64 rows=272 width=365) (actual time=0.02..0.02 rows=0 loops=1)
                                      Index Cond: ((trg.dewey > "outer".dewey) AND (trg.dewey < nextsibling("outer".dewey)))
                                      Filter: ((kind = 5::smallint) OR (kind = 6::smallint))
                          ->  Hash  (cost=3.05..3.05 rows=5 width=13) (actual time=0.07..0.07 rows=0 loops=1)
                                ->  Index Scan using xml_attribute_pkey on xml_attribute xa  (cost=0.00..3.05 rows=5 width=13) (actual time=0.02..0.04 rows=5 loops=1)
                    ->  Hash  (cost=3.68..3.68 rows=1 width=36) (actual time=0.01..0.01 rows=0 loops=1)
                          ->  Index Scan using xml_namespace_pkey on xml_namespace ns  (cost=0.00..3.68 rows=1 width=36) (actual time=0.01..0.01 rows=0 loops=1)
        ->  Subquery Scan "*SELECT* 3"  (cost=0.00..574.87 rows=3627 width=54) (actual time=0.08..0.08 rows=0 loops=1)
              ->  Nested Loop  (cost=0.00..538.60 rows=3627 width=54) (actual time=0.07..0.07 rows=0 loops=1)
                    ->  Index Scan using xml_node_pkey on xml_node xn  (cost=0.00..3.01 rows=1 width=54) (actual time=0.01..0.02 rows=1 loops=1)
                          Index Cond: (id = 68393)
                    ->  Index Scan using xml_node_dewey on xml_node trg  (cost=0.00..463.06 rows=3626 width=54) (actual time=0.02..0.02 rows=0 loops=1)
                          Index Cond: ((trg.dewey > "outer".dewey) AND (trg.dewey < nextsibling("outer".dewey)))
                          Filter: (kind = 1::smallint)
        ->  Subquery Scan "*SELECT* 4"  (cost=3.68..683.65 rows=3533 width=393) (actual time=0.13..0.13 rows=0 loops=1)
              ->  Hash Left Join  (cost=3.68..648.32 rows=3533 width=393) (actual time=0.13..0.13 rows=0 loops=1)
                    Hash Cond: ("outer".tagid = "inner".tagid)
                    ->  Nested Loop  (cost=0.00..565.04 rows=3533 width=365) (actual time=0.09..0.09 rows=0 loops=1)
                          ->  Index Scan using xml_node_pkey on xml_node xn  (cost=0.00..3.01 rows=1 width=54) (actual time=0.02..0.02 rows=1 loops=1)
                                Index Cond: (id = 68393)
                          ->  Index Scan using xml_node_dewey on xml_node trg  (cost=0.00..500.21 rows=3532 width=365) (actual time=0.02..0.02 rows=0 loops=1)
                                Index Cond: ((trg.dewey > "outer".dewey) AND (trg.dewey < nextsibling("outer".dewey)))
                                Filter: ((kind = 2::smallint) OR (kind = 3::smallint) OR (kind = 4::smallint))
                    ->  Hash  (cost=3.68..3.68 rows=1 width=36) (actual time=0.01..0.01 rows=0 loops=1)
                          ->  Index Scan using xml_pi_pkey on xml_pi pi  (cost=0.00..3.68 rows=1 width=36) (actual time=0.01..0.01 rows=0 loops=1)
        ->  Subquery Scan "*SELECT* 5"  (cost=3.60..603.61 rows=1903 width=62) (actual time=0.47..0.47 rows=0 loops=1)
              ->  Hash Join  (cost=3.60..584.58 rows=1903 width=62) (actual time=0.47..0.47 rows=0 loops=1)
                    Hash Cond: ("outer".tagid = "inner".tagid)
                    ->  Nested Loop  (cost=0.00..529.54 rows=3627 width=58) (actual time=0.08..0.08 rows=0 loops=1)
                          ->  Index Scan using xml_node_pkey on xml_node xn  (cost=0.00..3.01 rows=1 width=54) (actual time=0.01..0.02 rows=1 loops=1)
                                Index Cond: (id = 68393)
                          ->  Index Scan using xml_node_dewey on xml_node trg  (cost=0.00..463.06 rows=3626 width=58) (actual time=0.02..0.02 rows=0 loops=1)
                                Index Cond: ((trg.dewey > "outer".dewey) AND (trg.dewey < nextsibling("outer".dewey)))
                                Filter: (kind = 1::smallint)
                    ->  Hash  (cost=3.49..3.49 rows=46 width=12) (actual time=0.35..0.35 rows=0 loops=1)
                          ->  Index Scan using xml_tag_pkey on xml_tag xt  (cost=0.00..3.49 rows=46 width=12) (actual time=0.02..0.25 rows=46 loops=1)
Total runtime: 2.96 msec

ͻ:
	ViewѤ뤳ȤǡƱɾʬʣɾʤ褦ưԤ
	ޤǺŬȤϤʤä