/**
 - gc_cmd.sql,v 1.1 2003/07/17 14:10:45 myui Exp
 */

-- WARNING
-- once you run garbage collector, you may not update the document.
-- because pathexp may change the value in spite of relation with other pathid(s).

-- Garbage Collection

DELETE FROM
    xml_path
WHERE
    pathid in (SELECT
                    pathid
               FROM
                    xml_path
               WHERE
               		pathid != 0
               EXCEPT
               SELECT
                    pathid
               FROM
                    xml_node
               );

/*

/** Better way for PostgreSQL 7.3.x. **/
-- above command is a little bit faster than follows in 7.4 beta,
-- but it's not true in 7.3.x.
-- Thanks reports. T.Ishikawa.

CREATE OR REPLACE FUNCTION gc_pathexp_preprocess() RETURNS BOOL AS '
DECLARE
    mviews RECORD;
    dc integer;
BEGIN
    RAISE NOTICE ''[gc_pathexp_preprocess] start'';
    dc := 0;
    FOR mviews IN
               SELECT pathid FROM xml_path WHERE pathid != 0
               EXCEPT
               SELECT distinct(pathid) FROM xml_node
    loop
        delete from xml_path where pathid=mviews.pathid;
        dc := dc + 1;
        -- raise notice ''delete from xml_path where pathid=%;'' , mviews.pathid;
    end loop;
    RAISE NOTICE ''[gc_pathexp_preprocess] finish (% deleted)'', dc;
    return TRUE;
end;
' LANGUAGE 'plpgsql';

select gc_pathexp_preprocess();
*/

DROP TRIGGER trg_xorder ON xml_node;

select gc_pathexp();

CREATE TRIGGER trg_xorder AFTER UPDATE
    ON "xml_node" FOR EACH ROW
    EXECUTE PROCEDURE trg_xorder();
