#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# chart of accounts
#
# CHANGE LOG:
#   DS. 2000-07-04  Created
#
#======================================================================


package CA;


sub all_accounts {
  my ($self, $myconfig, $form) = @_;

  my $amount = ();
  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query = qq|SELECT accno,
                 SUM(acc_trans.amount) AS amount
                 FROM chart, acc_trans
		 WHERE chart.id = acc_trans.chart_id
		 GROUP BY accno|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    $amount{$ref->{accno}} = $ref->{amount}
  }
  $sth->finish;
 
  $query = qq|SELECT accno, description
              FROM gifi|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $gifi = ();
  while (my ($accno, $description) = $sth->fetchrow_array) {
    $gifi{$accno} = $description;
  }
  $sth->finish;

  $query = qq|SELECT c.id, c.accno, c.description, c.charttype, c.gifi_accno,
              c.category, c.link
              FROM chart c
	      ORDER BY accno|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
 
  while (my $ca = $sth->fetchrow_hashref(NAME_lc)) {
    $ca->{amount} = $amount{$ca->{accno}};
    $ca->{gifi_description} = $gifi{$ca->{gifi_accno}};
    if ($ca->{amount} < 0) {
      $ca->{debit} = $ca->{amount} * -1;
    } else {
      $ca->{credit} = $ca->{amount};
    }
    push @{ $form->{CA} }, $ca;
  }

  $sth->finish;
  $dbh->disconnect;

}


sub all_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get chart_id
  my $query = qq|SELECT id FROM chart
                 WHERE accno = '$form->{accno}'|;
  if ($form->{accounttype} eq 'gifi') {
    $query = qq|SELECT id FROM chart
                WHERE gifi_accno = '$form->{gifi_accno}'|;
  }
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my @id = ();
  while (my ($id) = $sth->fetchrow_array) {
    push @id, $id;
  }

  $sth->finish;

  my $where = '1 = 1';
  my $where1 = '1 = 1';
  my $where2 = '1 = 1';
  # build WHERE clause from dates if any
  if ($form->{fromdate}) {
    $where .= " AND acc_trans.transdate >= '$form->{fromdate}'";
    $where1 .= " AND gp_trans.transdate >= '$form->{fromdate}'";
    $where2 .= " AND ou_trans.transdate >= '$form->{fromdate}'";
  }
  if ($form->{todate}) {
    $where .= " AND acc_trans.transdate <= '$form->{todate}'";
    $where1 .= " AND gp_trans.transdate <= '$form->{todate}'";
    $where2 .= " AND ou_trans.transdate <= '$form->{todate}'";
  }

    if ($form->{project}) {
    $where .= " AND acc_trans.project = '$form->{project}'";
    $where1 .= " AND gp.project = '$form->{project}'";
    $where2 .= " AND ou.project = '$form->{project}'";
  }
  if ($form->{sub}) {
    $where .= " AND acc_trans.sub = '$form->{sub}'";
    $where1 .= " AND gp.sub = '$form->{sub}'";
    $where2 .= " AND ou.sub = '$form->{sub}'";
  }
  
  my $sortorder = join ', ', $form->sort_columns(qw(transdate source description));
  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  # Oracle workaround, use ordinal positions
  my %ordinal = ( transdate => 4,
                  source => 2,
		  description => 3 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  
      #adjust here
  $query = "";
  foreach my $id (@id) {
  #need to adjust here
    # get all transactions
    $query .= qq|
      SELECT gl.id, gl.source, gl.description, acc_trans.transdate,
		$false AS invoice,
		acc_trans.amount, 'gl' as charttype
		FROM gl, acc_trans
		WHERE $where
		AND acc_trans.chart_id = $id
		AND acc_trans.trans_id = gl.id
      UNION ALL
      SELECT ar.id, ar.invnumber, customer.name, acc_trans.transdate,
		ar.invoice,
		acc_trans.amount, 'ar' as charttype
		FROM ar, acc_trans,customer
		WHERE $where
		AND acc_trans.chart_id = $id
		AND acc_trans.trans_id = ar.id
		AND ar.customer_id = customer.id
      UNION ALL
      SELECT ap.id, ap.invnumber, vendor.name, acc_trans.transdate,
		ap.invoice,
		acc_trans.amount, 'ap' as charttype
		FROM ap, acc_trans,vendor
		WHERE $where
		AND acc_trans.chart_id = $id
		AND acc_trans.trans_id = ap.id
		AND ap.vendor_id = vendor.id
      UNION ALL      
      SELECT debitnote.id, debitnote.ordnumber, vendor.name, acc_trans.transdate,
		invoice AS invoice,
		acc_trans.amount, 'dbv' as charttype
		FROM debitnote, acc_trans,vendor
		WHERE $where
		AND acc_trans.chart_id = $id
		AND acc_trans.trans_id = debitnote.id
		AND debitnote.vendor_id = vendor.id
		AND customer_id =0
      UNION ALL
     SELECT debitnote.id, debitnote.ordnumber, customer.name, acc_trans.transdate,
		invoice AS invoice,
		acc_trans.amount, 'dbc' as charttype
		FROM debitnote, acc_trans,customer
		WHERE $where
		AND acc_trans.chart_id = $id
		AND acc_trans.trans_id = debitnote.id
		AND debitnote.customer_id = customer.id
		AND vendor_id =0
      UNION ALL
           SELECT creditnote.id, creditnote.ordnumber, vendor.name, acc_trans.transdate,
		invoice AS invoice,
		acc_trans.amount, 'cnv' as charttype
		FROM creditnote, acc_trans,vendor
		WHERE $where
		AND acc_trans.chart_id = $id
		AND acc_trans.trans_id = creditnote.id
		AND creditnote.vendor_id = vendor.id
		AND customer_id =0
      UNION ALL
     SELECT creditnote.id, creditnote.ordnumber, customer.name, acc_trans.transdate,
		invoice AS invoice,
		acc_trans.amount, 'cnc' as charttype
		FROM creditnote, acc_trans,customer
		WHERE $where
		AND acc_trans.chart_id = $id
		AND acc_trans.trans_id = creditnote.id
		AND creditnote.customer_id = customer.id
		AND vendor_id =0
     UNION ALL
     SELECT gp.id, gp_trans.source, gp_trans.description, gp_trans.transdate,
		$false AS invoice,
		gp_trans.amount, 'gp' as charttype
		FROM gp, gp_trans
		WHERE $where1
		AND gp_trans.chart_id = $id
		AND gp_trans.id = gp.id
     UNION ALL
     SELECT ou.id, ou_trans.source, ou_trans.description, ou_trans.transdate,
		$false AS invoice,
		ou_trans.amount, 'ou' as charttype
		FROM ou, ou_trans
		WHERE $where2
		AND ou_trans.chart_id = $id
		AND ou_trans.id = ou.id


      UNION ALL|;
  }

  $query =~ s/UNION ALL$//;
  $query .= qq|
      ORDER BY $sortorder|;

  #$form->dberror($query);

  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
 #$form->dberror($query);
  while (my $ca = $sth->fetchrow_hashref(NAME_lc)) {

    # adjust here debitnote
    if ($ca->{charttype} eq "dbv") {
      if($ca->{invoice}){
      		$ca->{module} = "debitnote";
      }else{
	      $ca->{module} = "debitnote2";

      }
      $ca->{vc} = "vendor";
      $ca->{type}="purchase_order";
    }
    if ($ca->{charttype} eq "dbc") {
      if($ca->{invoice}){
      		$ca->{module} = "debitnote";
      }else{
	      $ca->{module} = "debitnote2";

      }
      $ca->{vc} = "customer";
      $ca->{type}="sales_order";
    }
   if ($ca->{charttype} eq "cnv") {
      if($ca->{invoice}){
      		$ca->{module} = "creditnote";
      }else{
	      $ca->{module} = "creditnote2";

      }
      $ca->{vc} = "vendor";
      $ca->{type}="purchase_order";
    }
    if ($ca->{charttype} eq "cnc") {
      if($ca->{invoice}){
      		$ca->{module} = "creditnote";
      }else{
	      $ca->{module} = "creditnote2";

      }
      $ca->{vc} = "customer";
      $ca->{type}="sales_order";
    }
    # gl
    if ($ca->{charttype} eq "gl") {
      $ca->{module} = "gl";
    }

        if ($ca->{charttype} eq "gp") {
      $ca->{module} = "dataentry2";
    }

        if ($ca->{charttype} eq "ou") {
      $ca->{module} = "dataentry3";
    }

    # ap
    if ($ca->{charttype} eq "ap") {
      $ca->{module} = ($ca->{invoice}) ? 'ir' : 'ap';
    }

    # ar
    if ($ca->{charttype} eq "ar") {
      $ca->{module} = ($ca->{invoice}) ? 'is' : 'ar';
    }

    if ($ca->{amount} < 0) {
      $ca->{debit} = $ca->{amount} * -1;
      $ca->{credit} = 0;
    } else {
      $ca->{debit} = 0;
      $ca->{credit} = $ca->{amount};
    }

    push @{ $form->{CA} }, $ca;

  }
 
  $sth->finish;
  $dbh->disconnect;

}

1;

