#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Order entry module
#
#======================================================================

package OE;


sub transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);
 
  my $query;

  my $query = qq|SELECT o.id, o.ordnumber, o.transdate, o.reqdate,
                 o.amount, ct.name, o.netamount, o.$form->{vc}_id,status,yourref
	         FROM oe o, $form->{vc} ct
	         WHERE o.$form->{vc}_id = ct.id|;
	      
  my $ordnumber = $form->like(lc $form->{ordnumber});

  my $sortorder = join ', ', $form->sort_columns(qw(transdate ordnumber name));
  $sortorder = $form->{sort} unless $sortorder;
  
  $query .= " AND lower(ordnumber) LIKE '$ordnumber'" if $form->{ordnumber};
  $query .= qq| AND $form->{vc}_id = $form->{"$form->{vc}_id"}| if ($form->{"$form->{vc}_id"});
  $query .= " AND transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND transdate <= '$form->{transdateto}'" if $form->{transdateto};
 $query .= " AND transtype = '$form->{transtype}'" if $form->{transtype};
 $query .= " AND status = '$form->{status}'" if $form->{status};
   $query .= " ORDER by $sortorder";
  
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $oe = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{OE} }, $oe;
  }

  $sth->finish;
  $dbh->disconnect;
  
}

sub last_invoice {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get rest for the customer
  my $query = qq|select lastinvnumber from (SELECT id,ordnumber as lastinvnumber
	         FROM oe 
	         WHERE $form->{vc}_id > 0 and transtype='$form->{transtype}' order by id desc limit 2) as foo order by id DESC|;
  my $sth = $dbh->prepare($query);
  #$form->dberror($query);
  $sth->execute || $form->dberror($query);

  $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;

  $sth->finish;
  $dbh->disconnect;

}

sub save_order {
  my ($self, $myconfig, $form) = @_;

  # connect to database, turn off autocommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  my ($query, $uid, $sth);
  my $exchangerate = 0;

  if ($form->{id}) {

    $query = qq|DELETE FROM orderitems
                WHERE trans_id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query);   

  } else {
    # create OE entry
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO oe (ordnumber, employee_id)
                VALUES ('$uid',
		(SELECT id FROM employee WHERE login = '$form->{login}'))|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    # retrieve id
    $query = qq|SELECT id FROM oe WHERE ordnumber = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $sth->finish;
  }

  map { $form->{$_} =~ s/'/\\'/g } qw(ordnumber);

  my ($amount, $linetotal, $discount, $taxrate, $taxbase, $taxamount, $fxsellprice);
  my ($netamount, $tax) = (0, 0);

  for my $i (1 .. $form->{rowcount}) {

    $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});

    if ($form->{"qty_$i"} != 0) {

      map { $form->{"${_}_$i"} =~ s/'/\\'/g } qw(partnumber description unit);

      # set values to 0 if nothing entered
      $form->{"discount_$i"} = $form->parse_amount($myconfig, $form->{"discount_$i"}) / 100;

      $form->{"sellprice_$i"} = $form->parse_amount($myconfig, $form->{"sellprice_$i"});
      $fxsellprice = $form->{"sellprice_$i"};

      my ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      my $decimalplaces = ($dec > 2) ? $dec : 2;

      $discount = $form->round_amount($form->{"sellprice_$i"} * $form->{"discount_$i"}, $decimalplaces);
      $form->{"sellprice_$i"} = $form->round_amount($form->{"sellprice_$i"} - $discount, $decimalplaces);

      $form->{"inventory_accno_$i"} *= 1;
      $form->{"expense_accno_$i"} *= 1;

      $linetotal = $form->round_amount($form->{"sellprice_$i"} * $form->{"qty_$i"}, 2);
      $taxrate = 0;
      map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};

      if ($form->{"taxincluded_$i"}) {
	$taxamount = $linetotal * $taxrate / (1 + $taxrate);
	$taxbase = $linetotal - $taxamount;
	# we are not keeping a natural price, do not round
	$form->{"sellprice_$i"} = $form->{"sellprice_$i"} * (1 / (1 + $taxrate));
      } else {
	$taxamount = $linetotal * $taxrate;
	$taxbase = $linetotal;
      }

      if ($taxamount != 0) {
	foreach my $item (split / /, $form->{"taxaccounts_$i"}) {
	  $taxaccounts{$item} += $taxamount * $form->{"${item}_rate"} / $taxrate;
	  $taxbase{$item} += $taxbase;
	}
      }

      $netamount += $form->{"sellprice_$i"} * $form->{"qty_$i"};
$form->{"taxincluded_$i"}*=1;
      #/ save detail record in orderitems table
      $query = qq|INSERT INTO orderitems
		 (trans_id, parts_id, description, qty, sellprice, discount,
		  unit,delivery_date,remark2,taxincluded,tax) VALUES (
		  $form->{id}, $form->{"id_$i"}, '$form->{"description_$i"}',
		  $form->{"qty_$i"}, $fxsellprice, $form->{"discount_$i"},
		  '$form->{"unit_$i"}','$form->{"delivery_date_$i"}','$form->{"remark2_$i"}','$form->{"taxincluded_$i"}',$taxamount)|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


    }
  }


  # set values which could be empty
  $form->{vendor_id} *= 1;
  $form->{customer_id} *= 1;
  $form->{taxincluded} *= 1;

  my $reqdate = ($form->{reqdate}) ? qq|'$form->{reqdate}'| : "NULL";
  
  # add up the tax
  foreach my $item (sort keys %taxaccounts) {
    $tax += $taxaccounts{$item};
  }
  if(!$form->{taxincluded}){
      foreach my $item (split / /, $form->{taxaccounts_vc}) {
	  $amount = $netamount + $tax;
	  $tax +=	  $amount* $form->{"${item}_rate"} ;
	#/  $taxbase{$item} += $taxbase;

  #$form->dberror(($netamount + $tax)* $form->{"${item}_rate"}); 

    }      

  }

  $amount = $form->round_amount($netamount + $tax, 2);
  $netamount = $form->round_amount($netamount, 2);

  
  
  if ($form->{currency} eq $form->{defaultcurrency}) {
    $form->{exchangerate} = 1;
  } else {
    $exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{transdate}, ($form->{vc} eq 'customer') ? 'buy' : 'sell');
  }
  
  $form->{exchangerate} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{exchangerate});
  
  
  # save OE record
  $query = qq|UPDATE oe set
	      transtype = '$form->{transtype}',
	      ordnumber = '$form->{ordnumber}',
              transdate = '$form->{orddate}',
              vendor_id = $form->{vendor_id},
	      customer_id = $form->{customer_id},
              amount = $amount,
              netamount = $netamount,
	      reqdate = $reqdate,
	      taxincluded = '$form->{taxincluded}',
	      shippingpoint = '$form->{shippingpoint}',
	      notes = '$form->{notes}',
	      yourref = '$form->{yourref}',
	      status = $form->{status},
	      curr = '$form->{currency}'
              WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


  if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
    if ($form->{vc} eq 'customer') {
      $form->update_exchangerate($dbh, $form->{currency}, $form->{orddate}, $form->{exchangerate}, 0);
    }
    if ($form->{vc} eq 'vendor') {
      $form->update_exchangerate($dbh, $form->{currency}, $form->{orddate}, 0, $form->{exchangerate});
    }
  }
  
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}



sub delete_order {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my $query;

  # can't use $form->delete_exchangerate
  if ($form->{currency} ne $form->{defaultcurrency}) {
       $query = qq|SELECT transdate FROM acc_trans
		   WHERE ar.id = trans_id
		   AND ar.curr = '$form->{currency}'
		   AND transdate = '$form->{orddate}'
	   UNION SELECT transdate FROM acc_trans
		   WHERE ap.id = trans_id
		   AND ap.curr = '$form->{currency}'
		   AND transdate = '$form->{orddate}'|;
    my $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
    
    my ($transdate) = $sth->fetchrow_array;
    $sth->finish;

    if (!$transdate) {
      $query = qq|DELETE FROM exchangerate
		  WHERE curr = '$form->{currency}'
		  AND transdate = '$form->{orddate}'|;
      $dbh->do($query) || $self->dberror($query);
    }
  }
	      
  
  # delete OE record
  $query = qq|DELETE FROM oe
              WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  # delete individual entries
  $query = qq|DELETE FROM orderitems
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}



sub retrieve_order {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my $query;

  if ($form->{id}) {
    # get default accounts and last order number
    $query = qq|SELECT (SELECT c.accno FROM chart c
                        WHERE d.inventory_accno_id = c.id) AS inventory_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.income_accno_id = c.id) AS income_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.expense_accno_id = c.id) AS expense_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxloss_accno_id = c.id) AS fxloss_accno,
                d.curr AS currencies
	 	FROM defaults d|;
  } else {
    my $ordnumber = ($form->{vc} eq 'customer') ? 'sonumber' : 'ponumber';
    $query = qq|SELECT (SELECT c.accno FROM chart c
                        WHERE d.inventory_accno_id = c.id) AS inventory_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.income_accno_id = c.id) AS income_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.expense_accno_id = c.id) AS expense_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxloss_accno_id = c.id) AS fxloss_accno,
                "$ordnumber" AS ordnumber, d.curr AS currencies,
		current_date AS orddate, current_date AS reqdate
	 	FROM defaults d|;
  }
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;
  $sth->finish;

  if ($form->{id}) {

    $query = qq|SELECT $form->{vc}_id
                FROM oe
		WHERE id = $form->{id}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    if ($form->{vc} eq 'vendor') {
      use SL::IR;
      ($form->{vendor_id}) = $sth->fetchrow_array;
      IR->get_vendor($myconfig, $form);
    }
    if ($form->{vc} eq 'customer') {
      use SL::IS;
      ($form->{customer_id}) = $sth->fetchrow_array;
      IS->get_customer($myconfig, $form);
    }
    $sth->finish;

    # retrieve order
    $query = qq|SELECT ordnumber, transdate AS orddate, reqdate,transtype,
                taxincluded, shippingpoint, notes, curr AS currency,yourref,status
		FROM oe
		WHERE id = $form->{id}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    $ref = $sth->fetchrow_hashref(NAME_lc);
    map { $form->{$_} = $ref->{$_} } keys %$ref;
    $sth->finish;

    my %oid = ( 'Pg'		=> 'oid',
                'Oracle'	=> 'rowid',
                'DB2'		=> '' );

    # retrieve individual items
    $query = qq|SELECT (SELECT c.accno FROM chart c
                       WHERE p.inventory_accno_id = c.id)
                       AS inventory_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.income_accno_id = c.id)
		       AS income_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.expense_accno_id = c.id)
		       AS expense_accno,
                p.partnumber, p.assembly, o.description, o.qty, o.sellprice,
		o.parts_id AS id, o.unit, o.discount, p.bin,o.delivery_Date,o.remark2
		FROM orderitems o, parts p
		WHERE o.parts_id = p.id
		AND trans_id = $form->{id}
                ORDER BY o.$oid{$myconfig->{dbdriver}}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    while ($ref = $sth->fetchrow_hashref(NAME_lc)) {

      # get tax rates for part
      $query = qq|SELECT c.accno
                  FROM chart c, tax t, partstax pt
                  WHERE t.chart_id = pt.chart_id
	          AND pt.chart_id = c.id
	          AND pt.parts_id = $ref->{id}|;
      my $pth = $dbh->prepare($query);
      $pth->execute || $form->dberror($query);

      $ref->{taxaccounts} = "";
      my $taxrate = 0;

      while (my $ptref = $pth->fetchrow_hashref(NAME_lc)) {
        $ref->{taxaccounts} .= "$ptref->{accno} ";
        $taxrate += $form->{"$ptref->{accno}_rate"};
      }
      $pth->finish;
      chop $ref->{taxaccounts};

      push @{ $form->{order_details} }, $ref;

    }
    $sth->finish;

    $form->{exchangerate} = $form->get_exchangerate($dbh, $form->{currency}, $form->{orddate}, ($form->{vc} eq 'customer') ? "buy" : "sell");

  } else {

    my $ordnumber = ($form->{vc} eq 'customer') ? 'sonumber' : 'ponumber';
    # up order number by 1
    $form->{ordnumber}++;

    # save the new number
    $query = qq|UPDATE defaults
                SET "$ordnumber" = '$form->{ordnumber}'|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  }

  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}



sub order_details {
  my ($self, $myconfig, $form) = @_;

  my $tax = 0;

  foreach my $i (1 .. $form->{rowcount}) {
    $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});

    if ($form->{"qty_$i"} != 0) {

      # add number, description and qty to $form->{number}, ....
      push(@{ $form->{runningnumber} }, $i);
      push(@{ $form->{number} }, qq|$form->{"partnumber_$i"}|);
      push(@{ $form->{description} }, qq|$form->{"description_$i"}|);
      push(@{ $form->{qty} }, $form->format_amount($myconfig, $form->{"qty_$i"}));
      push(@{ $form->{unit} }, qq|$form->{"unit_$i"}|);

      push(@{ $form->{sellprice} }, $form->{"sellprice_$i"});
      push(@{ $form->{delivery_date} }, $form->{"delivery_date_$i"});

      my $sellprice = $form->parse_amount($myconfig, $form->{"sellprice_$i"});
      my ($dec) = ($sellprice =~ /\.(\d+)/);
      $dec = length $dec;
      my $decimalplaces = ($dec > 2) ? $dec : 2;

      my $discount = $form->round_amount($sellprice * $form->parse_amount($myconfig, $form->{"discount_$i"}) / 100, $decimalplaces);

      # keep a netprice as well, (sellprice - discount)
      $form->{"netprice_$i"} = $sellprice - $discount;

      my $linetotal = $form->round_amount($form->{"qty_$i"} * $form->{"netprice_$i"}, 2);

      push(@{ $form->{netprice} }, ($form->{"netprice_$i"} != 0) ? $form->format_amount($myconfig, $form->{"netprice_$i"}, $decimalplaces) : " ");

      $discount = ($discount != 0) ? $form->format_amount($myconfig, $discount * -1, $decimalplaces) : " ";
      $linetotal = ($linetotal != 0) ? $linetotal : " ";

      push(@{ $form->{discount} }, $discount);

      $form->{ordtotal} += $linetotal;

      push(@{ $form->{linetotal} }, $form->format_amount($myconfig, $linetotal, 2));

      my ($taxamount, $taxbase);
      my $taxrate = 0;

      map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};

      if ($form->{taxincluded}) {
	# calculate tax
	$taxamount = $linetotal * $taxrate / (1 + $taxrate);
	$taxbase = $linetotal / (1 + $taxrate);
      } else {
        $taxamount = $linetotal * $taxrate;
	$taxbase = $linetotal;
      }


      if ($taxamount != 0) {
	foreach my $item (split / /, $form->{"taxaccounts_$i"}) {
	  $taxaccounts{$item} += $taxamount * $form->{"${item}_rate"} / $taxrate;
	  $taxbase{$item} += $taxbase;
	}
      }
    }
  }


  foreach my $item (sort keys %taxaccounts) {
    if ($form->round_amount($taxaccounts{$item}, 2) != 0) {
      push(@{ $form->{taxbase} }, $form->format_amount($myconfig, $taxbase{$item}, 2));
      $tax += $taxamount = $form->round_amount($taxaccounts{$item}, 2);
      push(@{ $form->{tax} }, $form->format_amount($myconfig, $taxamount, 2));
      push(@{ $form->{taxdescription} }, $form->{"${item}_description"});
      push(@{ $form->{taxrate} }, $form->format_amount($myconfig, $form->{"${item}_rate"} * 100));
      push(@{ $form->{taxnumber} }, $form->{"${item}_taxnumber"});
    }
  }

  $tax = 0 if $form->{taxincluded};
  $form->{subtotal} = $form->format_amount($myconfig, $form->{ordtotal}, 2);
  $form->{ordtotal} += $tax;


  # format amounts
  $form->{ordtotal} = $form->format_amount($myconfig, $form->{ordtotal}, 2, "-");

  # myconfig variables
  map { $form->{$_} = $myconfig->{$_} } (qw(company address tel fax signature businessnumber));
  $form->{username} = $myconfig->{name};

}


1;

