#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Order entry module
#
#======================================================================

package adjust;


sub transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query;

  my $query = qq|SELECT o.id, o.adnumber as ordnumber, o.transdate,type,
                 (select login from employee where id=employee_id) as login
	         FROM adjust o  where 1=1 
	         |;

  my $ordnumber = $form->like(lc $form->{ordnumber});

  my $sortorder = join ', ', $form->sort_columns(qw(transdate ordnumber ));
  $sortorder = $form->{sort} unless $sortorder;
  
  $query .= " AND lower(adnumber) LIKE '$ordnumber'" if $form->{ordnumber};
  #$query .= qq| AND $form->{vc}_id = $form->{"$form->{vc}_id"}| if ($form->{"$form->{vc}_id"});
  $query .= " AND transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND transdate <= '$form->{transdateto}'" if $form->{transdateto};
  $query .= " ORDER by $sortorder";

 # $form->dberror($query);
  my $sth = $dbh->prepare($query);

  $sth->execute || $form->dberror($query);

  while (my $oe = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{OE} }, $oe;
  }

  $sth->finish;
  $dbh->disconnect;

}
sub last_invoice {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  # get rest for the customer
  my $query = qq|select lastinvnumber from (SELECT id,adnumber as lastinvnumber
	         FROM adjust 
	          order by id desc limit 2) as foo order by id DESC|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
# $form->dberror($query);
  $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;

  $sth->finish;
  $dbh->disconnect;

}

sub transactions2 {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query;

  my $query = qq|SELECT o.id, o.adnumber as ordnumber, o.transdate,oe.qty,oe.sellprice,oe.description,p.partnumber,type,
                 (select login from employee where id=employee_id) as login
	         FROM adjust o,adjustitems oe ,parts p  where 1=1 and o.id=oe.trans_id and p.id=oe.parts_id
	         |;

  my $ordnumber = $form->like(lc $form->{ordnumber});

  my $sortorder = join ', ', $form->sort_columns(qw(transdate ordnumber ));
  $sortorder = $form->{sort} unless $sortorder;

  $query .= " AND lower(adnumber) LIKE '$ordnumber'" if $form->{ordnumber};
   $query .= " AND lower(p.partnumber) LIKE lower('$form->{partnumber}%')" if $form->{partnumber};
 #$query .= qq| AND $form->{vc}_id = $form->{"$form->{vc}_id"}| if ($form->{"$form->{vc}_id"});
  $query .= " AND transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND transdate <= '$form->{transdateto}'" if $form->{transdateto};
  $query .= " ORDER by $sortorder";

 # $form->dberror($query);
  my $sth = $dbh->prepare($query);

  $sth->execute || $form->dberror($query);

  while (my $oe = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{OE} }, $oe;
  }

  $sth->finish;
  $dbh->disconnect;

}
sub delete_invoice {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  # check for other foreign currency transactions
  $form->delete_exchangerate($dbh) if ($form->{currency} ne $form->{defaultcurrency});
 
  &reverse_invoice($dbh, $form,$myconfig->{dbname});
  
  # delete AR record
  my $query = qq|DELETE FROM adjust
                 WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

   my $query = qq|DELETE FROM invoice
                 WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}


sub reverse_invoice {
  my ($dbh, $form,$dbname) = @_;
  
  # reverse inventory items
  my $query = qq|SELECT  i.parts_id,
                 i.qty, false as assemblyitem, assembly,i.lastcost,inventory_accno_id
		 
                 FROM adjustitems i, parts p
		 WHERE i.parts_id = p.id
		 AND i.trans_id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
 # $form->dberror($query);
  
  


  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    if ($ref->{inventory_accno_id} || $ref->{assembly}) {
	####if adjust qty > 0
							$ref->{qty}*=-1;
 		if($ref->{qty} >0){
							  # if the invoice item is not an assemblyitem adjust parts onhand
							  unless ($ref->{assemblyitem}) {
							# adjust onhand in parts table
							$form->update_balance($dbh,
										  "parts",
										  "onhand",
										  qq|id = $ref->{parts_id}|,
										  $ref->{qty});
							  }
						
							  # loop if it is an assembly
							  next if ($ref->{assembly});
							  
							  # adjust allocated
							   $query = qq|SELECT id, trans_id, allocated
										  FROM invoice
								  WHERE parts_id = $ref->{parts_id}
								  AND allocated > 0
								  ORDER BY trans_id DESC|;
						 
						my $ith = $dbh->prepare($query);
							  $ith->execute || $form->dberror($query);
						#	  $form->dberror($query);
							  while (my $inhref = $ith->fetchrow_hashref(NAME_lc)) {
							  $qty = $ref->{qty};
							if (($ref->{qty} - $inhref->{allocated}) > 0) {
							  $qty = $inhref->{allocated};
							} #else {
							#}
					#	$form->dberror($qty."    ".$ref->{qty}."    ".$inhref->{allocated});
							#$qty -=$
							# update invoice
							$form->update_balance($dbh,
										  "invoice",
										  "allocated",
										  qq|id = $inhref->{id}|,
										  $qty *-1);
						
								last if (($ref->{qty} -= $qty) <= 0);
							  }
							  $ith->finish;
	###if adjust qty < 0
    }else{
										# update onhand
									  $form->update_balance($dbh,
												"parts",
												"onhand",
												qq|id = $ref->{parts_id}|,
												$ref->{qty});
								 
								
									
									  # if $ref->{allocated} > 0 than we sold that many items
									  if ($ref->{allocated} > 0) {
																
									# get references for sold items

									$query = qq|SELECT i.id, i.trans_id, i.allocated, a.transdate
												FROM invoice i, ar a
											WHERE i.parts_id = $ref->{parts_id}
											AND i.allocated < 0
											AND i.trans_id = a.id
											ORDER BY transdate DESC|;
									
											my $sth = $dbh->prepare($query);
									$sth->execute || $form->dberror($query);
								
									while ($pthref = $sth->fetchrow_hashref(NAME_lc)) {
									  my $qty = $ref->{allocated};
																				   
								
										if(($ref->{allocated}+$pthref->{allocated})>0){
										$qty=$pthref->{allocated}*-1
									  }
								
									  my $amount = $form->round_amount($ref->{sellprice} * $qty, 2);
									  
									  #adjust allocated
									  $form->update_balance($dbh,
												"invoice",
												"allocated",
												qq|id = $pthref->{id}|,
												$qty);
									  
								
									  last if (($ref->{allocated} -= $qty) <= 0);
									}
									$sth->finish;
									  }
	}
	}
	
	
  }
  
  $sth->finish;
  
  # delete acc_trans
 # $query = qq|DELETE FROM acc_trans
  #            WHERE trans_id = $form->{id}|;
 # $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$dbname,$query); 

  # delete invoice entries
  $query = qq|DELETE FROM adjustitems
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$dbname,$query); 

    # delete invoice entries
  $query = qq|DELETE FROM invoice
              WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$dbname,$query); 

  # $form->dberror($query);
}


sub save_order {
  my ($self, $myconfig, $form) = @_;
  
  # connect to database, turn off autocommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  my ($query, $uid, $sth);
  my $exchangerate = 0;

  if ($form->{id}) {
       &reverse_invoice($dbh, $form,$myconfig->{dbname});


  } else{
    # create OE entry
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO adjust (adnumber, employee_id)
                VALUES ('$uid',
		(SELECT id FROM employee WHERE login = '$form->{login}'))|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    # retrieve id
    $query = qq|SELECT id FROM adjust WHERE adnumber = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $sth->finish;
  }  

  map { $form->{$_} =~ s/'/\\'/g } qw(adnumber notes);
  
  my ($amount, $linetotal, $discount, $taxrate, $taxbase, $taxamount, $fxsellprice);
  my ($netamount, $tax) = (0, 0);

  for my $i (1 .. ($form->{rowcount}-1)) {
    
    $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});
    
    $form->{"sellprice_$i"} = $form->{"lastcost_$i"} if ($form->{"qty_$i"}  > 0);
    
   # if ($form->{"qty_$i"} != 0) {
      
      map { $form->{"${_}_$i"} =~ s/'/\\'/g } qw(partnumber description unit);
      
      # set values to 0 if nothing entered
      $form->{"discount_$i"} = $form->parse_amount($myconfig, $form->{"discount_$i"}) / 100;
      $form->{"lastcost_$i"} = $form->parse_amount($myconfig, $form->{"lastcost_$i"}) ;

      $form->{"sellprice_$i"} = $form->parse_amount($myconfig, $form->{"sellprice_$i"});
      $fxsellprice = $form->{"sellprice_$i"};

      my ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      my $decimalplaces = ($dec > 2) ? $dec : 2;


      
      $discount = $form->round_amount($form->{"sellprice_$i"} * $form->{"discount_$i"}, $decimalplaces);
      $form->{"sellprice_$i"} = $form->round_amount($form->{"sellprice_$i"} - $discount, $decimalplaces);
      
      $form->{"inventory_accno_$i"} *= 1;
      $form->{"expense_accno_$i"} *= 1;
      
      $linetotal = $form->round_amount($form->{"sellprice_$i"} * $form->{"qty_$i"}, 2);
      $taxrate = 0;
      map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{"taxaccounts_$i"};

      if ($form->{taxincluded}) {
	$taxamount = $linetotal * $taxrate / (1 + $taxrate);
	$taxbase = $linetotal - $taxamount;
	# we are not keeping a natural price, do not round
	$form->{"sellprice_$i"} = $form->{"sellprice_$i"} * (1 / (1 + $taxrate));
      } else {
	$taxamount = $linetotal * $taxrate;
	$taxbase = $linetotal;
      }

      if ($taxamount != 0) {
	foreach my $item (split / /, $form->{"taxaccounts_$i"}) {
	  $taxaccounts{$item} += $taxamount * $form->{"${item}_rate"} / $taxrate;
	  $taxbase{$item} += $taxbase;
	}
      }
      #/
      $netamount += $form->{"sellprice_$i"} * $form->{"qty_$i"};
       $qty = ($form->{"qty_$i"}) ? $form->{"qty_$i"} : 0;
if($qty != 0){
       if ($form->{"inventory_accno_$i"} || $form->{"assembly_$i"}) {
        # adjust parts onhand quantity, this should go into a trigger
	$form->update_balance($dbh,
			      "parts",
			      "onhand",
			      qq|id = $form->{"id_$i"}|,
			      $qty );
     $allocated=0;
    #     $form->dberror($qty."     ".$form->{"assembly_$i"});
  if($qty < 0){
    # if ($form->{"assembly_$i"}) {
	  # record assembly item as allocated
	#  &process_assembly($dbh, $form, $form->{"id_$i"}, $qty);
	#} else {
	  $allocated = &cogs($dbh, $form, $form->{"id_$i"}, $qty*-1);
	#}
  
  }
      }
      
      
         $query = qq|INSERT INTO invoice (trans_id, description, parts_id, qty,
                sellprice, fxsellprice, allocated, assemblyitem, unit)
		VALUES
		($form->{id}, '$form->{"description_$i"}',
		$form->{"id_$i"}, $qty*-1, $fxsellprice, $fxsellprice, $allocated, 'f',
		'$form->{"unit_$i"}')|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    
      # save detail record in orderitems table
      $query = qq|INSERT INTO adjustitems
		 (trans_id, parts_id, description, qty, sellprice,lastcost, discount,
		  unit) VALUES (
		  $form->{id}, $form->{"id_$i"}, '$form->{"description_$i"}',
		  $qty, $fxsellprice,$form->{"lastcost_$i"}, $form->{"discount_$i"},
		  '$form->{"unit_$i"}')|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


# if($form->{type} eq 'adjust'){
#    $query = qq|update parts set
#		 onhand=onhand+$qty,lastcost=$form->{"lastcost_$i"},sellprice=$fxsellprice
#		where id=$form->{"id_$i"}

#	|;
 #      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query);
  #    $form->dberror($query);
     
 #}       
   
  if($form->{type} eq 'os'){
    $query = qq|update parts set
		 onhand=$qty,lastcost=$form->{"lastcost_$i"},sellprice=$fxsellprice
		where id=$form->{"id_$i"}

	|;
       $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
 }          
}	#}
  }


  # set values which could be empty
  $form->{vendor_id} *= 1;
  $form->{customer_id} *= 1;
  $form->{taxincluded} *= 1;

  my $reqdate = ($form->{reqdate}) ? qq|'$form->{reqdate}'| : "NULL";
  
  # add up the tax
  foreach my $item (sort keys %taxaccounts) {
    $tax += $form->round_amount($taxaccounts{$item}, 2);
  }
  
  $amount = $form->round_amount($netamount + $tax, 2);
  $netamount = $form->round_amount($netamount, 2);

  if ($form->{currency} eq $form->{defaultcurrency}) {
    $form->{exchangerate} = 1;
  } else {
    $exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{transdate}, ($form->{vc} eq 'customer') ? 'buy' : 'sell');
  }
  
  $form->{exchangerate} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{exchangerate});
  

  # save OE record
  $query = qq|
              UPDATE adjust set
	      adnumber = '$form->{ordnumber}',
              transdate = '$form->{orddate}',
	      type='$form->{type}',
	      notes = '$form->{notes}'
              WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


  if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
    if ($form->{vc} eq 'customer') {
      $form->update_exchangerate($dbh, $form->{currency}, $form->{orddate}, $form->{exchangerate}, 0);
    }
    if ($form->{vc} eq 'vendor') {
      $form->update_exchangerate($dbh, $form->{currency}, $form->{orddate}, 0, $form->{exchangerate});
    }
  }
  
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}




sub cogs {
  my ($dbh, $form, $id, $totalqty) = @_;
    
  my $query = qq|SELECT i.id, i.qty, i.allocated, i.sellprice,
                        (SELECT c.accno FROM chart c
			 WHERE p.inventory_accno_id = c.id)
			 AS inventory_accno,
			(SELECT c.accno FROM chart c
			 WHERE p.income_accno_id = c.id)
			 AS income_accno,
			(SELECT c.accno FROM chart c
			 WHERE p.expense_accno_id = c.id)
			 AS expense_accno
		  FROM invoice i, parts p
		  WHERE i.parts_id = p.id
		  AND i.parts_id = $id

		  AND (i.qty + i.allocated) < 0
		  ORDER BY id|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $allocated = 0;
  my $qty;
  
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    if (($qty = (($ref->{qty} * -1) - $ref->{allocated})) > $totalqty) {
      $qty = $totalqty;
    }
    
    $form->update_balance($dbh,
			  "invoice",
			  "allocated",
			  qq|id = $ref->{id}|,
			  $qty);

    # total expenses and inventory
    # sellprice is the cost of the item
    $linetotal = $form->round_amount($ref->{sellprice} * $qty, 2);

    # add to expense
    $form->{amount}{$form->{id}}{$ref->{expense_accno}} += -$linetotal;

    # deduct inventory
    $form->{amount}{$form->{id}}{$ref->{inventory_accno}} -= -$linetotal;

    # add allocated
    $allocated += -$qty;

    last if (($totalqty -= $qty) <= 0);
  }

  $sth->finish;

  $allocated;
  
}



sub retrieve_order {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my $query;

  if ($form->{id}) {
    # get default accounts and last order number
    $query = qq|SELECT (SELECT c.accno FROM chart c
                        WHERE d.inventory_accno_id = c.id) AS inventory_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.income_accno_id = c.id) AS income_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.expense_accno_id = c.id) AS expense_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxloss_accno_id = c.id) AS fxloss_accno,
                d.curr AS currencies
	 	FROM defaults d|;
  } else {
   # my $ordnumber = ($form->{vc} eq 'customer') ? 'sonumber' : 'ponumber';
   $ordnumber = 'adnumber';

    $query = qq|SELECT (SELECT c.accno FROM chart c
                        WHERE d.inventory_accno_id = c.id) AS inventory_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.income_accno_id = c.id) AS income_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.expense_accno_id = c.id) AS expense_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
                       (SELECT c.accno FROM chart c
		        WHERE d.fxloss_accno_id = c.id) AS fxloss_accno,
                "$ordnumber" AS ordnumber, d.curr AS currencies,
		current_date AS orddate, current_date AS reqdate
	 	FROM defaults d|;
  }
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  my $ref = $sth->fetchrow_hashref(NAME_lc);
  map { $form->{$_} = $ref->{$_} } keys %$ref;
  $sth->finish;

  if ($form->{id}) {
    
   # $query = qq|SELECT $form->{vc}_id
   #             FROM adjust
#		WHERE id = $form->{id}|;
   # $sth = $dbh->prepare($query);
  # $sth->execute || $form->dberror($query);

   # if ($form->{vc} eq 'vendor') {
   #   use SL::IR;
   #   ($form->{vendor_id}) = $sth->fetchrow_array;
   #   IR->get_vendor($myconfig, $form);
  #  }
   # if ($form->{vc} eq 'customer') {
  #    use SL::IS;
  #    ($form->{customer_id}) = $sth->fetchrow_array;
  #    IS->get_customer($myconfig, $form);
 #   }
  #  $sth->finish;

    # retrieve order
    $query = qq|SELECT adnumber as ordnumber, transdate AS orddate,  notes,type
		FROM adjust
		WHERE id = $form->{id}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    $ref = $sth->fetchrow_hashref(NAME_lc);
    map { $form->{$_} = $ref->{$_} } keys %$ref;
    $sth->finish;
    
    my %oid = ( 'Pg'		=> 'oid',
                'Oracle'	=> 'rowid',
                'DB2'		=> '' );

    # retrieve individual items
    $query = qq|SELECT (SELECT c.accno FROM chart c
                       WHERE p.inventory_accno_id = c.id)
                       AS inventory_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.income_accno_id = c.id)
		       AS income_accno,
		       (SELECT c.accno FROM chart c
		       WHERE p.expense_accno_id = c.id)
		       AS expense_accno,
                p.partnumber, p.assembly, o.description, o.qty, o.sellprice ,o.lastcost,
		o.parts_id AS id,o.parts_id AS parts_id, o.unit, o.discount, p.bin
		FROM adjustitems o, parts p
		WHERE o.parts_id = p.id
		AND trans_id = $form->{id}
                ORDER BY o.$oid{$myconfig->{dbdriver}}|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    while ($ref = $sth->fetchrow_hashref(NAME_lc)) {
    $ref->{"sellprice"} = 0 if ($ref->{"qty"}  > 0);

      # get tax rates for part
      $query = qq|SELECT c.accno
                  FROM chart c, tax t, partstax pt
                  WHERE t.chart_id = pt.chart_id
	          AND pt.chart_id = c.id
	          AND pt.parts_id = $ref->{id}|;
      my $pth = $dbh->prepare($query);
      $pth->execute || $form->dberror($query);

      $ref->{taxaccounts} = "";
      my $taxrate = 0;
      
      while (my $ptref = $pth->fetchrow_hashref(NAME_lc)) {
        $ref->{taxaccounts} .= "$ptref->{accno} ";
        $taxrate += $form->{"$ptref->{accno}_rate"};
      }
      $pth->finish;
      chop $ref->{taxaccounts};

      push @{ $form->{order_details} }, $ref;
      
    }
    $sth->finish;

    $form->{exchangerate} = $form->get_exchangerate($dbh, $form->{currency}, $form->{orddate}, ($form->{vc} eq 'customer') ? "buy" : "sell");
    
  } else {

    #my $ordnumber = ($form->{vc} eq 'customer') ? 'sonumber' : 'ponumber';
    my $ordnumber = 'adnumber';
    # up order number by 1
    $form->{ordnumber}++;

    # save the new number
    $query = qq|UPDATE defaults
                SET "$ordnumber" = '$form->{ordnumber}'|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  
    

  }

      $query = qq|SELECT current_date AS transdate, current_date + 30 AS duedate,
                d.curr AS currencies, d.closedto, d.revtrans,
                  (SELECT c.accno FROM chart c
		   WHERE d.fxgain_accno_id = c.id) AS fxgain_accno,
                  (SELECT c.accno FROM chart c
		   WHERE d.fxloss_accno_id = c.id) AS fxloss_accno
		FROM defaults d|;
    $sth = $dbh->prepare($query);
    $sth->execute || $self->dberror($query);

    $ref = $sth->fetchrow_hashref(NAME_lc);
    map { $form->{$_} = $ref->{$_} } keys %$ref;
    $sth->finish;

  
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}






1;

