#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Accounts Receivables
#
#======================================================================


use SL::creditnote2;
use SL::IS;
use SL::IR;
use SL::GL;
1;
# end of main

# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub add {

   if ($form->{type} eq 'purchase_order') {
    $form->{title} = $locale->text('Credit Notes - Vendor');
    $form->{vc} = 'vendor';
  }
  if ($form->{type} eq 'sales_order') {
    $form->{title} = $locale->text('Credit Notes - Customer');
    $form->{vc} = 'customer';
  }
    $form->{callback} = "$form->{script}?action=add&path=$form->{path}&login=$form->{login}&password=$form->{password}&type=$form->{type}";

if($form->{transdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{transdate};
 }
  &create_links;
if($lastdate){
 $form->{transdate}=$lastdate;
$form->{batch}=$lastbatch;
}

  # lock the exchangerate field
  $form->{forex} = 1;
  $form->{"forex_1"} = 1;

  &display_form;

}


sub edit {
   if ($form->{vc} eq 'vendor') {
    $form->{title} = $locale->text('Edit Credit Notes - Vendor');
  }
  if ($form->{type} eq 'sales_order') {
    $form->{title} = $locale->text('Edit Credit Notes - Customer');
  }

 # $form->{title} = "Edit";

 &create_links;
  &display_form;

}


sub display_form {

  &form_header;
  &form_footer;

}


sub create_links {

  $form->create_links("AR", \%myconfig, $form->{vc});

  $taxincluded = $form->{taxincluded};

  # build the popup menus

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];

  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;

  # customers
  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    if ($ref->{id} == $form->{"$form->{vc}_id"}) {
      $form->{customer} = "$ref->{name}--$ref->{id}";
      $duedate = $form->{duedate};              # save duedate, we are using IS
      if($form->{vc} eq "customer"){
      	IS->get_customer(\%myconfig, \%$form);
      }else{
      	IR->get_vendor(\%myconfig, \%$form);

      }
      $form->{duedate} = $duedate;              # work-around
    }
    $form->{selectcustomer} .= "<option>$ref->{name}--$ref->{id}\n";
  }

  # forex
  $form->{forex} = $form->{exchangerate};

  foreach $key (keys %{ $form->{AR_links} }) {

    foreach $ref (@{ $form->{AR_links}{$key} }) {
      if ($key eq 'AR_tax') {
	$form->{"selectAR_tax_$ref->{accno}"} = "<option>$ref->{accno}--$ref->{description}\n";
	next;
      }
      $form->{"select$key"} .= "<option>$ref->{accno}--$ref->{description}\n";


    }

    # if there is a value we have an old entry
    # $i is only used for paid
    for $i (1 .. scalar @{ $form->{acc_trans}{$key} }) {
      if ($key eq "AR_paid") {
	$form->{"AR_paid_$i"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	# reverse paid
	$form->{"paid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{amount} * -1;
	$form->{"datepaid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{transdate};
	$form->{"source_$i"} = $form->{acc_trans}{$key}->[$i-1]->{source};

	if ($form->{"exchangerate_$i"} = $form->{acc_trans}{$key}->[$i-1]->{exchangerate}) {
	  $form->{"forex_$i"} = 1;
	} else {
	  $form->{"exchangerate_$i"} = 1;
	}

	$form->{paidaccounts}++;
      } else {

	$akey = $key;
	$akey =~ s/AR_//;
	
        if ($key eq "AR_tax") {

	  $form->{"${key}_$form->{acc_trans}{$key}->[$i-1]->{accno}"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	  $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"} = $form->round_amount($form->{acc_trans}{$key}->[$i-1]->{amount} / $form->{exchangerate}, 2);
	  $totaltax += $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"};
	} else {
	  $form->{$akey} = $form->round_amount($form->{acc_trans}{$key}->[0]->{amount} / $form->{exchangerate}, 2);
	  $form->{$key} = "$form->{acc_trans}{$key}->[0]->{accno}--$form->{acc_trans}{$key}->[0]->{description}";
	}
      }
    }
  }

  $form->{taxincluded} = $taxincluded if ($form->{id});
  $form->{paidaccounts} = 1 if not defined $form->{paidaccounts};

  $form->{invtotal} = $form->{amount} + $totaltax;
  # amount
  if ($form->{taxincluded}) {
    $form->{amount} += $totaltax;
  }

  $form->{locked} = ($form->datetonum($form->{transdate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));
  
}


sub form_header {

  $title = $form->{title};
  $form->{title} = $locale->text("$title");

  $form->{taxincluded} = ($form->{taxincluded}) ? "checked" : "";
  
# $locale->text('Add Accounts Receivables')
# $locale->text('Edit Accounts Receivables')

if($form->{transdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{transdate};
 }
 	creditnote2->transaction(\%myconfig, \%$form);
if($lastdate){
 $form->{transdate}=$lastdate;
$form->{batch}=$lastbatch;
}
	 $i = 1;

  my $chart_1;
  my $chart_2;

  foreach $ref (@{ $form->{GL} }) {
    $form->{"accno_$i"} = $ref->{accno};
	$i++;
  }

  foreach $item (split /\n/, $form->{chart}) {
    ($key, $value) = split /--/, $item;
  #  if ($key == $form->{"accno_1"}) {
  #    $chart_1 .= "<option selected>$key--$value\n";
  #  } else {
  #    $chart_1 .= "<option>$key--$value\n";
  #  }
	if($form->{"accno1_1"}){
		$form->{"accno_1"}=$form->{"accno1_1"} ;
	}

		if ($key == $form->{"accno_1"}) {
      			$chart_1 .= "<option selected>$key--$value\n";

   		} else {


			if($form->{"accno1_1"} eq ''){
					$chart_1 .= "<option>$key--$value\n";

			}else{
				if ($key =~ /^$form->{"accno1_2"}/){
					$chart_1 .= "<option>$key--$value\n";
				}
			}
		}
  }

  foreach $item (split /\n/, $form->{chart}) {
    ($key, $value) = split /--/, $item;
   # if ($key == $form->{"accno_2"}) {
   #   $chart_2 .= "<option selected>$key--$value\n";
   # } else {
   #   $chart_2 .= "<option>$key--$value\n";
   # }
	if($form->{"accno1_2"}){
		$form->{"accno_2"}=$form->{"accno1_2"} ;
	}

		if ($key == $form->{"accno_2"}) {
      			$chart_2 .= "<option selected>$key--$value\n";

   		} else {


			if($form->{"accno1_2"} eq ''){
					$chart_2 .= "<option>$key--$value\n";

			}else{
				if ($key =~ /^$form->{"accno1_2"}/){
					$chart_2 .= "<option>$key--$value\n";
				}
			}
		}
  }

  # set option selected
 # foreach $item (qw(AR AR_amount customer currency)) {
 #   $form->{"select$item"} =~ s/ selected//;
 #   $form->{"select$item"} =~ s/option>\Q$form->{$item}\E/option selected>$form->{$item}/;
 # }
  foreach $item (qw( AR_amount customer vendor currency)) {
    $form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option>\Q$form->{$item}\E/option selected>$form->{$item}/;
  }

  # format amounts
  $form->{amount} = $form->format_amount(\%myconfig, $form->{amount}, 2);
  $form->{exchangerate} = $form->format_amount(\%myconfig, $form->{exchangerate});

  $exchangerate = qq|&nbsp;|;
  if ($form->{currency} ne $form->{defaultcurrency}) {
    if ($form->{forex}) {
      $exchangerate = qq|<input type=hidden name=exchangerate value=$form->{exchangerate}>$form->{exchangerate}|;
    } else {
      $exchangerate = qq|<input name=exchangerate size=10 value=$form->{exchangerate}>|;
    }
  }
  $exchangerate .= qq|
<input type=hidden name=forex value=$form->{forex}>
|;
    
  if (($rows = $form->numtextrows($form->{notes}, 50)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea>|;


  $form->header;
  
  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<input type=hidden name=id value=$form->{id}>
<input type=hidden name=sort value=$form->{sort}>
<input type=hidden name=closedto value=$form->{closedto}>
<input type=hidden name=locked value=$form->{locked}>
<input type=hidden name=title value="$title">


<table border=1>
<tr class=listtop bgcolor=000000><th>
<font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>

<table>
<tr>
  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td><input name=transtype  size=4 value="$form->{transtype}">-<input name=batch size=6 value="$form->{batch}">-<input name=transno  size=4 value="$form->{transno}"><input name=subtransno  size=2 value="$form->{subtransno}"></td>
</tr>
<tr>

  <th align=right>|.$locale->text('Debit in').qq|</th>
  <td colspan=3><select name="accno_1">$chart_1</select><input name="accno1_1" size=20 value=$form->{"accno1_1"}></td>

  <input type=hidden name=selectAR value="$form->{selectAR}">
</tr>

<tr>

  <th align=right>|.$locale->text('Credit in').qq|</th>
  <td colspan=3><select name="accno_2">$chart_2</select><input name="accno1_2" size=20 value=$form->{"accno1_2"}></td>

  <input type=hidden name=selectAR value="$form->{selectAR}">
</tr>


<tr>

  <th align=right>|.$locale->text($form->{vc}).qq|</th>
  <td colspan=3><select name=customer>$form->{selectcustomer}</select></td>

  <input type=hidden name=selectcustomer value="$form->{selectcustomer}">
  <input type=hidden name=oldcustomer value="$form->{customer_id}">
  <input type=hidden name=terms value=$form->{terms}>
  <input type=hidden name=vc value=$form->{vc}>
</tr>

<tr>
|;

  if ($form->{taxaccounts}) {
    print qq|

  <th align=right>|.$locale->text('Tax Included').qq|</th>
  <td colspan=3><input name=taxincluded class=checkbox type=checkbox value=1 $form->{taxincluded}>
  <b>|.$locale->text('Credit Limit').qq|</b> $form->{creditlimit}
  <b>|.$locale->text('Remaining').qq|</b> $form->{creditremaining}
  </td>
|;

  } else {
    print qq|

  <th align=right>|.$locale->text('Credit Limit').qq|</th>
  <td colspan=3>
  $form->{creditlimit}
  <b>|.$locale->text('Remaining').qq|</b> $form->{creditremaining}
  </td>
|;

  }

print qq|
</tr>

<tr>

  <th align=right>|.$locale->text('Credit Number').qq|</th>
  <td><input name=ordnumber size=20 value="$form->{ordnumber}"></td>
  <th align=right>|.$locale->text('Order Number').qq|</th>
  <td><input name=ord2number size=20 value="$form->{ord2number}"></td>

</tr>


<tr>

  <th align=right>|.$locale->text('Invoice Date').qq|</th>
  <td><input name=transdate size=11 value=$form->{transdate} title="($myconfig{dateformat})"></td>
  <th align=right>|.$locale->text('Due Date').qq|</th>
  <td><input name=duedate size=11 value=$form->{duedate} title="($myconfig{dateformat})"></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Currency').qq|</th>
  <td><select name=currency>$form->{selectcurrency}</select></td>
  <th align=right>|.$locale->text('Exchangerate').qq|</th>
  <td>$exchangerate</td>

  <input type=hidden name=selectcurrency value="$form->{selectcurrency}">
  <input type=hidden name=defaultcurrency value=$form->{defaultcurrency}>
  <input type=hidden name=fxgain_accno value=$form->{fxgain_accno}>
  <input type=hidden name=fxloss_accno value=$form->{fxloss_accno}>
</tr>

<tr>

  <th align=right>|.$locale->text('Amount').qq|</th>
  <td><input name=amount size=10 value=$form->{amount}></td>
  <td colspan=2><select name=AR_amount>$form->{selectAR_amount}</select></td>

  <input type=hidden name=selectAR_amount value="$form->{selectAR_amount}">
</tr>

<input type=hidden name=taxaccounts value="$form->{taxaccounts}">
|;

  
  #$taxlabel = ($form->{taxincluded}) ? $locale->text('Tax Included') : $locale->text('Tax');

  
 # foreach $item (split / /, $form->{taxaccounts}) {

  #  $form->{"tax_$item"} = $form->format_amount(\%myconfig, $form->{"tax_$item"}, 2);
  #  print qq|
#<tr>

 # <th align=right>$taxlabel</th>
  #<td><input name="tax_$item" size=9 value=$form->{"tax_$item"}></td>
  #<td colspan=2><select name="AR_tax_$item">$form->{"selectAR_tax_$item"}</select></td>

#</tr>

#<input type=hidden name="${item}_rate" value="$form->{"${item}_rate"}">
#<input type=hidden name="${item}_description" value="$form->{"${item}_description"}">
#<input type=hidden name="selectAR_tax_$item" value="$form->{"selectAR_tax_$item"}">
#|;
  
 # }

  $form->{invtotal} = $form->format_amount(\%myconfig, $form->{invtotal}, 2);

  print qq|
<tr>

  <th align=right>|.$locale->text('Total').qq|</th>
  <td colspan=3>$form->{invtotal}</td>

</tr>

<tr>

  <th align=right>|.$locale->text('Notes').qq|</th>
  <td colspan=3>$notes</td>

</tr>

<tr>
  <td colspan=4>
    <table width=100%>
|;




  print qq|
    <input type=hidden name=paidaccounts value=$form->{paidaccounts}>
    <input type=hidden name=selectAR_paid value="$form->{selectAR_paid}">

    </table>
  </td>
  
</tr>
</table>

</td>
</tr>

|;

}


sub form_footer {

  print qq|

<input name=callback type=hidden value="$form->{callback}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=password value=$form->{password}>

</table>

<br>
|;

  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  
  if ($form->{id}) {
    
      print qq|<input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	<input class=submit type=submit name=action value="|.$locale->text('Post Transaction').qq|">
	<input class=submit type=submit name=action value="|.$locale->text('Delete Transaction').qq|">
|;
      }
    }

    if ($transdate > $closedto) {
      print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Post As New Transaction').qq|">
|;
    }

  } else {
    if ($transdate > $closedto) {
      print qq|<input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Post Transaction').qq|">|;
    }
  }

  print "</form>

</body>
</html>
";

}


sub update_form {

  # split customer
  ($null, $form->{customer_id}) = split /--/, $form->{customer};
  
  # recalculate form
  if ($form->{oldcustomer} != $form->{customer_id}) {
    IS->get_customer(\%myconfig, \%$form);
    
    $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0, "-");
    $form->{creditremaining} = $form->format_amount(\%myconfig, $form->{creditremaining}, 0, "-");

  }

  $form->{exchangerate} = $exchangerate if ($form->{forex} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{transdate}, 'buy')));

  # recalculate due date
  $form->{duedate} = $form->current_date(\%myconfig, $form->{transdate}, $form->{terms});

  map { $form->{$_} = $form->parse_amount(\%myconfig, $form->{$_}) } qw(amount exchangerate);

  # recalculate taxes
  if ($form->{taxincluded}) {
    $taxrate = 0;

    map { $taxrate += $form->{"${_}_rate"} } split / /, $form->{taxaccounts};

    foreach $item (split / /, $form->{taxaccounts}) {
      $form->{"tax_$item"} = $form->round_amount($form->{amount} * (1 - 1 / (1 + $taxrate)) * $form->{"${item}_rate"} / $taxrate, 2);
      $form->{"selectAR_tax_$item"} = qq|<option>$item--$form->{"${item}_description"}|;
      $totaltax += $form->{"tax_$item"};
    }
  } else {
    foreach $item (split / /, $form->{taxaccounts}) {
      $form->{"tax_$item"} = $form->{amount} * $form->{"${item}_rate"};
      $form->{"selectAR_tax_$item"} = qq|<option>$item--$form->{"${item}_description"}|;
      $totaltax += $form->{"tax_$item"};
    }
  }

  $form->{invtotal} = ($form->{taxincluded}) ? $form->{amount} : $form->{amount} + $totaltax;

  for $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"}) {
      map { $form->{"${_}_$i"} = $form->parse_amount(\%myconfig, $form->{"${_}_$i"}) } qw(paid exchangerate);

      $form->{"exchangerate_$i"} = $exchangerate if ($form->{"forex_$i"} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{"datepaid_$i"}, 'buy')));
    }
  }



 $form->create_links("AR", \%myconfig, "customer");
  foreach $key (keys %{ $form->{AR_links} }) {
    $form->{"selectAR"} ="";

    foreach $ref (@{ $form->{AR_links}{$key} }) {
      if ($key eq 'AR_tax') {
	$form->{"selectAR_tax_$ref->{accno}"} = "<option>$ref->{accno}--$ref->{description}\n";
	next;
      }
#      $form->{"select$key"} .= "<option>$ref->{accno}--$ref->{description}\n";

			if($form->{"accno1"} eq ''){
					$form->{"select$key"} .= "<option>$ref->{accno}--$ref->{description}\n";

			}else{
				if ($ref->{accno} =~ /^$form->{"accno1"}/){
					$form->{"select$key"} .= "<option>$ref->{accno}--$ref->{description}\n";
				}
			}

    }

    }

  &display_form;
  
}


sub post_transaction {

  # check if there is an invoice number, invoice and due date
  $form->isblank("ordnumber", $locale->text('Invoice Number missing!'));
  $form->isblank("transdate", $locale->text('Invoice Date missing!'));
  #$form->isblank("duedate", $locale->text('Due Date missing!'));

  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  
  $form->error($locale->text('Cannot post transaction for a closed period!')) if ($transdate <= $closedto);

  $form->isblank("exchangerate", $locale->text('Exchangerate missing!')) if ($form->{currency} ne $form->{defaultcurrency});

  for $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"}) {
      $datepaid = $form->datetonum($form->{"datepaid_$i"}, \%myconfig);
      
      $form->isblank("datepaid_$i", $locale->text('Payment date missing!'));

      $form->error($locale->text('Cannot post payment for a closed period!')) if ($datepaid <= $closedto);

      if ($form->{currency} ne $form->{defaultcurrency}) {
	$form->{"exchangerate_$i"} = $form->{exchangerate} if ($transdate == $datepaid);
	$form->isblank("exchangerate_$i", $locale->text('Exchangerate for payment missing!'));
      }
    }
  }

    
  # split customer
  ($null, $form->{customer_id}) = split /--/, $form->{customer};
  
  # recalculate form
  if ($form->{oldcustomer} != $form->{customer_id}) {
    IS->get_customer(\%myconfig, \%$form);
  }

  $form->isposted(creditnote2->post_transaction(\%myconfig, \%$form));

}


sub post_as_new_transaction {

  $form->{id} = 0;
  &post_transaction;

}


sub delete_transaction {

  $form->{title} = $locale->text('Confirm!');
  
  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  foreach $key (keys %$form) {
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>$form->{title}</font></h2>

<h4>|.$locale->text('Are you sure you want to delete Transaction').qq| $form->{ordnumber}</h4>

<input name=action class=submit type=submit value="|.$locale->text('Yes Delete Transaction').qq|">
</form>

</body>
</html>
|;

}



sub yes_delete_transaction {

  $form->isdeleted(creditnote2->delete_transaction(\%myconfig, \%$form));

}


sub search {
  
  # setup customer selection
  $form->all_vc(\%myconfig, "customer");
  
  $selection = "<option selected>" . $locale->text('All Customers') . "\n";
  
  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }
  

  if ($form->{nextsub} eq "payments") {
    $form->{title} = $locale->text('Process Payments');
    $listopen = qq|
    <input type=hidden name=sort value=ordnumber>
    <input type=hidden name=open value=Y>|;
  }
  if ($form->{nextsub} eq "ar_transactions") {
    $form->{title} = $locale->text('AR Transactions');
    $listopen = qq|
<input type=hidden name=sort value=transdate>

<tr>
  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
  <input name=open class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Open').qq|
  <input name=closed class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Closed').qq|
  
  <br>
  <input name="l_id" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('ID').qq|
  <input name="l_invnumber" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Invoice Number').qq|
  <input name="l_ordnumber" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Order Number').qq|
  <input name="l_transdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Invoice Date').qq|<br>
  <input name="l_name" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Customer').qq|
  <input name="l_netamount" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Amount').qq|
  <input name="l_tax" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Tax').qq|
  <input name="l_amount" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Total').qq|<br>
  <input name="l_datepaid" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Date Paid').qq|
  <input name="l_paid" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Paid').qq|
  <input name="l_duedate" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Due Date').qq|
  <input name="l_due" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Due').qq|
  <input name="l_notes" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Notes').qq|<br>
  <input name="l_subtotal" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Subtotal').qq|
  
</td>
</tr>
|;

  }
    
  $form->header;
  
  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>

<tr>

<th align=right>|.$locale->text('Customer').qq|</th>
<td colspan=3><select name=customer>$selection</select></td>

</tr>

<tr>

<th align=right>|.$locale->text('Invoice Number').qq|</th>
<td colspan=3><input name=ordnumber size=20></td>

</tr>

<tr>

<th align=right>|.$locale->text('Order Number').qq|</th>
<td colspan=3><input name=ordnumber size=20></td>

</tr>

<tr>

<th align=right>|.$locale->text('Notes').qq|</th>
<td colspan=3><input name=notes size=50></td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|<br>($myconfig{dateformat})</th>
<td><input name=transdatefrom size=11></td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input name=transdateto size=11></td>

</tr>

$listopen


</table>

</td></tr>
</table>

<input type=hidden name=nextsub value=$form->{nextsub}>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=password value=$form->{password}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">

</form>

<p>
|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;

}


sub continue {

  &{ $form->{nextsub} };

}


sub ar_transactions {

  # split customer
  ($customer, $form->{customer_id}) = split(/--/, $form->{customer});

  creditnote2->ar_transactions(\%myconfig, \%$form);

  # construct href
  $href = "$form->{script}?action=ar_transactions&ordnumber=".$form->escape($form->{ordnumber})."&ordnumber=".$form->escape($form->{ordnumber})."&notes=".$form->escape($form->{notes})."&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&closed=$form->{closed}&customer=".$form->escape($form->{customer})."&login=$form->{login}&password=$form->{password}&path=$form->{path}";
  
  # construct callback
  $customer = $form->{customer};
  $customer =~ s/&/_/g;
  $callback = "$form->{script}?action=ar_transactions&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&closed=$form->{closed}&login=$form->{login}&password=$form->{password}&path=$form->{path}&ordnumber=$form->{ordnumber}&ordnumber=$form->{ordnumber}&notes=$form->{notes}&customer=$customer";

  @columns = $form->sort_columns(qw(transdate id invnumber ordnumber name netamount tax amount paid datepaid due duedate notes));

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }
  

  $column_header{id} = "<th><a class=listheading href=$href&sort=id><font color=ffffff>".$locale->text('ID')."</font></a></th>";
  $column_header{transdate} = "<th><a class=listheading href=$href&sort=transdate><font color=ffffff>".$locale->text('Date')."</font></a></th>";
  $column_header{duedate} = "<th><a class=listheading href=$href&sort=duedate><font color=ffffff>".$locale->text('Due Date')."</font></a></th>";
  $column_header{invnumber} = "<th><a class=listheading href=$href&sort=invnumber><font color=ffffff>".$locale->text('Invoice')."</font></a></th>";
  $column_header{ordnumber} = "<th><a class=listheading href=$href&sort=ordnumber><font color=ffffff>".$locale->text('Order')."</font></a></th>";
  $column_header{name} = "<th><a class=listheading href=$href&sort=name><font color=ffffff>".$locale->text('Customer')."</font></a></th>";
  $column_header{netamount} = "<th><font color=ffffff>" . $locale->text('Amount') . "</font></th>";
  $column_header{tax} = "<th><font color=ffffff>" . $locale->text('Tax') . "</font></th>";
  $column_header{amount} = "<th><font color=ffffff>" . $locale->text('Total') . "</font></th>";
  $column_header{paid} = "<th><font color=ffffff>" . $locale->text('Paid') . "</font></th>";
  $column_header{datepaid} = "<th><a class=listheading href=$href&sort=datepaid><font color=ffffff>" . $locale->text('Date Paid') . "</font></a></th>";
  $column_header{due} = "<th><font color=ffffff>" . $locale->text('Due') . "</font></th>";
  $column_header{notes} = "<th><a class=listheading><font color=ffffff>".$locale->text('Notes')."</font></th>";
  


  $form->{title} = $locale->text('AR Transactions');
  
  ($customer) = split /--/, $form->{customer};
  if ($form->{customer_id}) {
    $option .= $customer;
  }
  if ($form->{invnumber}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Invoice Number')." : $form->{invnumber}";
  }
  if ($form->{ordnumber}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Order Number')." : $form->{ordnumber}";
  }
  if ($form->{notes}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Notes')." : $form->{notes}";
  }
  if ($form->{transdatefrom}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('From')."&nbsp;".$locale->date(\%myconfig, $form->{transdatefrom}, 1);
  }
  if ($form->{transdateto}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('To')."&nbsp;".$locale->date(\%myconfig, $form->{transdateto}, 1);
  }
  if ($form->{open}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Open');
  }
  if ($form->{closed}) {
    $option .= "\n<br>" if ($option);
    $option .= $locale->text('Closed');
  }

  $colspan = $#column_index + 1;


  $form->header;

  print qq|
<body bgcolor=ffffff>

<table border=1>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$option</td></tr>

<tr class=listheading bgcolor=336666>|;

  map { print "\n$column_header{$_}" } @column_index;

  print qq|
  </tr>
|;


  # add sort and escape callback
  $callback = $form->escape("$callback&sort=$form->{sort}");

  if (@{ $form->{AR} }) {
    $sameitem = $form->{AR}->[0]->{$form->{sort}};
  }
  
  # sums and tax on reports by Antonio Gallardo
  #
  foreach $ar (@{ $form->{AR} }) {

    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ar->{$form->{sort}}) {
	&ar_subtotal;
      }
    }
    
    $column_data{netamount} = "<td align=right>".$form->format_amount(\%myconfig, $ar->{netamount}, 2, "&nbsp;")."</td>";
    $column_data{tax} = "<td align=right>".$form->format_amount(\%myconfig, $ar->{amount} - $ar->{netamount}, 2, "&nbsp;")."</td>";
    $column_data{amount} = "<td align=right>".$form->format_amount(\%myconfig, $ar->{amount}, 2, "&nbsp;")."</td>";
    $column_data{paid} = "<td align=right>".$form->format_amount(\%myconfig, $ar->{paid}, 2, "&nbsp;")."</td>";
    $column_data{due} = "<td align=right>".$form->format_amount(\%myconfig, $ar->{amount} - $ar->{paid}, 2, "&nbsp;")."</td>";
    
    $subtotalnetamount += $ar->{netamount};
    $subtotalamount += $ar->{amount};
    $subtotalpaid += $ar->{paid};
    $subtotaldue += $ar->{amount} - $ar->{paid};
    
    $totalnetamount += $ar->{netamount};
    $totalamount += $ar->{amount};
    $totalpaid += $ar->{paid};
    $totaldue += ($ar->{amount} - $ar->{paid});
    
    $column_data{transdate} = "<td>$ar->{transdate}&nbsp;</td>";
    $column_data{id} = "<td>$ar->{id}</td>";
    $column_data{datepaid} = "<td>$ar->{datepaid}&nbsp;</td>";
    $column_data{duedate} = "<td>$ar->{duedate}&nbsp;</td>";

    $module = ($ar->{invoice}) ? "is.pl" : $form->{script};

    $column_data{invnumber} = "<td><a href=$module?action=edit&id=$ar->{id}&path=$form->{path}&login=$form->{login}&password=$form->{password}&callback=$callback>$ar->{invnumber}</a></td>";
    $column_data{ordnumber} = "<td>$ar->{ordnumber}&nbsp;</td>";
    $column_data{name} = "<td>$ar->{name}</td>";
    $ar->{notes} =~ s/
/<br>/g;
    $column_data{notes} = "<td>$ar->{notes}&nbsp;</td>";

    $i++; $i %= 2;
    print "<tr class=listrow$i>";

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
</tr>
|;

  
  }

  if ($form->{l_subtotal} eq 'Y') {
    &ar_subtotal;
  }

  # print totals
  print qq|<tr class=listtotal bgcolor=000000>|;

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;
  
  $column_data{netamount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{tax} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount - $totalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{amount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."</font></th>";
  $column_data{paid} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalpaid, 2, "&nbsp;")."</font></th>";
  $column_data{due} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totaldue, 2, "&nbsp;")."</font></th>";

  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>

</table>

<p>|.$locale->text('Click on table headers to sort table').qq|
<br>|.$locale->text('Click on invoice number to edit transaction')

.qq|

</body>
</html>
|;

}


sub ar_subtotal {

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;
  
  $column_data{tax} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalamount - $subtotalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{amount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalamount, 2, "&nbsp;")."</font></th>";
  $column_data{paid} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalpaid, 2, "&nbsp;")."</font></th>";
  $column_data{due} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotaldue, 2, "&nbsp;")."</font></th>";
  
  $subtotalnetamount = 0;
  $subtotalamount = 0;
  $subtotalpaid = 0;
  $subtotaldue = 0;

  $sameitem = $ar->{$form->{sort}};
  
  print "<tr class=listsubtotal bgcolor=333366>";

  map { print "\n$column_data{$_}" } @column_index;

print "
</tr>
";
 
}


sub payments {

  # split customer
  ($customer, $form->{customer_id}) = split(/--/, $form->{customer});
  
  AR->payments(\%myconfig, \%$form);

  # construct href
  $href = "$form->{script}?action=payments&path=$form->{path}&login=$form->{login}&password=$form->{password}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&invnumber=".$form->escape($form->{invnumber})."&ordnumber=".$form->escape($form->{ordnumber})."&customer=".$form->escape($form->{customer});
  
  @column_index = $form->sort_columns(qw(invnumber ordnumber transdate name amount currency exchangerate source));
  
  $column_header{transdate} = "<th><a class=listheading href=$href&sort=transdate><font color=ffffff>".$locale->text('Date')."</font></a></th>";
  $column_header{invnumber} = "<th><a class=listheading href=$href&sort=invnumber><font color=ffffff>".$locale->text('Invoice')."</font></a></th>";
  $column_header{ordnumber} = "<th><a class=listheading href=$href&sort=ordnumber><font color=ffffff>".$locale->text('Order')."</font></a></th>";
  $column_header{name} = "<th><a class=listheading href=$href&sort=name><font color=ffffff>".$locale->text('Customer')."</font></a></th>";
  $column_header{amount} = "<th><font color=ffffff>".$locale->text('Amount')."</font></th>";
  $column_header{currency} = "<th><font color=ffffff>".$locale->text('Curr')."</font></th>";
  $column_header{exchangerate} = "<th><font color=ffffff>".$locale->text('Exchangerate')."</font></th>";
  $column_header{source} = "<th><font color=ffffff>".$locale->text('Source')."</font></th>";


  $form->{title} = $locale->text('Process Payments');
  $colspan = $#column_index + 1;

  $form->header;
    
  print qq|
<body bgcolor=ffffff>

<form action=$form->{script} method=post>

<input type=hidden name=defaultcurrency value=$form->{defaultcurrency}>
<input type=hidden name=fxgain_accno value=$form->{fxgain_accno}>
<input type=hidden name=fxloss_accno value=$form->{fxloss_accno}>

<input type=hidden name=closedto value=$form->{closedto}>

<table border=0>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr class=listheading bgcolor=336666>
|;

map { print "\n$column_header{$_}" } @column_index;

  print qq|
</tr>
|;

  # construct callback
  $customer = $form->{customer};
  $customer =~ s/&/_/g;
  $callback = $form->escape("$form->{script}?action=payments&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&open=$form->{open}&path=$form->{path}&login=$form->{login}&password=$form->{password}&sort=$form->{sort}&invnumber=$form->{invnumber}&ordnumber=$form->{ordnumber}&customer=$customer");
 
 
  foreach $key (sort keys %{$form->{paidaccount}}) {
    $paidaccounts .= qq|<option>$form->{paidaccount}{$key}{accno}--$form->{paidaccount}{$key}{description}\n|;
  }


  foreach $ar (@{ $form->{AR} }) {
    $i++;

    $j++; $j %= 2;
    print "<tr class=listrow$j>";
    
    $column_data{transdate} = qq|<td>$ar->{transdate}</td>|;

    $module = ($ar->{invoice}) ? "is.pl" : $form->{script};
    
    $column_data{invnumber} = "<td><a href=$module?action=edit&id=$ar->{id}&path=$form->{path}&login=$form->{login}&password=$form->{password}&callback=$callback>$ar->{invnumber}</a></td>";

    $column_data{ordnumber} = "<td>$ar->{ordnumber}&nbsp;</td>";
    
    $amount = $form->format_amount(\%myconfig, $ar->{amount} / $ar->{exchangerate}, 2, "&nbsp;");
    
    
    $column_data{name} = "<td>$ar->{name}</td>";
    $column_data{amount} = "<td align=right>$amount</td>";
    $column_data{currency} = "<td>$ar->{currency}&nbsp;</td>";
    $column_data{exchangerate} = ($ar->{currency} eq $form->{defaultcurrency}) ? "<td>&nbsp;</td>" : "<td>$ar->{exchangerate}</td>";
    $column_data{source} = "<td>&nbsp;</td>";

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
</tr>
<tr>
|;


    # list all the payments
    $totalpaid = 0;
    $column_data{invnumber} = qq|<th>|.$locale->text('Received').qq|</th>|;
    $column_data{ordnumber} = qq|<td>&nbsp;</td>|;

    foreach $ref (@{ $ar->{payments} }) {
      $j++; $j %= 2;

      print "<tr class=listrow$j>";
      
      $column_data{transdate} = qq|<td>$ref->{transdate}</td>|;
      $column_data{name} = qq|<td>$form->{paidaccount}{$ref->{accno}}{description}</td>|;
      $column_data{amount} = qq|<td align=right>|.$form->format_amount(\%myconfig, $ref->{amount} * -1, 2).qq|</td>|;
      $column_data{currency} = qq|<td>$ar->{currency}</td>|;
      $column_data{exchangerate} = ($ar->{currency} eq $form->{defaultcurrency}) ? "<td>&nbsp;</td>" : "<td>$ref->{exchangerate}</td>";
      $column_data{source} = qq|<td>$ref->{source}&nbsp;</td>|;

      map { print "\n$column_data{$_}" } @column_index;

      print qq|</tr>\n|;
      
      $column_data{invnumber} = qq|<td>&nbsp;</td>|;

      $totalpaid += ($ref->{amount} * -1);
    }
    
    
    print "</tr><tr>\n";
    
    # arrange data for payment input
    $column_data{transdate} = qq|<td><input name="datepaid_$i" size=11></td>|;
    
    $column_data{name} = qq|<td><select name="accno_$i">$paidaccounts</select></td>|;
    
    $column_data{amount} = qq|<td align=right><input name="paid_$i" size=9></td>|;
    
    $column_data{source} = qq|<td><input name="source_$i" size=10></td>|;
    
    $column_data{exchangerate} = ($ar->{currency} eq $form->{defaultcurrency}) ? qq|<td>&nbsp;</td>| : qq|<td><input name="exchangerate_$i" size=10></td>|;
    
    map { print "\n$column_data{$_}" } @column_index;

    print qq|
</tr>

<input type=hidden name="currency_$i" value=$ar->{currency}>
<input type=hidden name="iexch_$i" value=$ar->{exchangerate}>
<input type=hidden name="totalpaid_$i" value=$totalpaid>
<input type=hidden name="id_$i" value=$ar->{id}>
<input type=hidden name="AR_$i" value=$ar->{AR_account}>

<tr><td colspan=8><hr size=3 noshade></td></tr>
|;

  }
  
  print qq|
</table>

<input type=hidden name=rowcount value=$i>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=password value=$form->{password}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Process Payments').qq|">

</form>

<p>|.$locale->text('Click on table headers to sort table').qq|
<br>|.$locale->text('Click on invoice number to edit transaction')

.qq|

</body>
</html>
|;

}


sub process_payments {

  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  
  $msg = $locale->text('Cannot post transaction for a closed period!');
  
  # check closedto
  for $i (1 .. $form->{rowcount}) {
    if ($form->{"datepaid_$i"}) {
      $datepaid = $form->datetonum($form->{"datepaid_$i"}, \%myconfig);
      $form->error($msg) if ($datepaid <= $closedto);
    }
  }

      
  # construct callback
  $form->{callback} = "$form->{script}?action=search&nextsub=payments&path=$form->{path}&login=$form->{login}&password=$form->{password}";

  creditnote2->process_payments(\%myconfig, \%$form);
  $form->redirect;

}


