#ifndef __ODBC__
#define __ODBC__


/*-----------------------------------------------------------------------------
 * Main 
 *-----------------------------------------------------------------------------
 */
#define _MULTITHREAD_SUPPORT

#ifdef WIN32
	#include <windows.h>
	#include <windowsx.h>
	#include <winsock.h>
	#include <stdarg.h>
	#include <tchar.h>
	#include <ctype.h>	

	#define _CRITICAL_SECTION(cs) CRITICAL_SECTION cs

	#define INIT_CRITICAL_SECTION(handle)    InitializeCriticalSection(&((handle)->cs))
	#define ENTER_CRITICAL_SECTION(handle)   EnterCriticalSection(&((handle)->cs))
	#define LEAVE_CRITICAL_SECTION(handle)   LeaveCriticalSection(&((handle)->cs))
	#define DELETE_CRITICAL_SECTION(handle)  DeleteCriticalSection(&((handle)->cs))

	#define POINTER_TO_SQLLEN          SQLLEN
	#define SQLLEN_TO_POINTER          SQLLEN
	#define SQLULEN_TO_POINTER         SQLULEN
	#define POINTER_TO_SQLULEN         SQLULEN

	void TestConnection(HWND hWnd, const TCHAR* szConnectionString);
	void ReadFromDialogItems(HWND hdlg, TCHAR** parameters);
#else
	#include <netinet/tcp.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <arpa/inet.h>
	#include <ctype.h>
	#include <pthread.h>
	#include <string.h>
	#include <stdlib.h>
	#include <math.h>
	#include <netdb.h>
	#include <langinfo.h>
	#include <unistd.h>
	#include <wchar.h>
	#include "tchar.h"



	#define _CRITICAL_SECTION(cs) pthread_mutex_t cs

	#define INIT_CRITICAL_SECTION(handle)    pthread_mutex_init(&((handle)->cs), 0)
	#define ENTER_CRITICAL_SECTION(handle)   pthread_mutex_lock(&((handle)->cs))
	#define LEAVE_CRITICAL_SECTION(handle)   pthread_mutex_unlock(&((handle)->cs))
	#define DELETE_CRITICAL_SECTION(handle)  pthread_mutex_destroy(&((handle)->cs))

	#define POINTER_TO_SQLLEN          SQLLEN)(long
	#define SQLLEN_TO_POINTER          long)(SQLLEN
	#define SQLULEN_TO_POINTER         unsigned long)(SQLULEN
	#define POINTER_TO_SQLULEN         SQLULEN)(unsigned long


	#define SOCKET_ERROR   -1
	#define INVALID_SOCKET -1
	#define FALSE           0
	#define TRUE            1
	
	#define closesocket close
	#define _strnicmp   strncasecmp
	#define SOCKET      int
	#define BOOL        int

#ifndef MAX_PATH
  #define MAX_PATH    260
#endif /* MAX_PATH */

	#define SQL_WCHART_CONVERT

	char* ltoa (long long value, char* string, int radix);

#endif /* WIN32 */

#include <locale.h>
#include <odbcinst.h>
#include <sqlext.h>
#include <stdio.h>
#include <sql.h>

#ifdef USE_SSL
#include <openssl/ssl.h>
#include <openssl/err.h>

#ifdef WIN32
	typedef int         (*SSL_LIBRARY_INIT_FUNC)(void);
	typedef int         (*SSL_LOAD_ERROR_STRINGS_FUNC)(void);
	typedef SSL_CTX*    (*SSL_CTX_NEW_FUNC)(SSL_METHOD*);
	typedef SSL_METHOD* (*SSLV23_CLIENT_METHOD_FUNC)(void);
	typedef SSL*        (*SSL_NEW_FUNC)(SSL_CTX*);
	typedef int         (*SSL_SET_FD_FUNC)(SSL*,int);
	typedef int         (*SSL_CONNECT_FUNC)(SSL*);
	typedef int         (*SSL_SHUTDOWN_FUNC)(SSL*);
	typedef void        (*SSL_FREE_FUNC)(SSL*);
	typedef void        (*SSL_CTX_FREE_FUNC)(SSL_CTX*);
	typedef long        (*SSL_CTX_CTRL_FUNC)(SSL_CTX*,int,long,void*);
	typedef int         (*SSL_READ_FUNC)(SSL*,void*,int);
	typedef int         (*SSL_WRITE_FUNC)(SSL*,const void*,int);
	typedef int         (*SSL_CTX_USE_CERTIFICATE_CHAIN_FILE_FUNC)(SSL_CTX *ctx, const char *file);
	typedef int         (*SSL_GET_ERROR_FUNC)(const SSL *ssl, int ret);
	typedef int         (*SSL_CTX_USE_PRIVATEKEY_FILE_FUNC)(SSL_CTX *ctx, const char *file, int type);
	typedef void        (*SSL_CTX_SET_DEFAULT_PASSWORD_CB_FUNC)(SSL_CTX *ctx, pem_password_cb *cb);
	typedef void        (*SSL_CTX_SET_DEFAULT_PASSWORD_CB_USERDATA_FUNC)(SSL_CTX *ctx, void *u);

	extern SSL_FREE_FUNC                             SSL_FREE;
	extern SSL_SHUTDOWN_FUNC                         SSL_SHUTDOWN;
	extern SSL_WRITE_FUNC                            SSL_WRITE;
	extern SSL_READ_FUNC                             SSL_READ;
	extern SSL_FREE_FUNC                             SSL_FREE;
	extern SSL_CTX_FREE_FUNC                         SSL_CTX_FREE;
	extern SSL_CTX_NEW_FUNC                          SSL_CTX_NEW;
	extern SSL_LIBRARY_INIT_FUNC                     SSL_LIBRARY_INIT;
	extern SSL_LOAD_ERROR_STRINGS_FUNC               SSL_LOAD_ERROR_STRINGS;
	extern SSL_FREE_FUNC                             SSL_FREE;
	extern SSLV23_CLIENT_METHOD_FUNC                 SSLV23_CLIENT_METHOD;
	extern SSL_CTX_CTRL_FUNC                         SSL_CTX_CTRL;
	extern SSL_NEW_FUNC                              SSL_NEW;
	extern SSL_SET_FD_FUNC                           SSL_SET_FD;
	extern SSL_CONNECT_FUNC                          SSL_CONNECT;
	extern SSL_GET_ERROR_FUNC                        SSL_GET_ERROR;
	extern SSL_CTX_USE_CERTIFICATE_CHAIN_FILE_FUNC   SSL_CTX_USE_CERTIFICATE_CHAIN_FILE;
	extern SSL_CTX_USE_PRIVATEKEY_FILE_FUNC          SSL_CTX_USE_PRIVATEKEY_FILE;
	extern SSL_CTX_SET_DEFAULT_PASSWORD_CB_FUNC      SSL_CTX_SET_DEFAULT_PASSWORD_CB;
	extern SSL_CTX_SET_DEFAULT_PASSWORD_CB_USERDATA_FUNC SSL_CTX_SET_DEFAULT_PASSWORD_CB_USERDATA;

	int InitSSL();
#else
	#define SSL_SHUTDOWN                          SSL_shutdown
	#define SSL_FREE                              SSL_free
	#define SSL_WRITE                             SSL_write
	#define SSL_READ                              SSL_read
	#define SSL_LIBRARY_INIT                      SSL_library_init
	#define SSL_LOAD_ERROR_STRINGS                SSL_load_error_strings
	#define SSL_FREE                              SSL_free
	#define SSL_CTX_FREE                          SSL_CTX_free
	#define SSL_CTX_NEW                           SSL_CTX_new
	#define SSLV23_CLIENT_METHOD                  SSLv23_client_method
	#define SSL_CTX_CTRL                          SSL_CTX_ctrl
	#define SSL_NEW                               SSL_new
	#define SSL_SET_FD                            SSL_set_fd
	#define SSL_CONNECT                           SSL_connect
	#define SSL_GET_ERROR                         SSL_get_error
	#define SSL_CTX_USE_CERTIFICATE_CHAIN_FILE    SSL_CTX_use_certificate_chain_file
	#define SSL_CTX_USE_PRIVATEKEY_FILE           SSL_CTX_use_PrivateKey_file
	#define SSL_CTX_SET_DEFAULT_PASSWORD_CB       SSL_CTX_set_default_passwd_cb
	#define SSL_CTX_SET_DEFAULT_PASSWORD_CB_USERDATA_FUNC SSL_CTX_set_default_passwd_cb_userdata
#endif /* WIN32 */

#endif /* USE_SSL */

typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned int   uint32;


#ifdef _UNICODE

	#define SQL_TCHAR            SQL_WCHAR
	#define SQL_TVARCHAR         SQL_WVARCHAR

	#define BYTES_TO_CHARACTERS(length)   ((SQL_NTS == length) ? length : (length / sizeof(WCHAR)))
	#define SEND_STRLEN(str, n)           utf8len(str, n)

	#define SQLDriverConnect_    SQLDriverConnectW
	#define SQLConnect_          SQLConnectW
	#define SQLPrepare_          SQLPrepareW
	#define SQLExecDirect_       SQLExecDirectW
	#define ConfigDSN_           ConfigDSNW
	#define SQLGetDiagRec_       SQLGetDiagRecW
	#define SQLBrowseConnect_    SQLBrowseConnectW
	#define SQLForeignKeys_      SQLForeignKeysW
	#define SQLColumns_          SQLColumnsW
	#define SQLSpecialColumns_   SQLSpecialColumnsW
	#define SQLProcedureColumns_ SQLProcedureColumnsW
	#define SQLTablePrivileges_  SQLTablePrivilegesW
	#define SQLDescribeCol_      SQLDescribeColW
	#define SQLPrimaryKeys_      SQLPrimaryKeysW
	#define SQLProcedures_       SQLProceduresW
	#define SQLGetCursorName_    SQLGetCursorNameW
	#define SQLGetDescRec_       SQLGetDescRecW
	#define SQLNativeSql_        SQLNativeSqlW
	#define SQLSetCursorName_    SQLSetCursorNameW
	#define SQLError_            SQLErrorW
	#define SQLStatistics_       SQLStatisticsW
	#define SQLTables_           SQLTablesW
	#define SQLGetStmtAttr_      SQLGetStmtAttrW
	#define SQLGetConnectAttr_   SQLGetConnectAttrW
	#define SQLGetDiagField_     SQLGetDiagFieldW
	#define SQLGetInfo_          SQLGetInfoW
	#define SQLGetDescField_     SQLGetDescFieldW
	#define SQLColAttribute_     SQLColAttributeW
	#define SQLColAttributes_    SQLColAttributesW
	#define SQLSetDescField_     SQLSetDescFieldW
	#define SQLSetConnectAttr_   SQLSetConnectAttrW
	#define SQLGetConnectOption_ SQLGetConnectOptionW
	#define SQLSetConnectOption_ SQLSetConnectOptionW
	#define SQLSetStmtAttr_      SQLSetStmtAttrW
	#define SQLColumnPrivileges_ SQLColumnPrivilegesW

#else

	#define SQL_TCHAR            SQL_CHAR
	#define SQL_TVARCHAR         SQL_VARCHAR

	#define BYTES_TO_CHARACTERS(length)    length
	#define SEND_STRLEN(str, n)            ((SQL_NTS == n) ? strlen(str) : n)

	#define SQLDriverConnect_    SQLDriverConnect
	#define SQLConnect_          SQLConnect
	#define SQLPrepare_          SQLPrepare
	#define SQLExecDirect_       SQLExecDirect
	#define ConfigDSN_           ConfigDSN
	#define SQLGetDiagRec_       SQLGetDiagRec
	#define SQLBrowseConnect_    SQLBrowseConnect
	#define SQLForeignKeys_      SQLForeignKeys
	#define SQLColumns_          SQLColumns
	#define SQLSpecialColumns_   SQLSpecialColumns
	#define SQLProcedureColumns_ SQLProcedureColumns
	#define SQLTablePrivileges_  SQLTablePrivileges
	#define SQLDescribeCol_      SQLDescribeCol
	#define SQLPrimaryKeys_      SQLPrimaryKeys
	#define SQLProcedures_       SQLProcedures
	#define SQLGetCursorName_    SQLGetCursorName
	#define SQLGetDescRec_       SQLGetDescRec
	#define SQLNativeSql_        SQLNativeSql
	#define SQLSetCursorName_    SQLSetCursorName
	#define SQLError_            SQLError
	#define SQLStatistics_       SQLStatistics
	#define SQLTables_           SQLTables
	#define SQLGetStmtAttr_      SQLGetStmtAttr
	#define SQLGetConnectAttr_   SQLGetConnectAttr
	#define SQLGetDiagField_     SQLGetDiagField
	#define SQLGetInfo_          SQLGetInfo
	#define SQLGetDescField_     SQLGetDescField
	#define SQLColAttribute_     SQLColAttribute
	#define SQLColAttributes_    SQLColAttributes
	#define SQLSetDescField_     SQLSetDescField
	#define SQLSetConnectAttr_   SQLSetConnectAttr
	#define SQLGetConnectOption_ SQLGetConnectOption
	#define SQLSetConnectOption_ SQLSetConnectOption
	#define SQLSetStmtAttr_      SQLSetStmtAttr
	#define SQLColumnPrivileges_ SQLColumnPrivileges

#endif /* _UNICODE */

#define STR_SIZEOF(str)  (sizeof(_T(str))/sizeof(TCHAR)-1)
#define CHR_SIZEOF(str)  (sizeof(str)/sizeof(TCHAR)-1)

#define FREE(ptr)        if (ptr) { free(ptr); ptr = NULL; }

#ifndef SQL_IS_LEN
#define SQL_IS_LEN           (-9)
#endif /* SQL_IS_LEN */


#endif /* __ODBC__ */
