.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "BEGIN" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
BEGIN \- start a transaction block
.SH SYNOPSIS
.sp
.nf
BEGIN [ WORK | TRANSACTION ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBWORK\fR
.TP
\fBTRANSACTION\fR
Optional keywords. They have no effect.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBBEGIN\fR
This signifies that a new transaction has been started.
.TP
\fBWARNING: BEGIN: already a transaction in progress\fR
This indicates that a transaction was already in progress.
The current transaction is not affected.
.PP
.SH "DESCRIPTION"
.PP
By default, PostgreSQL executes transactions
in \fIunchained mode\fR
(also known as ``autocommit'' in other database
systems).
In other words, each user statement is executed in its own transaction
and a commit is implicitly performed at the end of the statement
(if execution was successful, otherwise a rollback is done).
\fBBEGIN\fR initiates a user transaction in chained mode,
i.e., all user statements after \fBBEGIN\fR command will
be executed in a single transaction until an explicit 
COMMIT [\fBcommit\fR(l)] or
ROLLBACK [\fBrollback\fR(l)].
Statements are executed more quickly in chained mode,
because transaction start/commit requires significant CPU and disk 
activity. Execution of multiple statements inside a transaction
is also useful to ensure consistency when changing several
related tables: other clients will be unable to see the intermediate
states wherein not all the related updates have been done.
.PP
The default transaction isolation level in
PostgreSQL
is READ COMMITTED, wherein each query inside the transaction sees changes
committed before that query begins execution. So, you have to use 
\fBSET TRANSACTION ISOLATION LEVEL SERIALIZABLE\fR
just after \fBBEGIN\fR if you need more rigorous transaction
isolation. (Alternatively, you can change the default transaction
isolation level; see the \fIPostgreSQL Administrator's
Guide\fR for details.)
In SERIALIZABLE mode queries will see only changes committed before
the entire
transaction began (actually, before execution of the first DML statement
in the transaction).
.PP
Transactions have the standard ACID
(atomic, consistent, isolatable, and durable) properties.
.SS "NOTES"
.PP
START TRANSACTION [\fBstart_transaction\fR(l)] has the same functionality
as \fBBEGIN\fR.
.PP
Use COMMIT [\fBcommit\fR(l)]
or
ROLLBACK [\fBrollback\fR(l)]
to terminate a transaction.
.PP
Refer to LOCK [\fBlock\fR(l)]
for further information
about locking tables inside a transaction.
.PP
If you turn autocommit mode off, then \fBBEGIN\fR
is not required: any SQL command automatically starts a transaction.
.SH "USAGE"
.PP
To begin a user transaction:
.sp
.nf
BEGIN WORK;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBBEGIN\fR
is a PostgreSQL language extension.
There is no explicit \fBBEGIN\fR
command in SQL92;
transaction initiation is always implicit and it terminates either 
with a \fBCOMMIT\fR or \fBROLLBACK\fR statement.
.sp
.RS
.B "Note:"
Many relational database systems offer an autocommit feature as a
convenience.
.RE
.sp
.PP
Incidentally, the BEGIN keyword is used for a different
purpose in embedded SQL. You are advised to be careful about the transaction
semantics when porting database applications.
.PP
SQL92 also requires SERIALIZABLE to be the default
transaction isolation level.
