.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "START TRANSACTION" "l" "2002-07-26" "SQL - Language Statements" "SQL Commands"
.SH NAME
START TRANSACTION \- start a transaction block
.SH SYNOPSIS
.sp
.nf
START TRANSACTION [ ISOLATION LEVEL { READ COMMITTED | SERIALIZABLE } ]
  
.sp
.fi
.SS "INPUTS"
.PP
None.
.SS "OUTPUTS"
.PP
.TP
\fBSTART TRANSACTION\fR
Message returned if successful.
.TP
\fBWARNING: BEGIN: already a transaction in progress\fR
If there is already a transaction in progress when the
command is issued.
.PP
.SH "DESCRIPTION"
.PP
This command begins a new transaction. If the isolation level is
specified, the new transaction has that isolation level. In all other
respects, the behavior of this command is identical to the
BEGIN [\fBbegin\fR(l)] command.
.SH "NOTES"
.PP
The isolation level of a transaction can also be set with the SET TRANSACTION [\fBset_transaction\fR(l)]
command. If no isolation level is specified, the default isolation
level is used.
.SH "COMPATIBILITY"
.SS "SQL99"
.PP
\fBSERIALIZABLE\fR is the default isolation level in
SQL99, but it is not the usual default in
PostgreSQL: the factory default setting
is READ COMMITTED.
PostgreSQL 
does not provide the isolation levels \fBREAD UNCOMMITTED\fR
and \fBREPEATABLE READ\fR. Because of lack of predicate
locking, the \fBSERIALIZABLE\fR level is
not truly serializable. See the \fIUser's Guide\fR
for details.
.PP
In SQL99 this statement can specify two other
properties of the new transaction: whether the transaction is
read-only and the size of the diagnostics area. Neither of these
concepts are currently supported in
PostgreSQL.
