/*--------------------------------------------------------------------
 * FILE:
 *     admin_set_pglb_status.c
 *
 * NOTE:
 *     This file is composed of the admin process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Admin_Set_Pglb_Status(Probe_Header * header, char * packet);
int PGC_Sync_Status_Pglb(Pglb_Info * pglb);

static int set_pglb_status(ClusterTbl * cluster);

int
PGC_Admin_Set_Pglb_Status(Probe_Header * header, char * packet)
{
	char * func = "PGC_Admin_Set_Pglb_Status()";
	int count = 0;
	int status = STATUS_ERROR;
	ClusterTbl cluster;
	char * p = NULL;
	char * ptr = NULL;
	int size = 0;
	Pglb_Info pglb_key;
	Pglb_Info * pglb = NULL;

	if ((header == NULL ) || (packet == NULL))
	{
		show_error("%s: table is not allocated",func);
		return STATUS_ERROR;
	}
	if (ntohl(header->body_length) < sizeof(Pglb_Info))
	{
		show_error("%s: there is no packet data ",func);
		return STATUS_ERROR;
	}

	/* set status of pglb */
	PGC_Set_Packet_2_Pglb_Info(&pglb_key ,(Pglb_Info *)packet);
	pglb = PGC_Get_PglbTbl_Rec(&pglb_key);
	if (pglb != NULL)
	{
		pglb->receiveStatus |= pglb_key.status;
		status = STATUS_OK;
	}
	
	size = sizeof(ClusterTbl);
	ptr = (char *)packet;
	p = ptr + sizeof(Pglb_Info);
	/* set status of cluster db in pglb */
	count = 0;
	while (count < ntohl(header->rec_num))
	{
		memset(&cluster, 0, size);
		PGC_Set_Packet_2_ClusterTbl(&cluster,(ClusterTbl*)p); 
		status = set_pglb_status(&cluster);
		count ++;
		p += sizeof(ClusterTbl);
	}
	return status;
}

int
PGC_Sync_Status_Pglb(Pglb_Info * pglb)
{
	char * func ="PGC_Sync_Status_Pglb()";
	Probe_Header r_header;
	Probe_Header h_data;
	Pglb_Info body;
	int status = STATUS_OK;
	SSL_Info ssl_tbl;
	SSL_Server_Info * probe = ProbeTbl;

	if (probe == NULL)
	{
		show_error("%s:ProbeTbl is NULL",func);
		return STATUS_ERROR;
	}
	if (pglb == NULL)
	{
		show_error("%s: pglb info is null",func);
		return STATUS_ERROR;
	}
	memset(&h_data, 0, sizeof(Probe_Header));
	memset(&r_header, 0, sizeof(Probe_Header));
	memset(&body, 0, sizeof(Pglb_Info));
	memset(&ssl_tbl, 0, sizeof(SSL_Info));

	h_data.packet_no = SET_STS_REQ_PKT;
	h_data.serverType = SERVER_TYPE_PGLB;
	h_data.body_length = sizeof(Pglb_Info);
	h_data.rec_num = 1;
	PGC_Set_Pglb_Info_2_packet(&body, pglb);
show_pglb_info(pglb);
	while (probe->status != DATA_END)
	{
		PGC_Set_Packet_Header(&r_header, &h_data);
		status = PGC_Admin_Send_Packet(&ssl_tbl, &r_header, (char *)&body, probe->physicalServerId);
		if (status == STATUS_OK)
		{
			PGC_Response_Receive(&ssl_tbl, &r_header);
			PGC_Close_SSL(&ssl_tbl);
		}
		probe ++;
	}
	PGC_Close_SSL(&ssl_tbl);
	return status;
}

static int
set_pglb_status(ClusterTbl * cluster)
{
	char * func ="set_pglb_status()";
	Cluster_Info * ptr = NULL;
	if (ClusterDbTbl == NULL)
	{
		show_error("ClusterDbTbl is null");
		return STATUS_ERROR;
	}
	ptr = ClusterDbTbl;
	while (ptr->portNumber != 0)
	{
		if ((!strncmp(ptr->hostName, cluster->hostName, sizeof(ptr->hostName))) &&
			(ptr->portNumber == cluster->port))
		{
			/* find cluster data */
			ptr->receiveStatus |= cluster->useFlag;
			ptr->use_num = cluster->use_num;
			show_debug("%s:receiveStatus[%d] use_num[%d]\n",func,ptr->receiveStatus, ptr->use_num);
			break;
		}
		ptr ++;
	}
	return STATUS_OK;
}
