/*-------------------------------------------------------------------------
 *
 * pg_reporter.h
 *
 * Copyright (c) 2009-2010, NIPPON TELEGRAPH AND TELEPHONE CORPORATION
 *
 *-------------------------------------------------------------------------
 */

#ifndef PG_REPORTER_H
#define PG_REPORTER_H

#include "postgres_fe.h"
#include "pgut/pgut-fe.h"
#include "pgut/pgut-list.h"

#include <libxml/parser.h>

#define FILES_DIR		"files"				/* directory name for files */
#define DBNAMES			"./pg_reporter.conf"	/* connection information file */
#define XML_DEFAULT		"index"				/* index file */
#define XSL_DIR			"xsl/dir.xsl"		/* xsl for directories */
#define XSL_DBNAMES		"xsl/dbnames.xsl"	/* xsl for dbnames */
#define XML_DBNAMES		"dbnames"			/* template xml for dbnames */
#define URL_PATH		"pg_reporter"
											/* access URL path */

extern const char *makeReport(StringInfo out, const char *xmlPath, List *vars);
extern const char *applyStylesheet(StringInfo out, xmlDocPtr xml,
								   const char *xslPath, List *vars);

/* in dbnames.c */

/* Database connection information */
typedef struct Database
{
	char *id;
	char *host;
	char *port;
	char *database;
	char *username;
	char *password;
	char *report_dir;
} Database;

extern Database *getDatabase(const char *id);
extern List *getDatabases(const char *config);
extern void freeDatabase(Database *db);
extern Database *getFirstDatabase(void);

/* in httpd.c */

/* URL parameter */
typedef struct Variable
{
	char *name;
	char *value;
} Variable;

extern List *makeVariables(const char *parameters);
extern const char *getVariable(List *vars, const char *name);
extern List *addVariable(List *vars, const char *name, const char *value);
extern void freeVariable(Variable *var);

extern int httpd_main(int port, const char *listen_addresses);
extern int cgi_main(void);

/* in init.c */
extern int init_main(const char *dir, const char *argv0);

#endif   /* PG_REPORTER_H */
