/* $Id: module.c,v 1.18 2005/06/30 07:58:59 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * imp/src/module.c,v 1.8 2004/12/15 05:13:16 flaw
 * if/src/module.c,v 1.28 2004/09/28 15:52:39 flaw
 *//*
 * The Postgres interface module implementation
 */
#include <setjmp.h>
#include <postgres.h>
#include <funcapi.h>
#include <miscadmin.h>
#include <access/heapam.h>
#include <access/htup.h>
#include <access/hio.h>
#include <access/xact.h>
#include <catalog/namespace.h>
#include <catalog/pg_namespace.h>
#include <catalog/catversion.h>
#include <catalog/pg_proc.h>
#include <catalog/pg_type.h>
#include <commands/async.h>
#include <commands/trigger.h>
#include <libpq/libpq.h>
#include <libpq/pqformat.h>
#include <mb/pg_wchar.h>
#include <tcop/tcopprot.h>
#include <utils/array.h>
#include <utils/elog.h>
#include <utils/syscache.h>
#include <utils/memutils.h>
#include <utils/tuplestore.h>
#include <utils/rel.h>
#include <utils/relcache.h>
#include <storage/backendid.h>
#include <storage/large_object.h>
#include <pypg/postgres.h>
#include <pypg/environment.h>

#include <Python.h>
#include <structmember.h>
#include <pypg/python.h>

#include <pypg/externs.h>

#include <pypg/tupledesc.h>
#include <pypg/heaptuple.h>
#include <pypg/object.h>
#include <pypg/type.h>
#include <pypg/function.h>
#include <pypg/query.h>
#include <pypg/call.h>
#include <pypg/call/function.h>
#include <pypg/call/pl.h>
#include <pypg/call/trigger.h>
#include <pypg/call/portal.h>
#include <pypg/namespace.h>
#include <pypg/relation.h>
#include <pypg/utils.h>
#include <pypg/transaction.h>
#include <pypg/savepoint.h>
#include <pypg/error.h>
#include <pypg/encoding.h>
#include <pypg/cis.h>

#define PYEREPORTIMP(ereport_LEVEL_)	\
	char *msg = NULL;							\
	char *hint = NULL;						\
	char *detail = NULL;						\
	char *context = NULL;					\
													\
	static char *kwlist[] = {				\
		"msg", "hint", "detail",			\
		"context", NULL						\
	};												\
													\
	if (!PyArg_ParseTupleAndKeywords(	\
			args, kw, "s|sss", kwlist,		\
			&msg, &hint, &detail,			\
			&context))							\
		return(NULL);							\
													\
	if (errstart(ereport_LEVEL_,			\
			"Python", 0, "<wrapper>"))		\
	{												\
		errmsg("%s", msg);					\
		if (hint)								\
			errhint("%s", hint);				\
		if (detail)								\
			errdetail("%s", detail);		\
		if (context)							\
			errcontext("%s", context);		\
		errfinish(0);							\
	}

#define PyPgDefineEReportFunction(LEVEL) \
static char pypg_##LEVEL##_doc[] = "ereport at the " #LEVEL " level"; \
static PyObj pypg_##LEVEL(PyObj self, PyObj args, PyObj kw) \
{ PYEREPORTIMP(LEVEL); RETURN_NONE; }

PyPgDefineEReportFunction(WARNING);
PyPgDefineEReportFunction(NOTICE);
PyPgDefineEReportFunction(INFO);
PyPgDefineEReportFunction(LOG);
PyPgDefineEReportFunction(DEBUG1);

static char pypg_ERROR_doc[] = "ereport at the ERROR level";
static PyObj pypg_ERROR(PyObj self, PyObj args, PyObj kw)
{
	PG_TRY();
	{
		PYEREPORTIMP(ERROR);
	}
	PG_CATCH();
	{
		PyErr_SetPgError();
	}
	PG_END_TRY();

	return(NULL);
}
#undef PyPgDefineEReportFunction
#undef PYEREPORTIMP


static char pypg_execute_doc[] =
"run an SQL query directly on the server";
static PyObj
pypg_execute(PyObj self, PyObj qstr)
{
	PyObj query, rob;

	query = PyPgQuery_New(qstr);
	if (query == NULL) return(NULL);

	rob = Py_Call(query);
	Py_DECREF(query);

	return(rob);
}

static char pypg_xid_doc[] =
"get the current transaction identifier";
static PyObj
pypg_xid(void)
{
	PyObj rob;
	Datum d = TransactionIdGetDatum(GetCurrentTransactionId());
	rob = PyPgObject_FromTypeOidAndDatum(XIDOID, d);
	return(rob);
}

static char pypg_cid_doc[] =
"get the current command identifier";
static PyObj
pypg_cid(void)
{
	PyObj rob;
	Datum d = CommandIdGetDatum(GetCurrentCommandId());
	rob = PyPgObject_FromTypeOidAndDatum(CIDOID, d);
	return(rob);
}

static char pypg_uid_doc[] =
"get the user identifier";
static PyObj
pypg_uid(void)
{
	PyObj rob;
	Datum d = ObjectIdGetDatum(GetUserId());
	rob = PyPgObject_FromTypeOidAndDatum(INT4OID, d);
	return(rob);
}

static char pypg_sesuid_doc[] =
"get the session user identifier";
static PyObj
pypg_sesuid(void)
{
	PyObj rob;
	Datum d = ObjectIdGetDatum(GetSessionUserId());
	rob = PyPgObject_FromTypeOidAndDatum(INT4OID, d);
	return(rob);
}

static char pypg_encoding_doc[] =
"get the database's encoding";
static PyObj
pypg_encoding(void)
{
	const char *es;
	PyObj rob;
	es = PyEncoding_FromPgEncoding(GetDatabaseEncoding());
	if (es != NULL)
		rob = PyString_InternFromString(es);
	else
	{
		rob = Py_None;
		Py_INCREF(rob);
	}
	return(rob);
}

static char pypg_encoding_code_doc[] =
"get the database's encoding code";
static PyObj
pypg_encoding_code(void)
{
	PyObj rob;
	rob = PyInt_FromLong(GetDatabaseEncoding());
	return(rob);
}

static char pypg_notify_doc[] =
"generate a notification for the specified listener";
static PyObj
pypg_notify(PyObj self, PyObj name)
{
	if (PyString_Check(name))
		Async_Notify(PyString_AS_STRING(name));
	else
	{
		PyErr_Format(PyExc_TypeError,
			"Postgres.Notify requires a %s object, given %s",
			PyString_Type.tp_name, name->ob_type->tp_name);
		return(NULL);
	}
	RETURN_NONE;
}

static char pypg_listen_doc[] =
"listen for a notification on the specified channel";
static PyObj
pypg_listen(PyObj self, PyObj name)
{
	if (PyString_Check(name))
	{
		PG_TRY();
		{
			Async_Listen(PyString_AS_STRING(name), MyProcPid);
		}
		PYPG_CATCH_END(return(NULL));
	}
	else
	{
		PyErr_Format(PyExc_TypeError,
			"Postgres.Listen requires a %s object, given %s",
			PyString_Type.tp_name, name->ob_type->tp_name);
		return(NULL);
	}
	RETURN_NONE;
}

static char pypg_unlisten_doc[] =
"stop listening for notifications on the specified channel";
static PyObj
pypg_unlisten(PyObj self, PyObj name)
{
	if (PyString_Check(name))
	{
		PG_TRY();
		{
			Async_Unlisten(PyString_AS_STRING(name), MyProcPid);
		}
		PYPG_CATCH_END(return(NULL));
	}
	else
	{
		PyErr_Format(PyExc_TypeError,
			"Postgres.Unlisten requires a %s object, given %s",
			PyString_Type.tp_name, name->ob_type->tp_name);
		return(NULL);
	}
	RETURN_NONE;
}

static char ns_lookup_doc[] = "Lookup the Oid of the given namespace";
PyObj
ns_lookup(PyObj self, PyObj nsn)
{
	char *nsns = PyString_AS_STRING(nsn);
	Oid nsoid;
	PyObj rob;

	PG_TRY();
	{
		nsoid = LookupExplicitNamespace(nsns);
	}
	PYPG_CATCH_END(return(NULL));

	rob = PyInt_FromLong((long) nsoid);
	return(rob);
}

static char ns_create_doc[] = "Create a namespace with the given name";
PyObj
ns_create(PyObj self, PyObj nsn)
{
	char *nsns = PyString_AS_STRING(nsn);
	Oid nsoid;
	PyObj rob;

	PG_TRY();
	{
		nsoid = NamespaceCreate(nsns, GetUserId());
	}
	PYPG_CATCH_END(return(NULL));

	rob = PyInt_FromLong((long) nsoid);
	return(rob);
}

static PyMethodDef PyPgModule_Methods[] = {
	{"ERROR", (PyCFunction) pypg_ERROR,
		METH_VARARGS|METH_KEYWORDS, pypg_ERROR_doc},
	{"WARNING", (PyCFunction) pypg_WARNING,
		METH_VARARGS|METH_KEYWORDS, pypg_WARNING_doc},
	{"NOTICE", (PyCFunction) pypg_NOTICE,
		METH_VARARGS|METH_KEYWORDS, pypg_NOTICE_doc},
	{"INFO", (PyCFunction) pypg_INFO,
		METH_VARARGS|METH_KEYWORDS, pypg_INFO_doc},
	{"LOG", (PyCFunction) pypg_LOG,
		METH_VARARGS|METH_KEYWORDS, pypg_LOG_doc},
	{"DEBUG", (PyCFunction) pypg_DEBUG1,
		METH_VARARGS|METH_KEYWORDS, pypg_DEBUG1_doc},

	{"Execute", (PyCFunction) pypg_execute, METH_O, pypg_execute_doc},

	{"Xid", (PyCFunction) pypg_xid,
		METH_NOARGS, pypg_xid_doc},
	{"Cid", (PyCFunction) pypg_cid,
		METH_NOARGS, pypg_cid_doc},
	{"Uid", (PyCFunction) pypg_uid,
		METH_NOARGS, pypg_uid_doc},
	{"SessionUid", (PyCFunction) pypg_sesuid,
		METH_NOARGS, pypg_sesuid_doc},

	{"Encoding", (PyCFunction) pypg_encoding,
		METH_NOARGS, pypg_encoding_doc},
	{"EncodingCode", (PyCFunction) pypg_encoding_code,
		METH_NOARGS, pypg_encoding_code_doc},

	{"Notify", (PyCFunction) pypg_notify, METH_O, pypg_notify_doc},
	{"Listen", (PyCFunction) pypg_listen, METH_O, pypg_listen_doc},
	{"Unlisten", (PyCFunction) pypg_unlisten, METH_O, pypg_unlisten_doc},

	{"LookupNamespace", (PyCFunction) ns_lookup, METH_O, ns_lookup_doc},
	{"CreateNamespace", (PyCFunction) ns_create, METH_O, ns_create_doc},
	{NULL}
};

/*
 * C Interface initialization
 */
struct PyPgCI_Root PyPgCI = {

/* PL */
	{
		0,			/* Oid */
		NULL,		/* Handler */
		NULL,		/* Fixer */
	},

/* Error */
	{
		NULL,
		PyErr_FromErrorData,
		PyErr_SetPgError,
	},

/* Encoding */
	{
		PyEncoding_FromPgEncoding,
	},

/* Object */
#define E(R) PyPgObject_##R,
	{
		&E(Type)
		E(Initialize)
		E(FromPyPgTypeAndDatum)
		E(FromTypeOidAndDatum)
		E(FromPyPgTypeAndHeapTuple)
	},
#undef E

/* Type */
#define E(R) PyPgType_##R,
	{
		&E(Type)
		E(FromOid)
		E(FromRelationOid)
		E(FromPyObject)
	},
#undef E

/* Function */
#define E(R) PyPgFunction_##R,
	{
		&E(Type)
		E(FromOid)
	},
#undef E

/* Namespace */
#define E(R) PyPgNamespace_##R,
	{
		&E(Type)
		E(FromOid)
	},
#undef E

/* Relation */
#define E(R) PyPgRelation_##R,
	{
		&E(Type)
	},
#undef E

/* Query */
#define E(R) PyPgQuery_##R,
	{
		&E(Type)
		E(Initialize)
	},
#undef E

/* TupleDesc */
#define E(R) PyPgTupleDesc_##R,
	{
		&E(Type)
		E(Initialize)
		E(FromRelationId)
	},
#undef E

/* HeapTuple */
#define E(R) PyPgHeapTuple_##R,
	{
		&E(Type)
		E(Initialize)
	},
#undef E

/* Transaction */
	{
		&PyPgTransaction_Type,
	},

/* Savepoint */
	{
		&PyPgSavepoint_Type,
	},

/* Call */
#define E(R) PyPgCall_##R,
	{
		&E(Type)
		E(Initialize)
	},
#undef E

/* Portal */
#define E(R) PyPgPortal_##R,
	{
		&E(Type)
		E(Initialize)
	},
#undef E

/* FunctionCall */
#define E(R) PyPgFunctionCall_##R,
	{
		&E(Type)
		E(Initialize)
	},
#undef E

/* ProceduralCall */
#define E(R) PyPgProceduralCall_##R,
	{
		&E(Type)
		E(Initialize)
		E(InitializeParameters)
	},
#undef E

/* TriggerPull */
#define E(R) PyPgTriggerPull_##R,
	{
		&E(Type)
		E(Initialize)
	},
#undef E
};

static char PyPgModule_doc[] =
"Postgres interface extension module";
extern PyMODINIT_FUNC
init_prime(void)
{
	PyObj mod, ob, md;
	
	md = PyImport_GetModuleDict();
	if (md == NULL) return;

	mod = Py_InitModule3("_prime", PyPgModule_Methods, PyPgModule_doc);
	if (mod == NULL) return;

	if (PyDict_SetItemString(md, "_Postgres", mod) < 0)
	{
		DECREF(mod);
		return;
	}

	/* Version information */
	{
		PyObj vi, v, major, minor, patch, state, state_level;
		major = PyInt_FromLong(PG_VERSION_MAJOR);
		minor = PyInt_FromLong(PG_VERSION_MINOR);
		patch = PyInt_FromLong(PG_VERSION_PATCH);
		state = PyString_FromString(PG_VERSION_STATE);
		state_level = PyInt_FromLong(PG_VERSION_LEVEL);

		vi = PyTuple_New(5);
		PyTuple_SET_ITEM(vi, 0, major);
		PyTuple_SET_ITEM(vi, 1, minor);
		PyTuple_SET_ITEM(vi, 2, patch);
		PyTuple_SET_ITEM(vi, 3, state);
		PyTuple_SET_ITEM(vi, 4, state_level);
		PyModule_AddObject(mod, "version_info", vi);

		v = PyString_FromString(PG_VERSION_STR);
		PyModule_AddObject(mod, "version", v);
	}

	ob = PyCObject_FromVoidPtr(&PyPgCI, NULL);
		if (ob == NULL) return;
	if (PyModule_AddObject(mod, PyPgCI_CObjectName, ob) < 0)
	{
		Py_DECREF(ob);
		return;
	}

	/*
	 * This extension module extends it's pure python interface module,
	 * which should already be imported, so fetch the PP module's dict and
	 * fetch some attributes.
	 */
	ob = PyDict_GetItemString(md, "Postgres");
	if (ob == NULL)
		return;
	Postgres_PyModule = ob;

	ob = PyObject_GetAttrString(Postgres_PyModule, "ErrorLookup");
	if (ob == NULL)
	{
		PyErr_SetString(PyExc_LookupError,
			"failed to get \"ErrorLookup\" from the Postgres module");
		return;
	}
	PyPgErrorLookup = ob;

	ob = PyObject_GetAttrString(Postgres_PyModule, "Error");
	if (ob == NULL)
	{
		PyErr_SetString(PyExc_LookupError,
			"failed to get \"Error\" from the Postgres module");
		return;
	}
	PyPgCI.Error.Type = ob;

	ob = PyImport_AddModule("__main__");
	if (ob == NULL) return;
	__main__ = PyModule_GetDict(ob);

	PyPgEncoding_Initialize();

	ob = PyDict_New();
	if (ob == NULL) return;
#	define TARGET ob
#	define APFUNC PyMapping_SetItemString
#		include "constants.c"
#	undef APFUNC
#	undef TARGET
	PyModule_AddObject(mod, "Const", ob);

#define READY(TYPE) (PyType_Ready(&PyPg##TYPE##_Type) < 0)
	if (READY(Object) || READY(Type)
		|| READY(Function)
		|| READY(Call) || READY(FunctionCall)
		|| READY(ProceduralCall) || READY(TriggerPull)
		|| READY(Relation)
		|| READY(Namespace)
		|| READY(TupleDesc) || READY(HeapTuple)
		|| READY(Query) || READY(Portal)
		|| READY(Transaction)
		|| READY(Savepoint)
	)
		return;
#undef READY

#define ADD(BASE) PyModule_AddObject(mod, #BASE, (PyObj) &PyPg##BASE##_Type)
	ADD(Object);
	ADD(Type);

	ADD(Function);
	ADD(Call);
	ADD(FunctionCall);
	ADD(ProceduralCall);
	ADD(TriggerPull);

	ADD(Relation);
	ADD(Namespace);
	ADD(TupleDesc);
	ADD(HeapTuple);
	ADD(Query);
	ADD(Portal);

	ADD(Transaction);
	ADD(Savepoint);
#undef ADD

	PyPgDEFAULT = PyString_FromString("DEFAULT");
	PyModule_AddObject(mod, "DEFAULT", PyPgDEFAULT);

	PyPgType_Cache = PyDict_New();
	PyPgFunction_Cache = PyDict_New();
	PyPgRelation_Cache = PyDict_New();
	PyPgNamespace_Cache = PyDict_New();

	PythonMemoryContext = TopMemoryContext;
}
/*
 * vim: ts=3:sw=3:noet:
 */
