CREATE FUNCTION text_cat_oid(text, oid) RETURNS text AS
  'SELECT $1 || $2::text'
LANGUAGE sql IMMUTABLE STRICT;

CREATE OPERATOR || (
  PROCEDURE  = text_cat_oid,
  LEFTARG    = text,
  RIGHTARG   = oid
);

CREATE FUNCTION text_cat_regclass(text, regclass) RETURNS text AS
  'SELECT $1 || textin(regclassout($2))'
LANGUAGE sql STABLE STRICT;

CREATE OPERATOR || (
  PROCEDURE  = text_cat_regclass,
  LEFTARG    = text,
  RIGHTARG   = regclass
);

CREATE FUNCTION text_cat_bool(text, bool) RETURNS text AS
  'SELECT $1 || CASE WHEN $2 THEN ''true'' ELSE ''false'' END'
LANGUAGE sql IMMUTABLE STRICT;

CREATE OPERATOR || (
  PROCEDURE  = text_cat_bool,
  LEFTARG    = text,
  RIGHTARG   = bool
);
