/****************************************************************************
*
*  SaveFailed.h
*
*  This file is part of the CodeMax editor support code.
*
*  Copyright  POV-Team(tm) 1996-1998. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-1998 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  NOTE : As this is Windows code, it was edited using a wide Windows-hosted
*         editor. Accordingly, expect text to exceed 80 columns regularly.
*
*  from Persistence of Vision Raytracer(tm)
*  Copyright 1996-1998 Persistence of Vision Team
*
* The terms POV-Ray, POV, and Persistence of Vision Raytracer are trademarks
* of the Persistence of Vision Team.
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray(tm) and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray(tm)
*  Team Coordinator by leaving a message in CompuServe's POVRAY forum. The
*  The latest version of POV-Ray may be found there as well. POVRAY files can
*  also be found on the world wide web at http://www.povray.org/.
*
*  In the case of this particular program, POVLEGAL.DOC is also embedded
*  in the source code. See the file ../PVLEGAL.H.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* Thanks to the makers of PERFORCE (http://www.perforce.com/) for donating the
* copy of their Perforce revision control system that is now used to maintain
* the POVWIN source. Thanks also to WinMain Software (http://www.winmain.com/)
* for providing the CodeMax edit control which the POVWIN 3.1 editor is based
* upon.
*
* $Id: //depot/POVRAY/povwin/source/windows/codemax/SaveFailed.h#2$
*
*****************************************************************************/

#ifndef SaveFailedH
#define SaveFailedH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
//---------------------------------------------------------------------------
class TSaveFailedForm : public TForm
{
  __published:
    TLabel *MessageLabel;
    TBitBtn *BitBtn1;
    TBitBtn *BitBtn3;
    TBitBtn *BitBtn4;

  private:
    bool FSaveAll ;
    bool FDiscardAll ;
    void __fastcall SetText (AnsiString text) { MessageLabel->Caption = text ; }
    AnsiString __fastcall GetText (void) { return (MessageLabel->Caption) ; }

  public:
    __fastcall TSaveFailedForm(TComponent* Owner);
    int __fastcall ShowModal (AnsiString Filename) ;

  __published:
    __property AnsiString Text = {read = GetText, write = SetText} ;
};
//---------------------------------------------------------------------------
extern PACKAGE TSaveFailedForm *SaveFailedForm;
//---------------------------------------------------------------------------
#endif
