

//This scene is a demo of my eval_pattern patch, it also uses my cloth 
//pattern and the solid pattern. Note that my most recently released patch 
//includes the reflectivity patch, which I plan to remove in the next 
//version. I have a few things I would like to change about it, and it 
//isn't backwards compatable.
#include "colors.inc"
#include "textures.inc"
#version unofficial MegaPov 0.4;
//-------------------------------------------
#declare groundPlane = yes;
//-------------------------------------------
global_settings {
   assumed_gamma 1.8
}

camera {
   location < 2, 4, -6>
   angle 35
   look_at < 0, 1, 0 >
}
#if(groundPlane = yes)
   plane {y, 0
      texture {
         pigment {crackle
            scallop_wave
            color_map {
               [0 color Gray65]
               [1 color White]
            }
         }
         finish {
            diffuse 1
            ambient 0
          reflection 0.2
         }
      }
   }
#end
//*******************************************

#declare xSize = 80;
#declare zSize = 80;

union {
   #declare J=0;
   #while(J< xSize)
         #declare L=0;
         #while(L< zSize)
            #declare Pos = <(J-(xSize/2))/xSize, 0, (L-(zSize/2))/zSize>*2;
          #declare Val = eval_pattern(leopard scale 0.5, Pos);
            sphere {< (1/xSize)/2, 0.01, (1/zSize)/2>, 0.01
               pigment { solid Val
                  color_map {
                     [0 color Blue]
                     [0.3 color Red]
                     [0.67 color Yellow]
                     [1 color White]
                  }
               }
               finish {ambient 1 diffuse 1}
               translate Pos + y*Val
            }
            #declare L=L+1;
      #end
      #declare J=J+1;
   #end
   scale 2
}


//*******************************************

light_source { < -30, 75, -60 >*100 color White }
light_source { < 30, 15, -30 >*100 color White*0.25}

//-------------------------------------------

