camera {
	perspective 
	location <0.0, 0.0, -7>
	up y*image_height right x*image_width
	angle 60
	look_at <0.0, 0.0, 0.0>
	rotate x*7
}
light_source {
	<10, 50, -50>
	rgb <1.0, 1.0, 1.0>*1.2
}
#declare NoiseOn = true;

#declare C = 0;
#declare Copies = 400;

#while ( C < Copies)
	sphere {
		<0.0, 0.0, 0.0>, 0.1

		translate x * (2)
		rotate y * (0.0 + (C * (360*5)/(Copies -1)))
		translate y * ((-3 + (C * (2 - (-3))/(Copies -1)))#if (NoiseOn = 1)+noise3d(<0.03*C, 0.009*C, 0.009*C>)#end)
		#declare R = (1.000000 + (C * (0.978378 -(1.000000))/(Copies -1)));
		#declare G = (0.000000 + (C * (1.000000 -(0.000000))/(Copies -1)));
		#declare B = (0.000000 + (C * (0.350027 -(0.000000))/(Copies -1)));
		#declare F = (0 + (C * (0 -(0))/(Copies -1)));
		#declare T = (0 + (C * (0 -(0))/(Copies -1)));
		texture { pigment { rgbft <R, G, B, F, T> } }
	} //object
//	#debug "G=\n"	#debug str(F, 5, 5)
	#declare C = C +1;
#end  //while (C < Copies)


