//	Persistence of Vision Ray Tracer Scene Description File
//	Demo to show the use of 'orient' with area_lights
//	Date: 29 april 2000
//	Author: R. Smellenbergh, based on Glen Berry's Orient_Test_2.pov

#version unofficial MegaPov 0.5;


global_settings {
	// another way to ensure the intended image ratio is used
	#declare HeightString=str (image_width*3/4, 1, 0)
	#declare HeightString=concat ("Height=", HeightString)
	ini_option HeightString	
}

camera {
	location <0.0, 0.0, -600>
	up y*image_height right x*image_width
	angle 40
	look_at <0.0, 0.0, 0.0>
}

#declare Grid = 2;	// change to higher value for smoother shadows (slower!!)

//******* With orient keyword *************
#declare C = 0;
#declare Copies = 5;
#while ( C < Copies)
	sphere {
		<0.0, 0.0, -6.5>, 13
		texture { pigment { rgb <0.305882, 0.674510, 0.866667> } }
		translate y * (50)
		rotate z * (0 + (C * (180/4)))
		light_group "Orient"
		translate x*-45
	} //object
	#declare C = C +1;
#end  //while (C < Copies)
 
light_source {
	<-45, 0, -30>
	rgb <1.0, 1.0, 1.0>
	area_light < -20,  0.0, -20 >,   <20, 0.0, 20>,  Grid,  Grid
	adaptive 1
	jitter 
	orient 
	groups "Orient"
}
box {
	<-300, -300, 0>, <0, 300, 1>
	pigment { rgb 1.0 }
	finish { ambient 0.2 diffuse 0.8 }
	light_group "Orient"
}
text {
	ttf "crystal",
	"orient"
	0.2, <0.0, 0.0, 0.0>
	align_right
	no_shadow
	texture { pigment { rgb <0.305882, 0.674510, 0.866667> } finish { ambient 0.8 }}
	scale 25
	translate <-30, -100, -0.1>
}

//************** Classic area_light *****************
#declare C = 0;
#declare Copies = 5;
#while ( C < Copies)
	sphere {
		<0.0, 0.0, -6.5>, 13
		texture { pigment { rgb <1.000000, 0.639216, 0.266667> } }
		translate y * (50)
		rotate z * (0 + (C * (-180/4)))
		light_group "Standard"
		translate x*45
	} //object
	#declare C = C +1;
#end  //while (C < Copies)

light_source {
	<45, 0, -30>
	rgb 1.0
	area_light < -20,  0.0, -20 >,   <20, 0.0, 20>,  Grid,  Grid
	adaptive 1
	jitter 
	groups "Standard"
}
box {
	<0, -300, 0>, <300, 300, 1>
	pigment { rgb 1.0 }
	finish { ambient 0.2 diffuse 0.8 }
	light_group "Standard"
}
text {
	ttf "crystal",
	"standard"
	0.2, <0.0, 0.0, 0.0>
	align_left
	no_shadow
	texture { pigment { rgb <1.000000, 0.639216, 0.266667> } finish { ambient 0.8 }}
	scale 25
	translate <30, -100, -0.1>
}


