#version unofficial MegaPov 0.4;

background {rgb .3}

camera { location <-3,3,-5> look_at y}
light_source {<-5,3,-5> rgb 1.5}
                       
#declare F1=function{pigment{cylindrical scale .25}}
#declare turb2=function{y*y*noise3d(x,y,z)/9}
#declare turb1=function{y*y*noise3d(x+turb2(x,y,z),
                           y+turb2(x+10,y,z+10),
                           z+turb2(x+20,y,z+20))/81}
#declare varturb=function {F1(x+y*turb1(x,y,z),
                           y+turb1(x+10,y,z+10),
                           z+turb1(x+20,y,z+20))}

                       
cylinder {0,4*y,1
  pigment {color rgbt 1}
  hollow
  interior {
    media {
      intervals 10
      density {function{varturb(x,y,z)}}
      scale <.3,.5,.3>
      scattering {0 rgb 2}
    }
  }
} 

cylinder {-.1*x, 1.9*x, .1
  texture {    
    pigment {
      gradient x
      pigment_map {
        [ .03 bozo 
              color_map {
                [0 rgb .3]
                [1 rgb .7]
              } 
              scale .001 
        ]
        [ .05 color rgb <2,.8,0>]
        [ .05 color rgb 1 ]
        [ .7 color rgb 1 ]
        [ .7 leopard 
             color_map {
               [0 rgb <.8,.5,0>]
               [1 rgb <1,1,0>]
             } 
             turbulence .5 
             scale .005 
        ]
      }
      scale 2.001
      translate -.1*x
    }
  }
}
