/* isoblob_test.pov */
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"

camera {
  location -10*z
  direction z*1.5
  up y right x*4/3
  look_at 0
  }

background {color 0.5}
light_source {<-5,5,-5> color White}

isoblob {
  threshold 0.2
  accuracy 0.001
  max_trace 10
  
  function {max(1-sqrt(sqr(x)+sqr(y)+sqr(z)+noise3d(r,s,t)/5),0)}
  function {max(1-sqrt(sqr(x)+sqr(y)+noise3d(r,s,t)/5),0)}

  sphere {<0,0,0>, 1 strength 1 function 1 scale 2}
  cylinder {<0,0.5,0>, <5,0.5,0>, 1.5 strength 0.9 function 2}
  cylinder {<-1,0,0>, <-5,0,0>, 1.5 strength 0.5 function 2}

  texture {
    pigment {checker color Blue color Red}
    finish {ambient 0.5}
    }
  }

