//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 4 materials and 4 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 03/09/1999    (09.03.1999)
//
#version unofficial MegaPov 0.4;

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default { texture { pigment { rgb <1,0,0> } }
}

/* // Scene Comment

This scene was created with Moray For Windows.

Author: Nathan Kopp

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
	ini_option "+QR"
  radiosity {
    pretrace_start 0.04
    pretrace_end 0.02
    brightness       2.8
    count            100
    error_bound      0.5
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }

  photons{
	count 20000
    gather 20,100
    autostop 0
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <     -1.978,      -2.682,       2.513>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,       0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.000, -20.000, 14.810>  
  color rgb <1.000, 1.000, 1.000>*.75
  //area_light x,y,3,3
}
light_source {   // Light1
  < -20.000,0, 14.810>  
  color rgb <1.000, 1.000, 1.000>*.5
  //area_light x,y,3,3
}
light_source {   // Light1
  <20.000, -20.000, 14.810>  
  color rgb <1.000, 1.000, 1.000>*.25
  //area_light x,y,3,3
}


//
// ********  MATERIALS  *******
//

#include "reflection.inc"
#include "colors.inc"
#include "woods.inc"

//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

plane { // Plane001
  z,0
#version 3.1;  // this allows old version of wood layered texture
  texture{
    T_Wood34
    scale 5
    rotate <85,0,45>
  }
#version 3.14159;
}


difference { // CSG001
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.975, 0.975, 1.2>
    translate  -0.1*z
  }
  material { Copper_Metal }
  scale <1.0, 1.0, 0.5>

  photons {
	target 1.0
    reflection on
    //ignore_photons
  }
}




